/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.transform.HlsIngestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An HTTP Live Streaming (HLS) ingest resource configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public class HlsIngest implements StructuredPojo, ToCopyableBuilder<HlsIngest.Builder, HlsIngest> {
    private final List<IngestEndpoint> ingestEndpoints;

    private HlsIngest(BuilderImpl builder) {
        this.ingestEndpoints = builder.ingestEndpoints;
    }

    /**
     * A list of endpoints to which the source stream should be sent.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of endpoints to which the source stream should be sent.
     */
    public List<IngestEndpoint> ingestEndpoints() {
        return ingestEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ingestEndpoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsIngest)) {
            return false;
        }
        HlsIngest other = (HlsIngest) obj;
        return Objects.equals(ingestEndpoints(), other.ingestEndpoints());
    }

    @Override
    public String toString() {
        return ToString.builder("HlsIngest").add("IngestEndpoints", ingestEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IngestEndpoints":
            return Optional.of(clazz.cast(ingestEndpoints()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsIngestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, HlsIngest> {
        /**
         * A list of endpoints to which the source stream should be sent.
         * 
         * @param ingestEndpoints
         *        A list of endpoints to which the source stream should be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestEndpoints(Collection<IngestEndpoint> ingestEndpoints);

        /**
         * A list of endpoints to which the source stream should be sent.
         * 
         * @param ingestEndpoints
         *        A list of endpoints to which the source stream should be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestEndpoints(IngestEndpoint... ingestEndpoints);
    }

    static final class BuilderImpl implements Builder {
        private List<IngestEndpoint> ingestEndpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsIngest model) {
            ingestEndpoints(model.ingestEndpoints);
        }

        public final Collection<IngestEndpoint.Builder> getIngestEndpoints() {
            return ingestEndpoints != null ? ingestEndpoints.stream().map(IngestEndpoint::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ingestEndpoints(Collection<IngestEndpoint> ingestEndpoints) {
            this.ingestEndpoints = ListOfIngestEndpointCopier.copy(ingestEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpoints(IngestEndpoint... ingestEndpoints) {
            ingestEndpoints(Arrays.asList(ingestEndpoints));
            return this;
        }

        public final void setIngestEndpoints(Collection<IngestEndpoint.BuilderImpl> ingestEndpoints) {
            this.ingestEndpoints = ListOfIngestEndpointCopier.copyFromBuilder(ingestEndpoints);
        }

        @Override
        public HlsIngest build() {
            return new HlsIngest(this);
        }
    }
}
