/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.transform.IngestEndpointMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An endpoint for ingesting source content for a Channel.
 */
@Generated("software.amazon.awssdk:codegen")
public class IngestEndpoint implements StructuredPojo, ToCopyableBuilder<IngestEndpoint.Builder, IngestEndpoint> {
    private final String password;

    private final String url;

    private final String username;

    private IngestEndpoint(BuilderImpl builder) {
        this.password = builder.password;
        this.url = builder.url;
        this.username = builder.username;
    }

    /**
     * The system generated password for ingest authentication.
     * 
     * @return The system generated password for ingest authentication.
     */
    public String password() {
        return password;
    }

    /**
     * The ingest URL to which the source stream should be sent.
     * 
     * @return The ingest URL to which the source stream should be sent.
     */
    public String url() {
        return url;
    }

    /**
     * The system generated username for ingest authentication.
     * 
     * @return The system generated username for ingest authentication.
     */
    public String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestEndpoint)) {
            return false;
        }
        IngestEndpoint other = (IngestEndpoint) obj;
        return Objects.equals(password(), other.password()) && Objects.equals(url(), other.url())
                && Objects.equals(username(), other.username());
    }

    @Override
    public String toString() {
        return ToString.builder("IngestEndpoint").add("Password", password()).add("Url", url()).add("Username", username())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Password":
            return Optional.of(clazz.cast(password()));
        case "Url":
            return Optional.of(clazz.cast(url()));
        case "Username":
            return Optional.of(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IngestEndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, IngestEndpoint> {
        /**
         * The system generated password for ingest authentication.
         * 
         * @param password
         *        The system generated password for ingest authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * The ingest URL to which the source stream should be sent.
         * 
         * @param url
         *        The ingest URL to which the source stream should be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * The system generated username for ingest authentication.
         * 
         * @param username
         *        The system generated username for ingest authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private String password;

        private String url;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestEndpoint model) {
            password(model.password);
            url(model.url);
            username(model.username);
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public IngestEndpoint build() {
            return new IngestEndpoint(this);
        }
    }
}
