/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOriginEndpointsResponse extends MediaPackageResponse implements
        ToCopyableBuilder<ListOriginEndpointsResponse.Builder, ListOriginEndpointsResponse> {
    private final String nextToken;

    private final List<OriginEndpoint> originEndpoints;

    private ListOriginEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.originEndpoints = builder.originEndpoints;
    }

    /**
     * A token that can be used to resume pagination from the end of the collection.
     * 
     * @return A token that can be used to resume pagination from the end of the collection.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * A list of OriginEndpoint records.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of OriginEndpoint records.
     */
    public List<OriginEndpoint> originEndpoints() {
        return originEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOriginEndpointsResponse)) {
            return false;
        }
        ListOriginEndpointsResponse other = (ListOriginEndpointsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(originEndpoints(), other.originEndpoints());
    }

    @Override
    public String toString() {
        return ToString.builder("ListOriginEndpointsResponse").add("NextToken", nextToken())
                .add("OriginEndpoints", originEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "OriginEndpoints":
            return Optional.of(clazz.cast(originEndpoints()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MediaPackageResponse.Builder, CopyableBuilder<Builder, ListOriginEndpointsResponse> {
        /**
         * A token that can be used to resume pagination from the end of the collection.
         * 
         * @param nextToken
         *        A token that can be used to resume pagination from the end of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * A list of OriginEndpoint records.
         * 
         * @param originEndpoints
         *        A list of OriginEndpoint records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpoints(Collection<OriginEndpoint> originEndpoints);

        /**
         * A list of OriginEndpoint records.
         * 
         * @param originEndpoints
         *        A list of OriginEndpoint records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpoints(OriginEndpoint... originEndpoints);
    }

    static final class BuilderImpl extends MediaPackageResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<OriginEndpoint> originEndpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOriginEndpointsResponse model) {
            nextToken(model.nextToken);
            originEndpoints(model.originEndpoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<OriginEndpoint.Builder> getOriginEndpoints() {
            return originEndpoints != null ? originEndpoints.stream().map(OriginEndpoint::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder originEndpoints(Collection<OriginEndpoint> originEndpoints) {
            this.originEndpoints = ListOfOriginEndpointCopier.copy(originEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originEndpoints(OriginEndpoint... originEndpoints) {
            originEndpoints(Arrays.asList(originEndpoints));
            return this;
        }

        public final void setOriginEndpoints(Collection<OriginEndpoint.BuilderImpl> originEndpoints) {
            this.originEndpoints = ListOfOriginEndpointCopier.copyFromBuilder(originEndpoints);
        }

        @Override
        public ListOriginEndpointsResponse build() {
            return new ListOriginEndpointsResponse(this);
        }
    }
}
