/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.HlsEncryption;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link HlsEncryption} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class HlsEncryptionMarshaller {
    private static final MarshallingInfo<String> CONSTANTINITIALIZATIONVECTOR_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("constantInitializationVector").isBinary(false).build();

    private static final MarshallingInfo<String> ENCRYPTIONMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionMethod").isBinary(false).build();

    private static final MarshallingInfo<Integer> KEYROTATIONINTERVALSECONDS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("keyRotationIntervalSeconds").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REPEATEXTXKEY_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repeatExtXKey").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SPEKEKEYPROVIDER_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("spekeKeyProvider").isBinary(false).build();

    private static final HlsEncryptionMarshaller INSTANCE = new HlsEncryptionMarshaller();

    private HlsEncryptionMarshaller() {
    }

    public static HlsEncryptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(HlsEncryption hlsEncryption, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(hlsEncryption, "hlsEncryption");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(hlsEncryption.constantInitializationVector(), CONSTANTINITIALIZATIONVECTOR_BINDING);
            protocolMarshaller.marshall(hlsEncryption.encryptionMethodString(), ENCRYPTIONMETHOD_BINDING);
            protocolMarshaller.marshall(hlsEncryption.keyRotationIntervalSeconds(), KEYROTATIONINTERVALSECONDS_BINDING);
            protocolMarshaller.marshall(hlsEncryption.repeatExtXKey(), REPEATEXTXKEY_BINDING);
            protocolMarshaller.marshall(hlsEncryption.spekeKeyProvider(), SPEKEKEYPROVIDER_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
