/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.mediapackage.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UpdateOriginEndpointResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateOriginEndpointResponseUnmarshaller implements
        Unmarshaller<UpdateOriginEndpointResponse, JsonUnmarshallerContext> {

    public UpdateOriginEndpointResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpdateOriginEndpointResponse.Builder updateOriginEndpointResponseBuilder = UpdateOriginEndpointResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return updateOriginEndpointResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("channelId", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.channelId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("dashPackage", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.dashPackage(DashPackageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("hlsPackage", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.hlsPackage(HlsPackageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.id(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("manifestName", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.manifestName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("mssPackage", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.mssPackage(MssPackageUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("startoverWindowSeconds", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.startoverWindowSeconds(context.getUnmarshaller(Integer.class).unmarshall(
                            context));
                }
                if (context.testExpression("timeDelaySeconds", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.timeDelaySeconds(context.getUnmarshaller(Integer.class).unmarshall(
                            context));
                }
                if (context.testExpression("url", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.url(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("whitelist", targetDepth)) {
                    context.nextToken();
                    updateOriginEndpointResponseBuilder.whitelist(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return updateOriginEndpointResponseBuilder.build();
    }

    private static final UpdateOriginEndpointResponseUnmarshaller INSTANCE = new UpdateOriginEndpointResponseUnmarshaller();

    public static UpdateOriginEndpointResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
