/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.DashEncryption;
import software.amazon.awssdk.services.mediapackage.model.Profile;
import software.amazon.awssdk.services.mediapackage.model.StreamSelection;
import software.amazon.awssdk.services.mediapackage.transform.DashPackageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DashPackage
implements StructuredPojo,
ToCopyableBuilder<Builder, DashPackage> {
    private final DashEncryption encryption;
    private final Integer manifestWindowSeconds;
    private final Integer minBufferTimeSeconds;
    private final Integer minUpdatePeriodSeconds;
    private final String profile;
    private final Integer segmentDurationSeconds;
    private final StreamSelection streamSelection;
    private final Integer suggestedPresentationDelaySeconds;

    private DashPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
        this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
        this.profile = builder.profile;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.streamSelection = builder.streamSelection;
        this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
    }

    public DashEncryption encryption() {
        return this.encryption;
    }

    public Integer manifestWindowSeconds() {
        return this.manifestWindowSeconds;
    }

    public Integer minBufferTimeSeconds() {
        return this.minBufferTimeSeconds;
    }

    public Integer minUpdatePeriodSeconds() {
        return this.minUpdatePeriodSeconds;
    }

    public Profile profile() {
        return Profile.fromValue(this.profile);
    }

    public String profileString() {
        return this.profile;
    }

    public Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public StreamSelection streamSelection() {
        return this.streamSelection;
    }

    public Integer suggestedPresentationDelaySeconds() {
        return this.suggestedPresentationDelaySeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.minUpdatePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestedPresentationDelaySeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashPackage)) {
            return false;
        }
        DashPackage other = (DashPackage)obj;
        return Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.manifestWindowSeconds(), other.manifestWindowSeconds()) && Objects.equals(this.minBufferTimeSeconds(), other.minBufferTimeSeconds()) && Objects.equals(this.minUpdatePeriodSeconds(), other.minUpdatePeriodSeconds()) && Objects.equals(this.profileString(), other.profileString()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.streamSelection(), other.streamSelection()) && Objects.equals(this.suggestedPresentationDelaySeconds(), other.suggestedPresentationDelaySeconds());
    }

    public String toString() {
        return ToString.builder((String)"DashPackage").add("Encryption", (Object)this.encryption()).add("ManifestWindowSeconds", (Object)this.manifestWindowSeconds()).add("MinBufferTimeSeconds", (Object)this.minBufferTimeSeconds()).add("MinUpdatePeriodSeconds", (Object)this.minUpdatePeriodSeconds()).add("Profile", (Object)this.profileString()).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("StreamSelection", (Object)this.streamSelection()).add("SuggestedPresentationDelaySeconds", (Object)this.suggestedPresentationDelaySeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encryption": {
                return Optional.of(clazz.cast(this.encryption()));
            }
            case "ManifestWindowSeconds": {
                return Optional.of(clazz.cast(this.manifestWindowSeconds()));
            }
            case "MinBufferTimeSeconds": {
                return Optional.of(clazz.cast(this.minBufferTimeSeconds()));
            }
            case "MinUpdatePeriodSeconds": {
                return Optional.of(clazz.cast(this.minUpdatePeriodSeconds()));
            }
            case "Profile": {
                return Optional.of(clazz.cast(this.profileString()));
            }
            case "SegmentDurationSeconds": {
                return Optional.of(clazz.cast(this.segmentDurationSeconds()));
            }
            case "StreamSelection": {
                return Optional.of(clazz.cast(this.streamSelection()));
            }
            case "SuggestedPresentationDelaySeconds": {
                return Optional.of(clazz.cast(this.suggestedPresentationDelaySeconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DashPackageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private DashEncryption encryption;
        private Integer manifestWindowSeconds;
        private Integer minBufferTimeSeconds;
        private Integer minUpdatePeriodSeconds;
        private String profile;
        private Integer segmentDurationSeconds;
        private StreamSelection streamSelection;
        private Integer suggestedPresentationDelaySeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DashPackage model) {
            this.encryption(model.encryption);
            this.manifestWindowSeconds(model.manifestWindowSeconds);
            this.minBufferTimeSeconds(model.minBufferTimeSeconds);
            this.minUpdatePeriodSeconds(model.minUpdatePeriodSeconds);
            this.profile(model.profile);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.streamSelection(model.streamSelection);
            this.suggestedPresentationDelaySeconds(model.suggestedPresentationDelaySeconds);
        }

        public final DashEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(DashEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(DashEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getManifestWindowSeconds() {
            return this.manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        public final Integer getMinBufferTimeSeconds() {
            return this.minBufferTimeSeconds;
        }

        @Override
        public final Builder minBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
            return this;
        }

        public final void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
        }

        public final Integer getMinUpdatePeriodSeconds() {
            return this.minUpdatePeriodSeconds;
        }

        @Override
        public final Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
            return this;
        }

        public final void setMinUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
        }

        public final String getProfile() {
            return this.profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(Profile profile) {
            this.profile(profile.toString());
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return this.streamSelection != null ? this.streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public final Integer getSuggestedPresentationDelaySeconds() {
            return this.suggestedPresentationDelaySeconds;
        }

        @Override
        public final Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
            return this;
        }

        public final void setSuggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
        }

        public DashPackage build() {
            return new DashPackage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DashPackage> {
        public Builder encryption(DashEncryption var1);

        default public Builder encryption(Consumer<DashEncryption.Builder> encryption) {
            return this.encryption((DashEncryption)((DashEncryption.Builder)DashEncryption.builder().apply(encryption)).build());
        }

        public Builder manifestWindowSeconds(Integer var1);

        public Builder minBufferTimeSeconds(Integer var1);

        public Builder minUpdatePeriodSeconds(Integer var1);

        public Builder profile(String var1);

        public Builder profile(Profile var1);

        public Builder segmentDurationSeconds(Integer var1);

        public Builder streamSelection(StreamSelection var1);

        default public Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return this.streamSelection((StreamSelection)((StreamSelection.Builder)StreamSelection.builder().apply(streamSelection)).build());
        }

        public Builder suggestedPresentationDelaySeconds(Integer var1);
    }
}

