/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.IngestEndpoint;
import software.amazon.awssdk.services.mediapackage.model.ListOfIngestEndpointCopier;
import software.amazon.awssdk.services.mediapackage.transform.HlsIngestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsIngest
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsIngest> {
    private final List<IngestEndpoint> ingestEndpoints;

    private HlsIngest(BuilderImpl builder) {
        this.ingestEndpoints = builder.ingestEndpoints;
    }

    public List<IngestEndpoint> ingestEndpoints() {
        return this.ingestEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestEndpoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsIngest)) {
            return false;
        }
        HlsIngest other = (HlsIngest)obj;
        return Objects.equals(this.ingestEndpoints(), other.ingestEndpoints());
    }

    public String toString() {
        return ToString.builder((String)"HlsIngest").add("IngestEndpoints", this.ingestEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IngestEndpoints": {
                return Optional.of(clazz.cast(this.ingestEndpoints()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsIngestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<IngestEndpoint> ingestEndpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsIngest model) {
            this.ingestEndpoints(model.ingestEndpoints);
        }

        public final Collection<IngestEndpoint.Builder> getIngestEndpoints() {
            return this.ingestEndpoints != null ? (Collection)this.ingestEndpoints.stream().map(IngestEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ingestEndpoints(Collection<IngestEndpoint> ingestEndpoints) {
            this.ingestEndpoints = ListOfIngestEndpointCopier.copy(ingestEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpoints(IngestEndpoint ... ingestEndpoints) {
            this.ingestEndpoints(Arrays.asList(ingestEndpoints));
            return this;
        }

        public final void setIngestEndpoints(Collection<IngestEndpoint.BuilderImpl> ingestEndpoints) {
            this.ingestEndpoints = ListOfIngestEndpointCopier.copyFromBuilder(ingestEndpoints);
        }

        public HlsIngest build() {
            return new HlsIngest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsIngest> {
        public Builder ingestEndpoints(Collection<IngestEndpoint> var1);

        public Builder ingestEndpoints(IngestEndpoint ... var1);
    }
}

