/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.AdMarkers;
import software.amazon.awssdk.services.mediapackage.model.HlsEncryption;
import software.amazon.awssdk.services.mediapackage.model.PlaylistType;
import software.amazon.awssdk.services.mediapackage.model.StreamSelection;
import software.amazon.awssdk.services.mediapackage.transform.HlsPackageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsPackage
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsPackage> {
    private final String adMarkers;
    private final HlsEncryption encryption;
    private final Boolean includeIframeOnlyStream;
    private final String playlistType;
    private final Integer playlistWindowSeconds;
    private final Integer programDateTimeIntervalSeconds;
    private final Integer segmentDurationSeconds;
    private final StreamSelection streamSelection;
    private final Boolean useAudioRenditionGroup;

    private HlsPackage(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.encryption = builder.encryption;
        this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
        this.playlistType = builder.playlistType;
        this.playlistWindowSeconds = builder.playlistWindowSeconds;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.streamSelection = builder.streamSelection;
        this.useAudioRenditionGroup = builder.useAudioRenditionGroup;
    }

    public AdMarkers adMarkers() {
        return AdMarkers.fromValue(this.adMarkers);
    }

    public String adMarkersString() {
        return this.adMarkers;
    }

    public HlsEncryption encryption() {
        return this.encryption;
    }

    public Boolean includeIframeOnlyStream() {
        return this.includeIframeOnlyStream;
    }

    public PlaylistType playlistType() {
        return PlaylistType.fromValue(this.playlistType);
    }

    public String playlistTypeString() {
        return this.playlistType;
    }

    public Integer playlistWindowSeconds() {
        return this.playlistWindowSeconds;
    }

    public Integer programDateTimeIntervalSeconds() {
        return this.programDateTimeIntervalSeconds;
    }

    public Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public StreamSelection streamSelection() {
        return this.streamSelection;
    }

    public Boolean useAudioRenditionGroup() {
        return this.useAudioRenditionGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adMarkersString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeIframeOnlyStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.playlistTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.playlistWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimeIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.useAudioRenditionGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsPackage)) {
            return false;
        }
        HlsPackage other = (HlsPackage)obj;
        return Objects.equals(this.adMarkersString(), other.adMarkersString()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.includeIframeOnlyStream(), other.includeIframeOnlyStream()) && Objects.equals(this.playlistTypeString(), other.playlistTypeString()) && Objects.equals(this.playlistWindowSeconds(), other.playlistWindowSeconds()) && Objects.equals(this.programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.streamSelection(), other.streamSelection()) && Objects.equals(this.useAudioRenditionGroup(), other.useAudioRenditionGroup());
    }

    public String toString() {
        return ToString.builder((String)"HlsPackage").add("AdMarkers", (Object)this.adMarkersString()).add("Encryption", (Object)this.encryption()).add("IncludeIframeOnlyStream", (Object)this.includeIframeOnlyStream()).add("PlaylistType", (Object)this.playlistTypeString()).add("PlaylistWindowSeconds", (Object)this.playlistWindowSeconds()).add("ProgramDateTimeIntervalSeconds", (Object)this.programDateTimeIntervalSeconds()).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("StreamSelection", (Object)this.streamSelection()).add("UseAudioRenditionGroup", (Object)this.useAudioRenditionGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.of(clazz.cast(this.adMarkersString()));
            }
            case "Encryption": {
                return Optional.of(clazz.cast(this.encryption()));
            }
            case "IncludeIframeOnlyStream": {
                return Optional.of(clazz.cast(this.includeIframeOnlyStream()));
            }
            case "PlaylistType": {
                return Optional.of(clazz.cast(this.playlistTypeString()));
            }
            case "PlaylistWindowSeconds": {
                return Optional.of(clazz.cast(this.playlistWindowSeconds()));
            }
            case "ProgramDateTimeIntervalSeconds": {
                return Optional.of(clazz.cast(this.programDateTimeIntervalSeconds()));
            }
            case "SegmentDurationSeconds": {
                return Optional.of(clazz.cast(this.segmentDurationSeconds()));
            }
            case "StreamSelection": {
                return Optional.of(clazz.cast(this.streamSelection()));
            }
            case "UseAudioRenditionGroup": {
                return Optional.of(clazz.cast(this.useAudioRenditionGroup()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsPackageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String adMarkers;
        private HlsEncryption encryption;
        private Boolean includeIframeOnlyStream;
        private String playlistType;
        private Integer playlistWindowSeconds;
        private Integer programDateTimeIntervalSeconds;
        private Integer segmentDurationSeconds;
        private StreamSelection streamSelection;
        private Boolean useAudioRenditionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsPackage model) {
            this.adMarkers(model.adMarkers);
            this.encryption(model.encryption);
            this.includeIframeOnlyStream(model.includeIframeOnlyStream);
            this.playlistType(model.playlistType);
            this.playlistWindowSeconds(model.playlistWindowSeconds);
            this.programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.streamSelection(model.streamSelection);
            this.useAudioRenditionGroup(model.useAudioRenditionGroup);
        }

        public final String getAdMarkers() {
            return this.adMarkers;
        }

        @Override
        public final Builder adMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
            return this;
        }

        @Override
        public final Builder adMarkers(AdMarkers adMarkers) {
            this.adMarkers(adMarkers.toString());
            return this;
        }

        public final void setAdMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
        }

        public final HlsEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(HlsEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(HlsEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Boolean getIncludeIframeOnlyStream() {
            return this.includeIframeOnlyStream;
        }

        @Override
        public final Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
            return this;
        }

        public final void setIncludeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
        }

        public final String getPlaylistType() {
            return this.playlistType;
        }

        @Override
        public final Builder playlistType(String playlistType) {
            this.playlistType = playlistType;
            return this;
        }

        @Override
        public final Builder playlistType(PlaylistType playlistType) {
            this.playlistType(playlistType.toString());
            return this;
        }

        public final void setPlaylistType(String playlistType) {
            this.playlistType = playlistType;
        }

        public final Integer getPlaylistWindowSeconds() {
            return this.playlistWindowSeconds;
        }

        @Override
        public final Builder playlistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
            return this;
        }

        public final void setPlaylistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return this.programDateTimeIntervalSeconds;
        }

        @Override
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return this.streamSelection != null ? this.streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public final Boolean getUseAudioRenditionGroup() {
            return this.useAudioRenditionGroup;
        }

        @Override
        public final Builder useAudioRenditionGroup(Boolean useAudioRenditionGroup) {
            this.useAudioRenditionGroup = useAudioRenditionGroup;
            return this;
        }

        public final void setUseAudioRenditionGroup(Boolean useAudioRenditionGroup) {
            this.useAudioRenditionGroup = useAudioRenditionGroup;
        }

        public HlsPackage build() {
            return new HlsPackage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsPackage> {
        public Builder adMarkers(String var1);

        public Builder adMarkers(AdMarkers var1);

        public Builder encryption(HlsEncryption var1);

        default public Builder encryption(Consumer<HlsEncryption.Builder> encryption) {
            return this.encryption((HlsEncryption)((HlsEncryption.Builder)HlsEncryption.builder().apply(encryption)).build());
        }

        public Builder includeIframeOnlyStream(Boolean var1);

        public Builder playlistType(String var1);

        public Builder playlistType(PlaylistType var1);

        public Builder playlistWindowSeconds(Integer var1);

        public Builder programDateTimeIntervalSeconds(Integer var1);

        public Builder segmentDurationSeconds(Integer var1);

        public Builder streamSelection(StreamSelection var1);

        default public Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return this.streamSelection((StreamSelection)((StreamSelection.Builder)StreamSelection.builder().apply(streamSelection)).build());
        }

        public Builder useAudioRenditionGroup(Boolean var1);
    }
}

