/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediapackage.model.DashEncryption;
import software.amazon.awssdk.services.mediapackage.transform.SpekeKeyProviderUnmarshaller;

public class DashEncryptionUnmarshaller
implements Unmarshaller<DashEncryption, JsonUnmarshallerContext> {
    private static final DashEncryptionUnmarshaller INSTANCE = new DashEncryptionUnmarshaller();

    public DashEncryption unmarshall(JsonUnmarshallerContext context) throws Exception {
        DashEncryption.Builder dashEncryptionBuilder = DashEncryption.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("keyRotationIntervalSeconds", targetDepth)) {
                    context.nextToken();
                    dashEncryptionBuilder.keyRotationIntervalSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("spekeKeyProvider", targetDepth)) {
                    context.nextToken();
                    dashEncryptionBuilder.spekeKeyProvider(SpekeKeyProviderUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DashEncryption)dashEncryptionBuilder.build();
    }

    public static DashEncryptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

