/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.MssEncryption;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MssEncryptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> SPEKEKEYPROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spekeKeyProvider").isBinary(false).build();
    private static final MssEncryptionMarshaller INSTANCE = new MssEncryptionMarshaller();

    private MssEncryptionMarshaller() {
    }

    public static MssEncryptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MssEncryption mssEncryption, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mssEncryption, (String)"mssEncryption");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mssEncryption.spekeKeyProvider(), SPEKEKEYPROVIDER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

