/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHarvestJobsRequest extends MediaPackageRequest implements
        ToCopyableBuilder<ListHarvestJobsRequest.Builder, ListHarvestJobsRequest> {
    private static final SdkField<String> INCLUDE_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListHarvestJobsRequest::includeChannelId)).setter(setter(Builder::includeChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeChannelId").build())
            .build();

    private static final SdkField<String> INCLUDE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListHarvestJobsRequest::includeStatus)).setter(setter(Builder::includeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeStatus").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListHarvestJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListHarvestJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_CHANNEL_ID_FIELD,
            INCLUDE_STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String includeChannelId;

    private final String includeStatus;

    private final Integer maxResults;

    private final String nextToken;

    private ListHarvestJobsRequest(BuilderImpl builder) {
        super(builder);
        this.includeChannelId = builder.includeChannelId;
        this.includeStatus = builder.includeStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * When specified, the request will return only HarvestJobs associated with the given Channel ID.
     * 
     * @return When specified, the request will return only HarvestJobs associated with the given Channel ID.
     */
    public String includeChannelId() {
        return includeChannelId;
    }

    /**
     * When specified, the request will return only HarvestJobs in the given status.
     * 
     * @return When specified, the request will return only HarvestJobs in the given status.
     */
    public String includeStatus() {
        return includeStatus;
    }

    /**
     * The upper bound on the number of records to return.
     * 
     * @return The upper bound on the number of records to return.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * A token used to resume pagination from the end of a previous request.
     * 
     * @return A token used to resume pagination from the end of a previous request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(includeChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(includeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHarvestJobsRequest)) {
            return false;
        }
        ListHarvestJobsRequest other = (ListHarvestJobsRequest) obj;
        return Objects.equals(includeChannelId(), other.includeChannelId())
                && Objects.equals(includeStatus(), other.includeStatus()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHarvestJobsRequest").add("IncludeChannelId", includeChannelId())
                .add("IncludeStatus", includeStatus()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludeChannelId":
            return Optional.ofNullable(clazz.cast(includeChannelId()));
        case "IncludeStatus":
            return Optional.ofNullable(clazz.cast(includeStatus()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHarvestJobsRequest, T> g) {
        return obj -> g.apply((ListHarvestJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListHarvestJobsRequest> {
        /**
         * When specified, the request will return only HarvestJobs associated with the given Channel ID.
         * 
         * @param includeChannelId
         *        When specified, the request will return only HarvestJobs associated with the given Channel ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeChannelId(String includeChannelId);

        /**
         * When specified, the request will return only HarvestJobs in the given status.
         * 
         * @param includeStatus
         *        When specified, the request will return only HarvestJobs in the given status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeStatus(String includeStatus);

        /**
         * The upper bound on the number of records to return.
         * 
         * @param maxResults
         *        The upper bound on the number of records to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * A token used to resume pagination from the end of a previous request.
         * 
         * @param nextToken
         *        A token used to resume pagination from the end of a previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageRequest.BuilderImpl implements Builder {
        private String includeChannelId;

        private String includeStatus;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHarvestJobsRequest model) {
            super(model);
            includeChannelId(model.includeChannelId);
            includeStatus(model.includeStatus);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getIncludeChannelId() {
            return includeChannelId;
        }

        @Override
        public final Builder includeChannelId(String includeChannelId) {
            this.includeChannelId = includeChannelId;
            return this;
        }

        public final void setIncludeChannelId(String includeChannelId) {
            this.includeChannelId = includeChannelId;
        }

        public final String getIncludeStatus() {
            return includeStatus;
        }

        @Override
        public final Builder includeStatus(String includeStatus) {
            this.includeStatus = includeStatus;
            return this;
        }

        public final void setIncludeStatus(String includeStatus) {
            this.includeStatus = includeStatus;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHarvestJobsRequest build() {
            return new ListHarvestJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
