/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHarvestJobsResponse extends MediaPackageResponse implements
        ToCopyableBuilder<ListHarvestJobsResponse.Builder, ListHarvestJobsResponse> {
    private static final SdkField<List<HarvestJob>> HARVEST_JOBS_FIELD = SdkField
            .<List<HarvestJob>> builder(MarshallingType.LIST)
            .getter(getter(ListHarvestJobsResponse::harvestJobs))
            .setter(setter(Builder::harvestJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("harvestJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HarvestJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(HarvestJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListHarvestJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HARVEST_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<HarvestJob> harvestJobs;

    private final String nextToken;

    private ListHarvestJobsResponse(BuilderImpl builder) {
        super(builder);
        this.harvestJobs = builder.harvestJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the HarvestJobs property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHarvestJobs() {
        return harvestJobs != null && !(harvestJobs instanceof SdkAutoConstructList);
    }

    /**
     * A list of HarvestJob records.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHarvestJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of HarvestJob records.
     */
    public List<HarvestJob> harvestJobs() {
        return harvestJobs;
    }

    /**
     * A token that can be used to resume pagination from the end of the collection.
     * 
     * @return A token that can be used to resume pagination from the end of the collection.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(harvestJobs());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHarvestJobsResponse)) {
            return false;
        }
        ListHarvestJobsResponse other = (ListHarvestJobsResponse) obj;
        return Objects.equals(harvestJobs(), other.harvestJobs()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHarvestJobsResponse").add("HarvestJobs", harvestJobs()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HarvestJobs":
            return Optional.ofNullable(clazz.cast(harvestJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHarvestJobsResponse, T> g) {
        return obj -> g.apply((ListHarvestJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListHarvestJobsResponse> {
        /**
         * A list of HarvestJob records.
         * 
         * @param harvestJobs
         *        A list of HarvestJob records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder harvestJobs(Collection<HarvestJob> harvestJobs);

        /**
         * A list of HarvestJob records.
         * 
         * @param harvestJobs
         *        A list of HarvestJob records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder harvestJobs(HarvestJob... harvestJobs);

        /**
         * A list of HarvestJob records. This is a convenience that creates an instance of the {@link List
         * <HarvestJob>.Builder} avoiding the need to create one manually via {@link List<HarvestJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HarvestJob>.Builder#build()} is called immediately and its
         * result is passed to {@link #harvestJobs(List<HarvestJob>)}.
         * 
         * @param harvestJobs
         *        a consumer that will call methods on {@link List<HarvestJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #harvestJobs(List<HarvestJob>)
         */
        Builder harvestJobs(Consumer<HarvestJob.Builder>... harvestJobs);

        /**
         * A token that can be used to resume pagination from the end of the collection.
         * 
         * @param nextToken
         *        A token that can be used to resume pagination from the end of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaPackageResponse.BuilderImpl implements Builder {
        private List<HarvestJob> harvestJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHarvestJobsResponse model) {
            super(model);
            harvestJobs(model.harvestJobs);
            nextToken(model.nextToken);
        }

        public final Collection<HarvestJob.Builder> getHarvestJobs() {
            return harvestJobs != null ? harvestJobs.stream().map(HarvestJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder harvestJobs(Collection<HarvestJob> harvestJobs) {
            this.harvestJobs = ___listOfHarvestJobCopier.copy(harvestJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder harvestJobs(HarvestJob... harvestJobs) {
            harvestJobs(Arrays.asList(harvestJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder harvestJobs(Consumer<HarvestJob.Builder>... harvestJobs) {
            harvestJobs(Stream.of(harvestJobs).map(c -> HarvestJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHarvestJobs(Collection<HarvestJob.BuilderImpl> harvestJobs) {
            this.harvestJobs = ___listOfHarvestJobCopier.copyFromBuilder(harvestJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHarvestJobsResponse build() {
            return new ListHarvestJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
