/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOf__PeriodTriggersElementCopier {
    static List<String> copy(Collection<String> __listOf__PeriodTriggersElementParam) {
        if (__listOf__PeriodTriggersElementParam == null || __listOf__PeriodTriggersElementParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<String> __listOf__PeriodTriggersElementParamCopy = new ArrayList<>(__listOf__PeriodTriggersElementParam);
        return Collections.unmodifiableList(__listOf__PeriodTriggersElementParamCopy);
    }

    static List<String> copyEnumToString(Collection<PeriodTriggersElement> __listOf__PeriodTriggersElementParam) {
        if (__listOf__PeriodTriggersElementParam == null || __listOf__PeriodTriggersElementParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<String> __listOf__PeriodTriggersElementParamCopy = __listOf__PeriodTriggersElementParam.stream()
                .map(Object::toString).collect(toList());
        return Collections.unmodifiableList(__listOf__PeriodTriggersElementParamCopy);
    }

    static List<PeriodTriggersElement> copyStringToEnum(Collection<String> __listOf__PeriodTriggersElementParam) {
        if (__listOf__PeriodTriggersElementParam == null || __listOf__PeriodTriggersElementParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<PeriodTriggersElement> __listOf__PeriodTriggersElementParamCopy = __listOf__PeriodTriggersElementParam.stream()
                .map(PeriodTriggersElement::fromValue).collect(toList());
        return Collections.unmodifiableList(__listOf__PeriodTriggersElementParamCopy);
    }
}
