/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelResponse extends MediaPackageResponse implements
        ToCopyableBuilder<CreateChannelResponse.Builder, CreateChannelResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChannelResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChannelResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<HlsIngest> HLS_INGEST_FIELD = SdkField.<HlsIngest> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateChannelResponse::hlsIngest)).setter(setter(Builder::hlsIngest)).constructor(HlsIngest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsIngest").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChannelResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateChannelResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            HLS_INGEST_FIELD, ID_FIELD, TAGS_FIELD));

    private final String arn;

    private final String description;

    private final HlsIngest hlsIngest;

    private final String id;

    private final Map<String, String> tags;

    private CreateChannelResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.hlsIngest = builder.hlsIngest;
        this.id = builder.id;
        this.tags = builder.tags;
    }

    /**
     * The Amazon Resource Name (ARN) assigned to the Channel.
     * 
     * @return The Amazon Resource Name (ARN) assigned to the Channel.
     */
    public String arn() {
        return arn;
    }

    /**
     * A short text description of the Channel.
     * 
     * @return A short text description of the Channel.
     */
    public String description() {
        return description;
    }

    /**
     * Returns the value of the HlsIngest property for this object.
     * 
     * @return The value of the HlsIngest property for this object.
     */
    public HlsIngest hlsIngest() {
        return hlsIngest;
    }

    /**
     * The ID of the Channel.
     * 
     * @return The ID of the Channel.
     */
    public String id() {
        return id;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hlsIngest());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelResponse)) {
            return false;
        }
        CreateChannelResponse other = (CreateChannelResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(hlsIngest(), other.hlsIngest()) && Objects.equals(id(), other.id())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateChannelResponse").add("Arn", arn()).add("Description", description())
                .add("HlsIngest", hlsIngest()).add("Id", id()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HlsIngest":
            return Optional.ofNullable(clazz.cast(hlsIngest()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelResponse, T> g) {
        return obj -> g.apply((CreateChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelResponse> {
        /**
         * The Amazon Resource Name (ARN) assigned to the Channel.
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) assigned to the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * A short text description of the Channel.
         * 
         * @param description
         *        A short text description of the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the HlsIngest property for this object.
         *
         * @param hlsIngest
         *        The new value for the HlsIngest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsIngest(HlsIngest hlsIngest);

        /**
         * Sets the value of the HlsIngest property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsIngest.Builder} avoiding the need to create
         * one manually via {@link HlsIngest#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsIngest.Builder#build()} is called immediately and its result
         * is passed to {@link #hlsIngest(HlsIngest)}.
         * 
         * @param hlsIngest
         *        a consumer that will call methods on {@link HlsIngest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsIngest(HlsIngest)
         */
        default Builder hlsIngest(Consumer<HlsIngest.Builder> hlsIngest) {
            return hlsIngest(HlsIngest.builder().applyMutation(hlsIngest).build());
        }

        /**
         * The ID of the Channel.
         * 
         * @param id
         *        The ID of the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaPackageResponse.BuilderImpl implements Builder {
        private String arn;

        private String description;

        private HlsIngest hlsIngest;

        private String id;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelResponse model) {
            super(model);
            arn(model.arn);
            description(model.description);
            hlsIngest(model.hlsIngest);
            id(model.id);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final HlsIngest.Builder getHlsIngest() {
            return hlsIngest != null ? hlsIngest.toBuilder() : null;
        }

        @Override
        public final Builder hlsIngest(HlsIngest hlsIngest) {
            this.hlsIngest = hlsIngest;
            return this;
        }

        public final void setHlsIngest(HlsIngest.BuilderImpl hlsIngest) {
            this.hlsIngest = hlsIngest != null ? hlsIngest.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public CreateChannelResponse build() {
            return new CreateChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
