/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackage.model.S3Destination;
import software.amazon.awssdk.services.mediapackage.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HarvestJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HarvestJob> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HarvestJob.getter(HarvestJob::arn)).setter(HarvestJob.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HarvestJob.getter(HarvestJob::channelId)).setter(HarvestJob.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HarvestJob.getter(HarvestJob::createdAt)).setter(HarvestJob.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HarvestJob.getter(HarvestJob::endTime)).setter(HarvestJob.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HarvestJob.getter(HarvestJob::id)).setter(HarvestJob.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ORIGIN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HarvestJob.getter(HarvestJob::originEndpointId)).setter(HarvestJob.setter(Builder::originEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originEndpointId").build()}).build();
    private static final SdkField<S3Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HarvestJob.getter(HarvestJob::s3Destination)).setter(HarvestJob.setter(Builder::s3Destination)).constructor(S3Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HarvestJob.getter(HarvestJob::startTime)).setter(HarvestJob.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HarvestJob.getter(HarvestJob::statusAsString)).setter(HarvestJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_ID_FIELD, CREATED_AT_FIELD, END_TIME_FIELD, ID_FIELD, ORIGIN_ENDPOINT_ID_FIELD, S3_DESTINATION_FIELD, START_TIME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String channelId;
    private final String createdAt;
    private final String endTime;
    private final String id;
    private final String originEndpointId;
    private final S3Destination s3Destination;
    private final String startTime;
    private final String status;

    private HarvestJob(BuilderImpl builder) {
        this.arn = builder.arn;
        this.channelId = builder.channelId;
        this.createdAt = builder.createdAt;
        this.endTime = builder.endTime;
        this.id = builder.id;
        this.originEndpointId = builder.originEndpointId;
        this.s3Destination = builder.s3Destination;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    public String arn() {
        return this.arn;
    }

    public String channelId() {
        return this.channelId;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public String endTime() {
        return this.endTime;
    }

    public String id() {
        return this.id;
    }

    public String originEndpointId() {
        return this.originEndpointId;
    }

    public S3Destination s3Destination() {
        return this.s3Destination;
    }

    public String startTime() {
        return this.startTime;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HarvestJob)) {
            return false;
        }
        HarvestJob other = (HarvestJob)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.originEndpointId(), other.originEndpointId()) && Objects.equals(this.s3Destination(), other.s3Destination()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"HarvestJob").add("Arn", (Object)this.arn()).add("ChannelId", (Object)this.channelId()).add("CreatedAt", (Object)this.createdAt()).add("EndTime", (Object)this.endTime()).add("Id", (Object)this.id()).add("OriginEndpointId", (Object)this.originEndpointId()).add("S3Destination", (Object)this.s3Destination()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "OriginEndpointId": {
                return Optional.ofNullable(clazz.cast(this.originEndpointId()));
            }
            case "S3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HarvestJob, T> g) {
        return obj -> g.apply((HarvestJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String channelId;
        private String createdAt;
        private String endTime;
        private String id;
        private String originEndpointId;
        private S3Destination s3Destination;
        private String startTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(HarvestJob model) {
            this.arn(model.arn);
            this.channelId(model.channelId);
            this.createdAt(model.createdAt);
            this.endTime(model.endTime);
            this.id(model.id);
            this.originEndpointId(model.originEndpointId);
            this.s3Destination(model.s3Destination);
            this.startTime(model.startTime);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getOriginEndpointId() {
            return this.originEndpointId;
        }

        @Override
        public final Builder originEndpointId(String originEndpointId) {
            this.originEndpointId = originEndpointId;
            return this;
        }

        public final void setOriginEndpointId(String originEndpointId) {
            this.originEndpointId = originEndpointId;
        }

        public final S3Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public HarvestJob build() {
            return new HarvestJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HarvestJob> {
        public Builder arn(String var1);

        public Builder channelId(String var1);

        public Builder createdAt(String var1);

        public Builder endTime(String var1);

        public Builder id(String var1);

        public Builder originEndpointId(String var1);

        public Builder s3Destination(S3Destination var1);

        default public Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return this.s3Destination((S3Destination)((S3Destination.Builder)S3Destination.builder().applyMutation(s3Destination)).build());
        }

        public Builder startTime(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);
    }
}

