/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashPackage implements SdkPojo, Serializable, ToCopyableBuilder<DashPackage.Builder, DashPackage> {
    private static final SdkField<List<String>> AD_TRIGGERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DashPackage::adTriggersAsStrings))
            .setter(setter(Builder::adTriggersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adTriggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ADS_ON_DELIVERY_RESTRICTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashPackage::adsOnDeliveryRestrictionsAsString)).setter(setter(Builder::adsOnDeliveryRestrictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsOnDeliveryRestrictions").build())
            .build();

    private static final SdkField<DashEncryption> ENCRYPTION_FIELD = SdkField.<DashEncryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(DashPackage::encryption)).setter(setter(Builder::encryption)).constructor(DashEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<String> MANIFEST_LAYOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashPackage::manifestLayoutAsString)).setter(setter(Builder::manifestLayout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestLayout").build()).build();

    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::manifestWindowSeconds)).setter(setter(Builder::manifestWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestWindowSeconds").build())
            .build();

    private static final SdkField<Integer> MIN_BUFFER_TIME_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::minBufferTimeSeconds)).setter(setter(Builder::minBufferTimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTimeSeconds").build())
            .build();

    private static final SdkField<Integer> MIN_UPDATE_PERIOD_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::minUpdatePeriodSeconds)).setter(setter(Builder::minUpdatePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minUpdatePeriodSeconds").build())
            .build();

    private static final SdkField<List<String>> PERIOD_TRIGGERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DashPackage::periodTriggersAsStrings))
            .setter(setter(Builder::periodTriggersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodTriggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashPackage::profileAsString)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::segmentDurationSeconds)).setter(setter(Builder::segmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build())
            .build();

    private static final SdkField<String> SEGMENT_TEMPLATE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashPackage::segmentTemplateFormatAsString)).setter(setter(Builder::segmentTemplateFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentTemplateFormat").build())
            .build();

    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField
            .<StreamSelection> builder(MarshallingType.SDK_POJO).getter(getter(DashPackage::streamSelection))
            .setter(setter(Builder::streamSelection)).constructor(StreamSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()).build();

    private static final SdkField<Integer> SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::suggestedPresentationDelaySeconds))
            .setter(setter(Builder::suggestedPresentationDelaySeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedPresentationDelaySeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_TRIGGERS_FIELD,
            ADS_ON_DELIVERY_RESTRICTIONS_FIELD, ENCRYPTION_FIELD, MANIFEST_LAYOUT_FIELD, MANIFEST_WINDOW_SECONDS_FIELD,
            MIN_BUFFER_TIME_SECONDS_FIELD, MIN_UPDATE_PERIOD_SECONDS_FIELD, PERIOD_TRIGGERS_FIELD, PROFILE_FIELD,
            SEGMENT_DURATION_SECONDS_FIELD, SEGMENT_TEMPLATE_FORMAT_FIELD, STREAM_SELECTION_FIELD,
            SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> adTriggers;

    private final String adsOnDeliveryRestrictions;

    private final DashEncryption encryption;

    private final String manifestLayout;

    private final Integer manifestWindowSeconds;

    private final Integer minBufferTimeSeconds;

    private final Integer minUpdatePeriodSeconds;

    private final List<String> periodTriggers;

    private final String profile;

    private final Integer segmentDurationSeconds;

    private final String segmentTemplateFormat;

    private final StreamSelection streamSelection;

    private final Integer suggestedPresentationDelaySeconds;

    private DashPackage(BuilderImpl builder) {
        this.adTriggers = builder.adTriggers;
        this.adsOnDeliveryRestrictions = builder.adsOnDeliveryRestrictions;
        this.encryption = builder.encryption;
        this.manifestLayout = builder.manifestLayout;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
        this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
        this.periodTriggers = builder.periodTriggers;
        this.profile = builder.profile;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.segmentTemplateFormat = builder.segmentTemplateFormat;
        this.streamSelection = builder.streamSelection;
        this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
    }

    /**
     * Returns the value of the AdTriggers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the AdTriggers property for this object.
     */
    public List<AdTriggersElement> adTriggers() {
        return AdTriggersCopier.copyStringToEnum(adTriggers);
    }

    /**
     * Returns true if the AdTriggers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAdTriggers() {
        return adTriggers != null && !(adTriggers instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AdTriggers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the AdTriggers property for this object.
     */
    public List<String> adTriggersAsStrings() {
        return adTriggers;
    }

    /**
     * Returns the value of the AdsOnDeliveryRestrictions property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adsOnDeliveryRestrictions} will return {@link AdsOnDeliveryRestrictions#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #adsOnDeliveryRestrictionsAsString}.
     * </p>
     * 
     * @return The value of the AdsOnDeliveryRestrictions property for this object.
     * @see AdsOnDeliveryRestrictions
     */
    public AdsOnDeliveryRestrictions adsOnDeliveryRestrictions() {
        return AdsOnDeliveryRestrictions.fromValue(adsOnDeliveryRestrictions);
    }

    /**
     * Returns the value of the AdsOnDeliveryRestrictions property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adsOnDeliveryRestrictions} will return {@link AdsOnDeliveryRestrictions#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #adsOnDeliveryRestrictionsAsString}.
     * </p>
     * 
     * @return The value of the AdsOnDeliveryRestrictions property for this object.
     * @see AdsOnDeliveryRestrictions
     */
    public String adsOnDeliveryRestrictionsAsString() {
        return adsOnDeliveryRestrictions;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public DashEncryption encryption() {
        return encryption;
    }

    /**
     * Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements like
     * SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT, duplicate
     * elements are combined and presented at the AdaptationSet level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #manifestLayout}
     * will return {@link ManifestLayout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #manifestLayoutAsString}.
     * </p>
     * 
     * @return Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL,
     *         elements like SegmentTemplate and ContentProtection are included in each Representation. When set to
     *         COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
     * @see ManifestLayout
     */
    public ManifestLayout manifestLayout() {
        return ManifestLayout.fromValue(manifestLayout);
    }

    /**
     * Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements like
     * SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT, duplicate
     * elements are combined and presented at the AdaptationSet level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #manifestLayout}
     * will return {@link ManifestLayout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #manifestLayoutAsString}.
     * </p>
     * 
     * @return Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL,
     *         elements like SegmentTemplate and ContentProtection are included in each Representation. When set to
     *         COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
     * @see ManifestLayout
     */
    public String manifestLayoutAsString() {
        return manifestLayout;
    }

    /**
     * Time window (in seconds) contained in each manifest.
     * 
     * @return Time window (in seconds) contained in each manifest.
     */
    public Integer manifestWindowSeconds() {
        return manifestWindowSeconds;
    }

    /**
     * Minimum duration (in seconds) that a player will buffer media before starting the presentation.
     * 
     * @return Minimum duration (in seconds) that a player will buffer media before starting the presentation.
     */
    public Integer minBufferTimeSeconds() {
        return minBufferTimeSeconds;
    }

    /**
     * Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH) Media
     * Presentation Description (MPD).
     * 
     * @return Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP
     *         (DASH) Media Presentation Description (MPD).
     */
    public Integer minUpdatePeriodSeconds() {
        return minUpdatePeriodSeconds;
    }

    /**
     * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation
     * Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into
     * more than one period. If the list contains "ADS", new periods will be created where the Channel source contains
     * SCTE-35 ad markers.
     *
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPeriodTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
     *         Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not
     *         be partitioned into more than one period. If the list contains "ADS", new periods will be created where
     *         the Channel source contains SCTE-35 ad markers.
     */
    public List<PeriodTriggersElement> periodTriggers() {
        return ___listOf__PeriodTriggersElementCopier.copyStringToEnum(periodTriggers);
    }

    /**
     * Returns true if the PeriodTriggers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPeriodTriggers() {
        return periodTriggers != null && !(periodTriggers instanceof SdkAutoConstructList);
    }

    /**
     * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation
     * Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into
     * more than one period. If the list contains "ADS", new periods will be created where the Channel source contains
     * SCTE-35 ad markers.
     *
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPeriodTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
     *         Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not
     *         be partitioned into more than one period. If the list contains "ADS", new periods will be created where
     *         the Channel source contains SCTE-35 ad markers.
     */
    public List<String> periodTriggersAsStrings() {
        return periodTriggers;
    }

    /**
     * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant output
     * is enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link Profile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
     *         compliant output is enabled.
     * @see Profile
     */
    public Profile profile() {
        return Profile.fromValue(profile);
    }

    /**
     * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant output
     * is enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link Profile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
     *         compliant output is enabled.
     * @see Profile
     */
    public String profileAsString() {
        return profile;
    }

    /**
     * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source
     * segment duration.
     *
     * @return Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the
     *         source segment duration.
     */
    public Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    /**
     * Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
     * NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When set to
     * TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to
     * NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentTemplateFormat} will return {@link SegmentTemplateFormat#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #segmentTemplateFormatAsString}.
     * </p>
     * 
     * @return Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
     *         NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.
     *         When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media
     *         URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with
     *         $Number$ media URLs.
     * @see SegmentTemplateFormat
     */
    public SegmentTemplateFormat segmentTemplateFormat() {
        return SegmentTemplateFormat.fromValue(segmentTemplateFormat);
    }

    /**
     * Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
     * NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When set to
     * TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to
     * NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentTemplateFormat} will return {@link SegmentTemplateFormat#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #segmentTemplateFormatAsString}.
     * </p>
     * 
     * @return Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
     *         NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.
     *         When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media
     *         URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with
     *         $Number$ media URLs.
     * @see SegmentTemplateFormat
     */
    public String segmentTemplateFormatAsString() {
        return segmentTemplateFormat;
    }

    /**
     * Returns the value of the StreamSelection property for this object.
     * 
     * @return The value of the StreamSelection property for this object.
     */
    public StreamSelection streamSelection() {
        return streamSelection;
    }

    /**
     * Duration (in seconds) to delay live content before presentation.
     * 
     * @return Duration (in seconds) to delay live content before presentation.
     */
    public Integer suggestedPresentationDelaySeconds() {
        return suggestedPresentationDelaySeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adTriggersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(adsOnDeliveryRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(manifestLayoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(minBufferTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(minUpdatePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(periodTriggersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(segmentTemplateFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamSelection());
        hashCode = 31 * hashCode + Objects.hashCode(suggestedPresentationDelaySeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashPackage)) {
            return false;
        }
        DashPackage other = (DashPackage) obj;
        return Objects.equals(adTriggersAsStrings(), other.adTriggersAsStrings())
                && Objects.equals(adsOnDeliveryRestrictionsAsString(), other.adsOnDeliveryRestrictionsAsString())
                && Objects.equals(encryption(), other.encryption())
                && Objects.equals(manifestLayoutAsString(), other.manifestLayoutAsString())
                && Objects.equals(manifestWindowSeconds(), other.manifestWindowSeconds())
                && Objects.equals(minBufferTimeSeconds(), other.minBufferTimeSeconds())
                && Objects.equals(minUpdatePeriodSeconds(), other.minUpdatePeriodSeconds())
                && Objects.equals(periodTriggersAsStrings(), other.periodTriggersAsStrings())
                && Objects.equals(profileAsString(), other.profileAsString())
                && Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds())
                && Objects.equals(segmentTemplateFormatAsString(), other.segmentTemplateFormatAsString())
                && Objects.equals(streamSelection(), other.streamSelection())
                && Objects.equals(suggestedPresentationDelaySeconds(), other.suggestedPresentationDelaySeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DashPackage").add("AdTriggers", adTriggersAsStrings())
                .add("AdsOnDeliveryRestrictions", adsOnDeliveryRestrictionsAsString()).add("Encryption", encryption())
                .add("ManifestLayout", manifestLayoutAsString()).add("ManifestWindowSeconds", manifestWindowSeconds())
                .add("MinBufferTimeSeconds", minBufferTimeSeconds()).add("MinUpdatePeriodSeconds", minUpdatePeriodSeconds())
                .add("PeriodTriggers", periodTriggersAsStrings()).add("Profile", profileAsString())
                .add("SegmentDurationSeconds", segmentDurationSeconds())
                .add("SegmentTemplateFormat", segmentTemplateFormatAsString()).add("StreamSelection", streamSelection())
                .add("SuggestedPresentationDelaySeconds", suggestedPresentationDelaySeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdTriggers":
            return Optional.ofNullable(clazz.cast(adTriggersAsStrings()));
        case "AdsOnDeliveryRestrictions":
            return Optional.ofNullable(clazz.cast(adsOnDeliveryRestrictionsAsString()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "ManifestLayout":
            return Optional.ofNullable(clazz.cast(manifestLayoutAsString()));
        case "ManifestWindowSeconds":
            return Optional.ofNullable(clazz.cast(manifestWindowSeconds()));
        case "MinBufferTimeSeconds":
            return Optional.ofNullable(clazz.cast(minBufferTimeSeconds()));
        case "MinUpdatePeriodSeconds":
            return Optional.ofNullable(clazz.cast(minUpdatePeriodSeconds()));
        case "PeriodTriggers":
            return Optional.ofNullable(clazz.cast(periodTriggersAsStrings()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profileAsString()));
        case "SegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(segmentDurationSeconds()));
        case "SegmentTemplateFormat":
            return Optional.ofNullable(clazz.cast(segmentTemplateFormatAsString()));
        case "StreamSelection":
            return Optional.ofNullable(clazz.cast(streamSelection()));
        case "SuggestedPresentationDelaySeconds":
            return Optional.ofNullable(clazz.cast(suggestedPresentationDelaySeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashPackage, T> g) {
        return obj -> g.apply((DashPackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashPackage> {
        /**
         * Sets the value of the AdTriggers property for this object.
         *
         * @param adTriggers
         *        The new value for the AdTriggers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adTriggersWithStrings(Collection<String> adTriggers);

        /**
         * Sets the value of the AdTriggers property for this object.
         *
         * @param adTriggers
         *        The new value for the AdTriggers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adTriggersWithStrings(String... adTriggers);

        /**
         * Sets the value of the AdTriggers property for this object.
         *
         * @param adTriggers
         *        The new value for the AdTriggers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adTriggers(Collection<AdTriggersElement> adTriggers);

        /**
         * Sets the value of the AdTriggers property for this object.
         *
         * @param adTriggers
         *        The new value for the AdTriggers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adTriggers(AdTriggersElement... adTriggers);

        /**
         * Sets the value of the AdsOnDeliveryRestrictions property for this object.
         *
         * @param adsOnDeliveryRestrictions
         *        The new value for the AdsOnDeliveryRestrictions property for this object.
         * @see AdsOnDeliveryRestrictions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdsOnDeliveryRestrictions
         */
        Builder adsOnDeliveryRestrictions(String adsOnDeliveryRestrictions);

        /**
         * Sets the value of the AdsOnDeliveryRestrictions property for this object.
         *
         * @param adsOnDeliveryRestrictions
         *        The new value for the AdsOnDeliveryRestrictions property for this object.
         * @see AdsOnDeliveryRestrictions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdsOnDeliveryRestrictions
         */
        Builder adsOnDeliveryRestrictions(AdsOnDeliveryRestrictions adsOnDeliveryRestrictions);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(DashEncryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience that creates an instance of the {@link DashEncryption.Builder} avoiding the need to
         * create one manually via {@link DashEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(DashEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link DashEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(DashEncryption)
         */
        default Builder encryption(Consumer<DashEncryption.Builder> encryption) {
            return encryption(DashEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements
         * like SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT,
         * duplicate elements are combined and presented at the AdaptationSet level.
         * 
         * @param manifestLayout
         *        Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL,
         *        elements like SegmentTemplate and ContentProtection are included in each Representation. When set to
         *        COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
         * @see ManifestLayout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestLayout
         */
        Builder manifestLayout(String manifestLayout);

        /**
         * Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements
         * like SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT,
         * duplicate elements are combined and presented at the AdaptationSet level.
         * 
         * @param manifestLayout
         *        Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL,
         *        elements like SegmentTemplate and ContentProtection are included in each Representation. When set to
         *        COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
         * @see ManifestLayout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestLayout
         */
        Builder manifestLayout(ManifestLayout manifestLayout);

        /**
         * Time window (in seconds) contained in each manifest.
         * 
         * @param manifestWindowSeconds
         *        Time window (in seconds) contained in each manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestWindowSeconds(Integer manifestWindowSeconds);

        /**
         * Minimum duration (in seconds) that a player will buffer media before starting the presentation.
         * 
         * @param minBufferTimeSeconds
         *        Minimum duration (in seconds) that a player will buffer media before starting the presentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minBufferTimeSeconds(Integer minBufferTimeSeconds);

        /**
         * Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH)
         * Media Presentation Description (MPD).
         * 
         * @param minUpdatePeriodSeconds
         *        Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP
         *        (DASH) Media Presentation Description (MPD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds);

        /**
         * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         * Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be
         * partitioned into more than one period. If the list contains "ADS", new periods will be created where the
         * Channel source contains SCTE-35 ad markers.
         *
         * @param periodTriggers
         *        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         *        Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will
         *        not be partitioned into more than one period. If the list contains "ADS", new periods will be created
         *        where the Channel source contains SCTE-35 ad markers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggersWithStrings(Collection<String> periodTriggers);

        /**
         * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         * Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be
         * partitioned into more than one period. If the list contains "ADS", new periods will be created where the
         * Channel source contains SCTE-35 ad markers.
         *
         * @param periodTriggers
         *        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         *        Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will
         *        not be partitioned into more than one period. If the list contains "ADS", new periods will be created
         *        where the Channel source contains SCTE-35 ad markers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggersWithStrings(String... periodTriggers);

        /**
         * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         * Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be
         * partitioned into more than one period. If the list contains "ADS", new periods will be created where the
         * Channel source contains SCTE-35 ad markers.
         *
         * @param periodTriggers
         *        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         *        Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will
         *        not be partitioned into more than one period. If the list contains "ADS", new periods will be created
         *        where the Channel source contains SCTE-35 ad markers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggers(Collection<PeriodTriggersElement> periodTriggers);

        /**
         * A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         * Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be
         * partitioned into more than one period. If the list contains "ADS", new periods will be created where the
         * Channel source contains SCTE-35 ad markers.
         *
         * @param periodTriggers
         *        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media
         *        Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will
         *        not be partitioned into more than one period. If the list contains "ADS", new periods will be created
         *        where the Channel source contains SCTE-35 ad markers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodTriggers(PeriodTriggersElement... periodTriggers);

        /**
         * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant
         * output is enabled.
         * 
         * @param profile
         *        The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
         *        compliant output is enabled.
         * @see Profile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Profile
         */
        Builder profile(String profile);

        /**
         * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant
         * output is enabled.
         * 
         * @param profile
         *        The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
         *        compliant output is enabled.
         * @see Profile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Profile
         */
        Builder profile(Profile profile);

        /**
         * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source
         * segment duration.
         *
         * @param segmentDurationSeconds
         *        Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the
         *        source segment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);

        /**
         * Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
         * NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When
         * set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When
         * set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
         * 
         * @param segmentTemplateFormat
         *        Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set
         *        to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media
         *        URLs. When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with
         *        $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each
         *        SegmentTemplate, with $Number$ media URLs.
         * @see SegmentTemplateFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentTemplateFormat
         */
        Builder segmentTemplateFormat(String segmentTemplateFormat);

        /**
         * Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to
         * NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When
         * set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When
         * set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
         * 
         * @param segmentTemplateFormat
         *        Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set
         *        to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media
         *        URLs. When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with
         *        $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each
         *        SegmentTemplate, with $Number$ media URLs.
         * @see SegmentTemplateFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentTemplateFormat
         */
        Builder segmentTemplateFormat(SegmentTemplateFormat segmentTemplateFormat);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * @param streamSelection
         *        The new value for the StreamSelection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSelection(StreamSelection streamSelection);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * This is a convenience that creates an instance of the {@link StreamSelection.Builder} avoiding the need to
         * create one manually via {@link StreamSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamSelection.Builder#build()} is called immediately and its
         * result is passed to {@link #streamSelection(StreamSelection)}.
         * 
         * @param streamSelection
         *        a consumer that will call methods on {@link StreamSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSelection(StreamSelection)
         */
        default Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return streamSelection(StreamSelection.builder().applyMutation(streamSelection).build());
        }

        /**
         * Duration (in seconds) to delay live content before presentation.
         * 
         * @param suggestedPresentationDelaySeconds
         *        Duration (in seconds) to delay live content before presentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> adTriggers = DefaultSdkAutoConstructList.getInstance();

        private String adsOnDeliveryRestrictions;

        private DashEncryption encryption;

        private String manifestLayout;

        private Integer manifestWindowSeconds;

        private Integer minBufferTimeSeconds;

        private Integer minUpdatePeriodSeconds;

        private List<String> periodTriggers = DefaultSdkAutoConstructList.getInstance();

        private String profile;

        private Integer segmentDurationSeconds;

        private String segmentTemplateFormat;

        private StreamSelection streamSelection;

        private Integer suggestedPresentationDelaySeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DashPackage model) {
            adTriggersWithStrings(model.adTriggers);
            adsOnDeliveryRestrictions(model.adsOnDeliveryRestrictions);
            encryption(model.encryption);
            manifestLayout(model.manifestLayout);
            manifestWindowSeconds(model.manifestWindowSeconds);
            minBufferTimeSeconds(model.minBufferTimeSeconds);
            minUpdatePeriodSeconds(model.minUpdatePeriodSeconds);
            periodTriggersWithStrings(model.periodTriggers);
            profile(model.profile);
            segmentDurationSeconds(model.segmentDurationSeconds);
            segmentTemplateFormat(model.segmentTemplateFormat);
            streamSelection(model.streamSelection);
            suggestedPresentationDelaySeconds(model.suggestedPresentationDelaySeconds);
        }

        public final Collection<String> getAdTriggersAsStrings() {
            return adTriggers;
        }

        @Override
        public final Builder adTriggersWithStrings(Collection<String> adTriggers) {
            this.adTriggers = AdTriggersCopier.copy(adTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adTriggersWithStrings(String... adTriggers) {
            adTriggersWithStrings(Arrays.asList(adTriggers));
            return this;
        }

        @Override
        public final Builder adTriggers(Collection<AdTriggersElement> adTriggers) {
            this.adTriggers = AdTriggersCopier.copyEnumToString(adTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adTriggers(AdTriggersElement... adTriggers) {
            adTriggers(Arrays.asList(adTriggers));
            return this;
        }

        public final void setAdTriggersWithStrings(Collection<String> adTriggers) {
            this.adTriggers = AdTriggersCopier.copy(adTriggers);
        }

        public final String getAdsOnDeliveryRestrictionsAsString() {
            return adsOnDeliveryRestrictions;
        }

        @Override
        public final Builder adsOnDeliveryRestrictions(String adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
            return this;
        }

        @Override
        public final Builder adsOnDeliveryRestrictions(AdsOnDeliveryRestrictions adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions(adsOnDeliveryRestrictions == null ? null : adsOnDeliveryRestrictions.toString());
            return this;
        }

        public final void setAdsOnDeliveryRestrictions(String adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
        }

        public final DashEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(DashEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(DashEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getManifestLayoutAsString() {
            return manifestLayout;
        }

        @Override
        public final Builder manifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
            return this;
        }

        @Override
        public final Builder manifestLayout(ManifestLayout manifestLayout) {
            this.manifestLayout(manifestLayout == null ? null : manifestLayout.toString());
            return this;
        }

        public final void setManifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
        }

        public final Integer getManifestWindowSeconds() {
            return manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        public final Integer getMinBufferTimeSeconds() {
            return minBufferTimeSeconds;
        }

        @Override
        public final Builder minBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
            return this;
        }

        public final void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
        }

        public final Integer getMinUpdatePeriodSeconds() {
            return minUpdatePeriodSeconds;
        }

        @Override
        public final Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
            return this;
        }

        public final void setMinUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
        }

        public final Collection<String> getPeriodTriggersAsStrings() {
            return periodTriggers;
        }

        @Override
        public final Builder periodTriggersWithStrings(Collection<String> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copy(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggersWithStrings(String... periodTriggers) {
            periodTriggersWithStrings(Arrays.asList(periodTriggers));
            return this;
        }

        @Override
        public final Builder periodTriggers(Collection<PeriodTriggersElement> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copyEnumToString(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggers(PeriodTriggersElement... periodTriggers) {
            periodTriggers(Arrays.asList(periodTriggers));
            return this;
        }

        public final void setPeriodTriggersWithStrings(Collection<String> periodTriggers) {
            this.periodTriggers = ___listOf__PeriodTriggersElementCopier.copy(periodTriggers);
        }

        public final String getProfileAsString() {
            return profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(Profile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final String getSegmentTemplateFormatAsString() {
            return segmentTemplateFormat;
        }

        @Override
        public final Builder segmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
            return this;
        }

        @Override
        public final Builder segmentTemplateFormat(SegmentTemplateFormat segmentTemplateFormat) {
            this.segmentTemplateFormat(segmentTemplateFormat == null ? null : segmentTemplateFormat.toString());
            return this;
        }

        public final void setSegmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return streamSelection != null ? streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public final Integer getSuggestedPresentationDelaySeconds() {
            return suggestedPresentationDelaySeconds;
        }

        @Override
        public final Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
            return this;
        }

        public final void setSuggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
        }

        @Override
        public DashPackage build() {
            return new DashPackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
