/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOriginEndpointsResponse extends MediaPackageResponse implements
        ToCopyableBuilder<ListOriginEndpointsResponse.Builder, ListOriginEndpointsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOriginEndpointsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<OriginEndpoint>> ORIGIN_ENDPOINTS_FIELD = SdkField
            .<List<OriginEndpoint>> builder(MarshallingType.LIST)
            .getter(getter(ListOriginEndpointsResponse::originEndpoints))
            .setter(setter(Builder::originEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OriginEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(OriginEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ORIGIN_ENDPOINTS_FIELD));

    private final String nextToken;

    private final List<OriginEndpoint> originEndpoints;

    private ListOriginEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.originEndpoints = builder.originEndpoints;
    }

    /**
     * A token that can be used to resume pagination from the end of the collection.
     * 
     * @return A token that can be used to resume pagination from the end of the collection.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the OriginEndpoints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasOriginEndpoints() {
        return originEndpoints != null && !(originEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * A list of OriginEndpoint records.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOriginEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of OriginEndpoint records.
     */
    public List<OriginEndpoint> originEndpoints() {
        return originEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOriginEndpointsResponse)) {
            return false;
        }
        ListOriginEndpointsResponse other = (ListOriginEndpointsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(originEndpoints(), other.originEndpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListOriginEndpointsResponse").add("NextToken", nextToken())
                .add("OriginEndpoints", originEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OriginEndpoints":
            return Optional.ofNullable(clazz.cast(originEndpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOriginEndpointsResponse, T> g) {
        return obj -> g.apply((ListOriginEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOriginEndpointsResponse> {
        /**
         * A token that can be used to resume pagination from the end of the collection.
         * 
         * @param nextToken
         *        A token that can be used to resume pagination from the end of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * A list of OriginEndpoint records.
         * 
         * @param originEndpoints
         *        A list of OriginEndpoint records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpoints(Collection<OriginEndpoint> originEndpoints);

        /**
         * A list of OriginEndpoint records.
         * 
         * @param originEndpoints
         *        A list of OriginEndpoint records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpoints(OriginEndpoint... originEndpoints);

        /**
         * A list of OriginEndpoint records. This is a convenience that creates an instance of the {@link List
         * <OriginEndpoint>.Builder} avoiding the need to create one manually via {@link List<OriginEndpoint>#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link List<OriginEndpoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #originEndpoints(List<OriginEndpoint>)}.
         * 
         * @param originEndpoints
         *        a consumer that will call methods on {@link List<OriginEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originEndpoints(List<OriginEndpoint>)
         */
        Builder originEndpoints(Consumer<OriginEndpoint.Builder>... originEndpoints);
    }

    static final class BuilderImpl extends MediaPackageResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<OriginEndpoint> originEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOriginEndpointsResponse model) {
            super(model);
            nextToken(model.nextToken);
            originEndpoints(model.originEndpoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<OriginEndpoint.Builder> getOriginEndpoints() {
            return originEndpoints != null ? originEndpoints.stream().map(OriginEndpoint::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder originEndpoints(Collection<OriginEndpoint> originEndpoints) {
            this.originEndpoints = ___listOfOriginEndpointCopier.copy(originEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originEndpoints(OriginEndpoint... originEndpoints) {
            originEndpoints(Arrays.asList(originEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originEndpoints(Consumer<OriginEndpoint.Builder>... originEndpoints) {
            originEndpoints(Stream.of(originEndpoints).map(c -> OriginEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOriginEndpoints(Collection<OriginEndpoint.BuilderImpl> originEndpoints) {
            this.originEndpoints = ___listOfOriginEndpointCopier.copyFromBuilder(originEndpoints);
        }

        @Override
        public ListOriginEndpointsResponse build() {
            return new ListOriginEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
