/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashEncryption implements SdkPojo, Serializable, ToCopyableBuilder<DashEncryption.Builder, DashEncryption> {
    private static final SdkField<Integer> KEY_ROTATION_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashEncryption::keyRotationIntervalSeconds))
            .setter(setter(Builder::keyRotationIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyRotationIntervalSeconds").build())
            .build();

    private static final SdkField<SpekeKeyProvider> SPEKE_KEY_PROVIDER_FIELD = SdkField
            .<SpekeKeyProvider> builder(MarshallingType.SDK_POJO).getter(getter(DashEncryption::spekeKeyProvider))
            .setter(setter(Builder::spekeKeyProvider)).constructor(SpekeKeyProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeKeyProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            KEY_ROTATION_INTERVAL_SECONDS_FIELD, SPEKE_KEY_PROVIDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer keyRotationIntervalSeconds;

    private final SpekeKeyProvider spekeKeyProvider;

    private DashEncryption(BuilderImpl builder) {
        this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
        this.spekeKeyProvider = builder.spekeKeyProvider;
    }

    /**
     * Time (in seconds) between each encryption key rotation.
     * 
     * @return Time (in seconds) between each encryption key rotation.
     */
    public Integer keyRotationIntervalSeconds() {
        return keyRotationIntervalSeconds;
    }

    /**
     * Returns the value of the SpekeKeyProvider property for this object.
     * 
     * @return The value of the SpekeKeyProvider property for this object.
     */
    public SpekeKeyProvider spekeKeyProvider() {
        return spekeKeyProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyRotationIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(spekeKeyProvider());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashEncryption)) {
            return false;
        }
        DashEncryption other = (DashEncryption) obj;
        return Objects.equals(keyRotationIntervalSeconds(), other.keyRotationIntervalSeconds())
                && Objects.equals(spekeKeyProvider(), other.spekeKeyProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DashEncryption").add("KeyRotationIntervalSeconds", keyRotationIntervalSeconds())
                .add("SpekeKeyProvider", spekeKeyProvider()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyRotationIntervalSeconds":
            return Optional.ofNullable(clazz.cast(keyRotationIntervalSeconds()));
        case "SpekeKeyProvider":
            return Optional.ofNullable(clazz.cast(spekeKeyProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashEncryption, T> g) {
        return obj -> g.apply((DashEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashEncryption> {
        /**
         * Time (in seconds) between each encryption key rotation.
         * 
         * @param keyRotationIntervalSeconds
         *        Time (in seconds) between each encryption key rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRotationIntervalSeconds(Integer keyRotationIntervalSeconds);

        /**
         * Sets the value of the SpekeKeyProvider property for this object.
         *
         * @param spekeKeyProvider
         *        The new value for the SpekeKeyProvider property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider);

        /**
         * Sets the value of the SpekeKeyProvider property for this object.
         *
         * This is a convenience that creates an instance of the {@link SpekeKeyProvider.Builder} avoiding the need to
         * create one manually via {@link SpekeKeyProvider#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpekeKeyProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #spekeKeyProvider(SpekeKeyProvider)}.
         * 
         * @param spekeKeyProvider
         *        a consumer that will call methods on {@link SpekeKeyProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spekeKeyProvider(SpekeKeyProvider)
         */
        default Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return spekeKeyProvider(SpekeKeyProvider.builder().applyMutation(spekeKeyProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer keyRotationIntervalSeconds;

        private SpekeKeyProvider spekeKeyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(DashEncryption model) {
            keyRotationIntervalSeconds(model.keyRotationIntervalSeconds);
            spekeKeyProvider(model.spekeKeyProvider);
        }

        public final Integer getKeyRotationIntervalSeconds() {
            return keyRotationIntervalSeconds;
        }

        @Override
        public final Builder keyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
            return this;
        }

        public final void setKeyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return spekeKeyProvider != null ? spekeKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        @Override
        public DashEncryption build() {
            return new DashEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
