/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackage.model.HarvestJob;
import software.amazon.awssdk.services.mediapackage.model.MediaPackageResponse;
import software.amazon.awssdk.services.mediapackage.model.___listOfHarvestJobCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHarvestJobsResponse
extends MediaPackageResponse
implements ToCopyableBuilder<Builder, ListHarvestJobsResponse> {
    private static final SdkField<List<HarvestJob>> HARVEST_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListHarvestJobsResponse.getter(ListHarvestJobsResponse::harvestJobs)).setter(ListHarvestJobsResponse.setter(Builder::harvestJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("harvestJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HarvestJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListHarvestJobsResponse.getter(ListHarvestJobsResponse::nextToken)).setter(ListHarvestJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HARVEST_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<HarvestJob> harvestJobs;
    private final String nextToken;

    private ListHarvestJobsResponse(BuilderImpl builder) {
        super(builder);
        this.harvestJobs = builder.harvestJobs;
        this.nextToken = builder.nextToken;
    }

    public boolean hasHarvestJobs() {
        return this.harvestJobs != null && !(this.harvestJobs instanceof SdkAutoConstructList);
    }

    public List<HarvestJob> harvestJobs() {
        return this.harvestJobs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.harvestJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHarvestJobsResponse)) {
            return false;
        }
        ListHarvestJobsResponse other = (ListHarvestJobsResponse)((Object)obj);
        return Objects.equals(this.harvestJobs(), other.harvestJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListHarvestJobsResponse").add("HarvestJobs", this.harvestJobs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HarvestJobs": {
                return Optional.ofNullable(clazz.cast(this.harvestJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHarvestJobsResponse, T> g) {
        return obj -> g.apply((ListHarvestJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageResponse.BuilderImpl
    implements Builder {
        private List<HarvestJob> harvestJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHarvestJobsResponse model) {
            super(model);
            this.harvestJobs(model.harvestJobs);
            this.nextToken(model.nextToken);
        }

        public final Collection<HarvestJob.Builder> getHarvestJobs() {
            return this.harvestJobs != null ? (Collection)this.harvestJobs.stream().map(HarvestJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder harvestJobs(Collection<HarvestJob> harvestJobs) {
            this.harvestJobs = ___listOfHarvestJobCopier.copy(harvestJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder harvestJobs(HarvestJob ... harvestJobs) {
            this.harvestJobs(Arrays.asList(harvestJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder harvestJobs(Consumer<HarvestJob.Builder> ... harvestJobs) {
            this.harvestJobs(Stream.of(harvestJobs).map(c -> (HarvestJob)((HarvestJob.Builder)HarvestJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHarvestJobs(Collection<HarvestJob.BuilderImpl> harvestJobs) {
            this.harvestJobs = ___listOfHarvestJobCopier.copyFromBuilder(harvestJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHarvestJobsResponse build() {
            return new ListHarvestJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHarvestJobsResponse> {
        public Builder harvestJobs(Collection<HarvestJob> var1);

        public Builder harvestJobs(HarvestJob ... var1);

        public Builder harvestJobs(Consumer<HarvestJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

