/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configuration parameters used to create a new HarvestJob.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHarvestJobRequest extends MediaPackageRequest implements
        ToCopyableBuilder<CreateHarvestJobRequest.Builder, CreateHarvestJobRequest> {
    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTime").getter(getter(CreateHarvestJobRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateHarvestJobRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginEndpointId").getter(getter(CreateHarvestJobRequest::originEndpointId))
            .setter(setter(Builder::originEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originEndpointId").build()).build();

    private static final SdkField<S3Destination> S3_DESTINATION_FIELD = SdkField
            .<S3Destination> builder(MarshallingType.SDK_POJO).memberName("S3Destination")
            .getter(getter(CreateHarvestJobRequest::s3Destination)).setter(setter(Builder::s3Destination))
            .constructor(S3Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(CreateHarvestJobRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, ID_FIELD,
            ORIGIN_ENDPOINT_ID_FIELD, S3_DESTINATION_FIELD, START_TIME_FIELD));

    private final String endTime;

    private final String id;

    private final String originEndpointId;

    private final S3Destination s3Destination;

    private final String startTime;

    private CreateHarvestJobRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.id = builder.id;
        this.originEndpointId = builder.originEndpointId;
        this.s3Destination = builder.s3Destination;
        this.startTime = builder.startTime;
    }

    /**
     * The end of the time-window which will be harvested
     *
     * @return The end of the time-window which will be harvested
     */
    public String endTime() {
        return endTime;
    }

    /**
     * The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the HarvestJob
     * is submitted
     *
     * @return The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the
     *         HarvestJob is submitted
     */
    public String id() {
        return id;
    }

    /**
     * The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the HarvestJob
     * is submitted.
     *
     * @return The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the
     *         HarvestJob is submitted.
     */
    public String originEndpointId() {
        return originEndpointId;
    }

    /**
     * Returns the value of the S3Destination property for this object.
     * 
     * @return The value of the S3Destination property for this object.
     */
    public S3Destination s3Destination() {
        return s3Destination;
    }

    /**
     * The start of the time-window which will be harvested
     *
     * @return The start of the time-window which will be harvested
     */
    public String startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHarvestJobRequest)) {
            return false;
        }
        CreateHarvestJobRequest other = (CreateHarvestJobRequest) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(id(), other.id())
                && Objects.equals(originEndpointId(), other.originEndpointId())
                && Objects.equals(s3Destination(), other.s3Destination()) && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateHarvestJobRequest").add("EndTime", endTime()).add("Id", id())
                .add("OriginEndpointId", originEndpointId()).add("S3Destination", s3Destination()).add("StartTime", startTime())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "OriginEndpointId":
            return Optional.ofNullable(clazz.cast(originEndpointId()));
        case "S3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHarvestJobRequest, T> g) {
        return obj -> g.apply((CreateHarvestJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateHarvestJobRequest> {
        /**
         * The end of the time-window which will be harvested
         *
         * @param endTime
         *        The end of the time-window which will be harvested
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the
         * HarvestJob is submitted
         *
         * @param id
         *        The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the
         *        HarvestJob is submitted
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the
         * HarvestJob is submitted.
         *
         * @param originEndpointId
         *        The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the
         *        HarvestJob is submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointId(String originEndpointId);

        /**
         * Sets the value of the S3Destination property for this object.
         *
         * @param s3Destination
         *        The new value for the S3Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(S3Destination s3Destination);

        /**
         * Sets the value of the S3Destination property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3Destination.Builder} avoiding the need to
         * create one manually via {@link S3Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Destination.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Destination(S3Destination)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link S3Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(S3Destination)
         */
        default Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return s3Destination(S3Destination.builder().applyMutation(s3Destination).build());
        }

        /**
         * The start of the time-window which will be harvested
         *
         * @param startTime
         *        The start of the time-window which will be harvested
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageRequest.BuilderImpl implements Builder {
        private String endTime;

        private String id;

        private String originEndpointId;

        private S3Destination s3Destination;

        private String startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHarvestJobRequest model) {
            super(model);
            endTime(model.endTime);
            id(model.id);
            originEndpointId(model.originEndpointId);
            s3Destination(model.s3Destination);
            startTime(model.startTime);
        }

        public final String getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getOriginEndpointId() {
            return originEndpointId;
        }

        @Override
        public final Builder originEndpointId(String originEndpointId) {
            this.originEndpointId = originEndpointId;
            return this;
        }

        public final void setOriginEndpointId(String originEndpointId) {
            this.originEndpointId = originEndpointId;
        }

        public final S3Destination.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        public final String getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHarvestJobRequest build() {
            return new CreateHarvestJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
