/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A StreamSelection configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamSelection implements SdkPojo, Serializable, ToCopyableBuilder<StreamSelection.Builder, StreamSelection> {
    private static final SdkField<Integer> MAX_VIDEO_BITS_PER_SECOND_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxVideoBitsPerSecond").getter(getter(StreamSelection::maxVideoBitsPerSecond))
            .setter(setter(Builder::maxVideoBitsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxVideoBitsPerSecond").build())
            .build();

    private static final SdkField<Integer> MIN_VIDEO_BITS_PER_SECOND_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinVideoBitsPerSecond").getter(getter(StreamSelection::minVideoBitsPerSecond))
            .setter(setter(Builder::minVideoBitsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minVideoBitsPerSecond").build())
            .build();

    private static final SdkField<String> STREAM_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamOrder").getter(getter(StreamSelection::streamOrderAsString)).setter(setter(Builder::streamOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_VIDEO_BITS_PER_SECOND_FIELD, MIN_VIDEO_BITS_PER_SECOND_FIELD, STREAM_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxVideoBitsPerSecond;

    private final Integer minVideoBitsPerSecond;

    private final String streamOrder;

    private StreamSelection(BuilderImpl builder) {
        this.maxVideoBitsPerSecond = builder.maxVideoBitsPerSecond;
        this.minVideoBitsPerSecond = builder.minVideoBitsPerSecond;
        this.streamOrder = builder.streamOrder;
    }

    /**
     * The maximum video bitrate (bps) to include in output.
     * 
     * @return The maximum video bitrate (bps) to include in output.
     */
    public Integer maxVideoBitsPerSecond() {
        return maxVideoBitsPerSecond;
    }

    /**
     * The minimum video bitrate (bps) to include in output.
     * 
     * @return The minimum video bitrate (bps) to include in output.
     */
    public Integer minVideoBitsPerSecond() {
        return minVideoBitsPerSecond;
    }

    /**
     * A directive that determines the order of streams in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamOrder} will
     * return {@link StreamOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamOrderAsString}.
     * </p>
     * 
     * @return A directive that determines the order of streams in the output.
     * @see StreamOrder
     */
    public StreamOrder streamOrder() {
        return StreamOrder.fromValue(streamOrder);
    }

    /**
     * A directive that determines the order of streams in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamOrder} will
     * return {@link StreamOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamOrderAsString}.
     * </p>
     * 
     * @return A directive that determines the order of streams in the output.
     * @see StreamOrder
     */
    public String streamOrderAsString() {
        return streamOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxVideoBitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(minVideoBitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(streamOrderAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSelection)) {
            return false;
        }
        StreamSelection other = (StreamSelection) obj;
        return Objects.equals(maxVideoBitsPerSecond(), other.maxVideoBitsPerSecond())
                && Objects.equals(minVideoBitsPerSecond(), other.minVideoBitsPerSecond())
                && Objects.equals(streamOrderAsString(), other.streamOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StreamSelection").add("MaxVideoBitsPerSecond", maxVideoBitsPerSecond())
                .add("MinVideoBitsPerSecond", minVideoBitsPerSecond()).add("StreamOrder", streamOrderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxVideoBitsPerSecond":
            return Optional.ofNullable(clazz.cast(maxVideoBitsPerSecond()));
        case "MinVideoBitsPerSecond":
            return Optional.ofNullable(clazz.cast(minVideoBitsPerSecond()));
        case "StreamOrder":
            return Optional.ofNullable(clazz.cast(streamOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamSelection, T> g) {
        return obj -> g.apply((StreamSelection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamSelection> {
        /**
         * The maximum video bitrate (bps) to include in output.
         * 
         * @param maxVideoBitsPerSecond
         *        The maximum video bitrate (bps) to include in output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxVideoBitsPerSecond(Integer maxVideoBitsPerSecond);

        /**
         * The minimum video bitrate (bps) to include in output.
         * 
         * @param minVideoBitsPerSecond
         *        The minimum video bitrate (bps) to include in output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minVideoBitsPerSecond(Integer minVideoBitsPerSecond);

        /**
         * A directive that determines the order of streams in the output.
         * 
         * @param streamOrder
         *        A directive that determines the order of streams in the output.
         * @see StreamOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamOrder
         */
        Builder streamOrder(String streamOrder);

        /**
         * A directive that determines the order of streams in the output.
         * 
         * @param streamOrder
         *        A directive that determines the order of streams in the output.
         * @see StreamOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamOrder
         */
        Builder streamOrder(StreamOrder streamOrder);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxVideoBitsPerSecond;

        private Integer minVideoBitsPerSecond;

        private String streamOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSelection model) {
            maxVideoBitsPerSecond(model.maxVideoBitsPerSecond);
            minVideoBitsPerSecond(model.minVideoBitsPerSecond);
            streamOrder(model.streamOrder);
        }

        public final Integer getMaxVideoBitsPerSecond() {
            return maxVideoBitsPerSecond;
        }

        @Override
        public final Builder maxVideoBitsPerSecond(Integer maxVideoBitsPerSecond) {
            this.maxVideoBitsPerSecond = maxVideoBitsPerSecond;
            return this;
        }

        public final void setMaxVideoBitsPerSecond(Integer maxVideoBitsPerSecond) {
            this.maxVideoBitsPerSecond = maxVideoBitsPerSecond;
        }

        public final Integer getMinVideoBitsPerSecond() {
            return minVideoBitsPerSecond;
        }

        @Override
        public final Builder minVideoBitsPerSecond(Integer minVideoBitsPerSecond) {
            this.minVideoBitsPerSecond = minVideoBitsPerSecond;
            return this;
        }

        public final void setMinVideoBitsPerSecond(Integer minVideoBitsPerSecond) {
            this.minVideoBitsPerSecond = minVideoBitsPerSecond;
        }

        public final String getStreamOrder() {
            return streamOrder;
        }

        @Override
        public final Builder streamOrder(String streamOrder) {
            this.streamOrder = streamOrder;
            return this;
        }

        @Override
        public final Builder streamOrder(StreamOrder streamOrder) {
            this.streamOrder(streamOrder == null ? null : streamOrder.toString());
            return this;
        }

        public final void setStreamOrder(String streamOrder) {
            this.streamOrder = streamOrder;
        }

        @Override
        public StreamSelection build() {
            return new StreamSelection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
