/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackage.model.AdMarkers;
import software.amazon.awssdk.services.mediapackage.model.AdTriggersCopier;
import software.amazon.awssdk.services.mediapackage.model.AdTriggersElement;
import software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions;
import software.amazon.awssdk.services.mediapackage.model.HlsEncryption;
import software.amazon.awssdk.services.mediapackage.model.PlaylistType;
import software.amazon.awssdk.services.mediapackage.model.StreamSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsPackage> {
    private static final SdkField<String> AD_MARKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdMarkers").getter(HlsPackage.getter(HlsPackage::adMarkersAsString)).setter(HlsPackage.setter(Builder::adMarkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build()}).build();
    private static final SdkField<List<String>> AD_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdTriggers").getter(HlsPackage.getter(HlsPackage::adTriggersAsStrings)).setter(HlsPackage.setter(Builder::adTriggersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ADS_ON_DELIVERY_RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdsOnDeliveryRestrictions").getter(HlsPackage.getter(HlsPackage::adsOnDeliveryRestrictionsAsString)).setter(HlsPackage.setter(Builder::adsOnDeliveryRestrictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsOnDeliveryRestrictions").build()}).build();
    private static final SdkField<HlsEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(HlsPackage.getter(HlsPackage::encryption)).setter(HlsPackage.setter(Builder::encryption)).constructor(HlsEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Boolean> INCLUDE_IFRAME_ONLY_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeIframeOnlyStream").getter(HlsPackage.getter(HlsPackage::includeIframeOnlyStream)).setter(HlsPackage.setter(Builder::includeIframeOnlyStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeIframeOnlyStream").build()}).build();
    private static final SdkField<String> PLAYLIST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaylistType").getter(HlsPackage.getter(HlsPackage::playlistTypeAsString)).setter(HlsPackage.setter(Builder::playlistType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistType").build()}).build();
    private static final SdkField<Integer> PLAYLIST_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PlaylistWindowSeconds").getter(HlsPackage.getter(HlsPackage::playlistWindowSeconds)).setter(HlsPackage.setter(Builder::playlistWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistWindowSeconds").build()}).build();
    private static final SdkField<Integer> PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramDateTimeIntervalSeconds").getter(HlsPackage.getter(HlsPackage::programDateTimeIntervalSeconds)).setter(HlsPackage.setter(Builder::programDateTimeIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimeIntervalSeconds").build()}).build();
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentDurationSeconds").getter(HlsPackage.getter(HlsPackage::segmentDurationSeconds)).setter(HlsPackage.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build()}).build();
    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamSelection").getter(HlsPackage.getter(HlsPackage::streamSelection)).setter(HlsPackage.setter(Builder::streamSelection)).constructor(StreamSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()}).build();
    private static final SdkField<Boolean> USE_AUDIO_RENDITION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseAudioRenditionGroup").getter(HlsPackage.getter(HlsPackage::useAudioRenditionGroup)).setter(HlsPackage.setter(Builder::useAudioRenditionGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useAudioRenditionGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD, AD_TRIGGERS_FIELD, ADS_ON_DELIVERY_RESTRICTIONS_FIELD, ENCRYPTION_FIELD, INCLUDE_IFRAME_ONLY_STREAM_FIELD, PLAYLIST_TYPE_FIELD, PLAYLIST_WINDOW_SECONDS_FIELD, PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD, SEGMENT_DURATION_SECONDS_FIELD, STREAM_SELECTION_FIELD, USE_AUDIO_RENDITION_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adMarkers;
    private final List<String> adTriggers;
    private final String adsOnDeliveryRestrictions;
    private final HlsEncryption encryption;
    private final Boolean includeIframeOnlyStream;
    private final String playlistType;
    private final Integer playlistWindowSeconds;
    private final Integer programDateTimeIntervalSeconds;
    private final Integer segmentDurationSeconds;
    private final StreamSelection streamSelection;
    private final Boolean useAudioRenditionGroup;

    private HlsPackage(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.adTriggers = builder.adTriggers;
        this.adsOnDeliveryRestrictions = builder.adsOnDeliveryRestrictions;
        this.encryption = builder.encryption;
        this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
        this.playlistType = builder.playlistType;
        this.playlistWindowSeconds = builder.playlistWindowSeconds;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.streamSelection = builder.streamSelection;
        this.useAudioRenditionGroup = builder.useAudioRenditionGroup;
    }

    public AdMarkers adMarkers() {
        return AdMarkers.fromValue(this.adMarkers);
    }

    public String adMarkersAsString() {
        return this.adMarkers;
    }

    public List<AdTriggersElement> adTriggers() {
        return AdTriggersCopier.copyStringToEnum(this.adTriggers);
    }

    public boolean hasAdTriggers() {
        return this.adTriggers != null && !(this.adTriggers instanceof SdkAutoConstructList);
    }

    public List<String> adTriggersAsStrings() {
        return this.adTriggers;
    }

    public AdsOnDeliveryRestrictions adsOnDeliveryRestrictions() {
        return AdsOnDeliveryRestrictions.fromValue(this.adsOnDeliveryRestrictions);
    }

    public String adsOnDeliveryRestrictionsAsString() {
        return this.adsOnDeliveryRestrictions;
    }

    public HlsEncryption encryption() {
        return this.encryption;
    }

    public Boolean includeIframeOnlyStream() {
        return this.includeIframeOnlyStream;
    }

    public PlaylistType playlistType() {
        return PlaylistType.fromValue(this.playlistType);
    }

    public String playlistTypeAsString() {
        return this.playlistType;
    }

    public Integer playlistWindowSeconds() {
        return this.playlistWindowSeconds;
    }

    public Integer programDateTimeIntervalSeconds() {
        return this.programDateTimeIntervalSeconds;
    }

    public Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public StreamSelection streamSelection() {
        return this.streamSelection;
    }

    public Boolean useAudioRenditionGroup() {
        return this.useAudioRenditionGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.adTriggersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.adsOnDeliveryRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeIframeOnlyStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.playlistTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.playlistWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimeIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.useAudioRenditionGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsPackage)) {
            return false;
        }
        HlsPackage other = (HlsPackage)obj;
        return Objects.equals(this.adMarkersAsString(), other.adMarkersAsString()) && Objects.equals(this.adTriggersAsStrings(), other.adTriggersAsStrings()) && Objects.equals(this.adsOnDeliveryRestrictionsAsString(), other.adsOnDeliveryRestrictionsAsString()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.includeIframeOnlyStream(), other.includeIframeOnlyStream()) && Objects.equals(this.playlistTypeAsString(), other.playlistTypeAsString()) && Objects.equals(this.playlistWindowSeconds(), other.playlistWindowSeconds()) && Objects.equals(this.programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.streamSelection(), other.streamSelection()) && Objects.equals(this.useAudioRenditionGroup(), other.useAudioRenditionGroup());
    }

    public String toString() {
        return ToString.builder((String)"HlsPackage").add("AdMarkers", (Object)this.adMarkersAsString()).add("AdTriggers", this.adTriggersAsStrings()).add("AdsOnDeliveryRestrictions", (Object)this.adsOnDeliveryRestrictionsAsString()).add("Encryption", (Object)this.encryption()).add("IncludeIframeOnlyStream", (Object)this.includeIframeOnlyStream()).add("PlaylistType", (Object)this.playlistTypeAsString()).add("PlaylistWindowSeconds", (Object)this.playlistWindowSeconds()).add("ProgramDateTimeIntervalSeconds", (Object)this.programDateTimeIntervalSeconds()).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("StreamSelection", (Object)this.streamSelection()).add("UseAudioRenditionGroup", (Object)this.useAudioRenditionGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.ofNullable(clazz.cast(this.adMarkersAsString()));
            }
            case "AdTriggers": {
                return Optional.ofNullable(clazz.cast(this.adTriggersAsStrings()));
            }
            case "AdsOnDeliveryRestrictions": {
                return Optional.ofNullable(clazz.cast(this.adsOnDeliveryRestrictionsAsString()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "IncludeIframeOnlyStream": {
                return Optional.ofNullable(clazz.cast(this.includeIframeOnlyStream()));
            }
            case "PlaylistType": {
                return Optional.ofNullable(clazz.cast(this.playlistTypeAsString()));
            }
            case "PlaylistWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.playlistWindowSeconds()));
            }
            case "ProgramDateTimeIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.programDateTimeIntervalSeconds()));
            }
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
            case "StreamSelection": {
                return Optional.ofNullable(clazz.cast(this.streamSelection()));
            }
            case "UseAudioRenditionGroup": {
                return Optional.ofNullable(clazz.cast(this.useAudioRenditionGroup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsPackage, T> g) {
        return obj -> g.apply((HlsPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adMarkers;
        private List<String> adTriggers = DefaultSdkAutoConstructList.getInstance();
        private String adsOnDeliveryRestrictions;
        private HlsEncryption encryption;
        private Boolean includeIframeOnlyStream;
        private String playlistType;
        private Integer playlistWindowSeconds;
        private Integer programDateTimeIntervalSeconds;
        private Integer segmentDurationSeconds;
        private StreamSelection streamSelection;
        private Boolean useAudioRenditionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsPackage model) {
            this.adMarkers(model.adMarkers);
            this.adTriggersWithStrings(model.adTriggers);
            this.adsOnDeliveryRestrictions(model.adsOnDeliveryRestrictions);
            this.encryption(model.encryption);
            this.includeIframeOnlyStream(model.includeIframeOnlyStream);
            this.playlistType(model.playlistType);
            this.playlistWindowSeconds(model.playlistWindowSeconds);
            this.programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.streamSelection(model.streamSelection);
            this.useAudioRenditionGroup(model.useAudioRenditionGroup);
        }

        public final String getAdMarkers() {
            return this.adMarkers;
        }

        @Override
        public final Builder adMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
            return this;
        }

        @Override
        public final Builder adMarkers(AdMarkers adMarkers) {
            this.adMarkers(adMarkers == null ? null : adMarkers.toString());
            return this;
        }

        public final void setAdMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
        }

        public final Collection<String> getAdTriggers() {
            return this.adTriggers;
        }

        @Override
        public final Builder adTriggersWithStrings(Collection<String> adTriggers) {
            this.adTriggers = AdTriggersCopier.copy(adTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adTriggersWithStrings(String ... adTriggers) {
            this.adTriggersWithStrings(Arrays.asList(adTriggers));
            return this;
        }

        @Override
        public final Builder adTriggers(Collection<AdTriggersElement> adTriggers) {
            this.adTriggers = AdTriggersCopier.copyEnumToString(adTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adTriggers(AdTriggersElement ... adTriggers) {
            this.adTriggers(Arrays.asList(adTriggers));
            return this;
        }

        public final void setAdTriggers(Collection<String> adTriggers) {
            this.adTriggers = AdTriggersCopier.copy(adTriggers);
        }

        public final String getAdsOnDeliveryRestrictions() {
            return this.adsOnDeliveryRestrictions;
        }

        @Override
        public final Builder adsOnDeliveryRestrictions(String adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
            return this;
        }

        @Override
        public final Builder adsOnDeliveryRestrictions(AdsOnDeliveryRestrictions adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions(adsOnDeliveryRestrictions == null ? null : adsOnDeliveryRestrictions.toString());
            return this;
        }

        public final void setAdsOnDeliveryRestrictions(String adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
        }

        public final HlsEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(HlsEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(HlsEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Boolean getIncludeIframeOnlyStream() {
            return this.includeIframeOnlyStream;
        }

        @Override
        public final Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
            return this;
        }

        public final void setIncludeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
        }

        public final String getPlaylistType() {
            return this.playlistType;
        }

        @Override
        public final Builder playlistType(String playlistType) {
            this.playlistType = playlistType;
            return this;
        }

        @Override
        public final Builder playlistType(PlaylistType playlistType) {
            this.playlistType(playlistType == null ? null : playlistType.toString());
            return this;
        }

        public final void setPlaylistType(String playlistType) {
            this.playlistType = playlistType;
        }

        public final Integer getPlaylistWindowSeconds() {
            return this.playlistWindowSeconds;
        }

        @Override
        public final Builder playlistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
            return this;
        }

        public final void setPlaylistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return this.programDateTimeIntervalSeconds;
        }

        @Override
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return this.streamSelection != null ? this.streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public final Boolean getUseAudioRenditionGroup() {
            return this.useAudioRenditionGroup;
        }

        @Override
        public final Builder useAudioRenditionGroup(Boolean useAudioRenditionGroup) {
            this.useAudioRenditionGroup = useAudioRenditionGroup;
            return this;
        }

        public final void setUseAudioRenditionGroup(Boolean useAudioRenditionGroup) {
            this.useAudioRenditionGroup = useAudioRenditionGroup;
        }

        public HlsPackage build() {
            return new HlsPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsPackage> {
        public Builder adMarkers(String var1);

        public Builder adMarkers(AdMarkers var1);

        public Builder adTriggersWithStrings(Collection<String> var1);

        public Builder adTriggersWithStrings(String ... var1);

        public Builder adTriggers(Collection<AdTriggersElement> var1);

        public Builder adTriggers(AdTriggersElement ... var1);

        public Builder adsOnDeliveryRestrictions(String var1);

        public Builder adsOnDeliveryRestrictions(AdsOnDeliveryRestrictions var1);

        public Builder encryption(HlsEncryption var1);

        default public Builder encryption(Consumer<HlsEncryption.Builder> encryption) {
            return this.encryption((HlsEncryption)((HlsEncryption.Builder)HlsEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder includeIframeOnlyStream(Boolean var1);

        public Builder playlistType(String var1);

        public Builder playlistType(PlaylistType var1);

        public Builder playlistWindowSeconds(Integer var1);

        public Builder programDateTimeIntervalSeconds(Integer var1);

        public Builder segmentDurationSeconds(Integer var1);

        public Builder streamSelection(StreamSelection var1);

        default public Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return this.streamSelection((StreamSelection)((StreamSelection.Builder)StreamSelection.builder().applyMutation(streamSelection)).build());
        }

        public Builder useAudioRenditionGroup(Boolean var1);
    }
}

