/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EncryptionMethod {
    AES_128("AES_128"),
    SAMPLE_AES("SAMPLE_AES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EncryptionMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EncryptionMethod.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionMethod> knownValues() {
        return Stream.of(EncryptionMethod.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

