/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Common Media Application Format (CMAF) packaging configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CmafPackageCreateOrUpdateParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<CmafPackageCreateOrUpdateParameters.Builder, CmafPackageCreateOrUpdateParameters> {
    private static final SdkField<CmafEncryption> ENCRYPTION_FIELD = SdkField.<CmafEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(CmafPackageCreateOrUpdateParameters::encryption))
            .setter(setter(Builder::encryption)).constructor(CmafEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<List<HlsManifestCreateOrUpdateParameters>> HLS_MANIFESTS_FIELD = SdkField
            .<List<HlsManifestCreateOrUpdateParameters>> builder(MarshallingType.LIST)
            .memberName("HlsManifests")
            .getter(getter(CmafPackageCreateOrUpdateParameters::hlsManifests))
            .setter(setter(Builder::hlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HlsManifestCreateOrUpdateParameters> builder(MarshallingType.SDK_POJO)
                                            .constructor(HlsManifestCreateOrUpdateParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentDurationSeconds").getter(getter(CmafPackageCreateOrUpdateParameters::segmentDurationSeconds))
            .setter(setter(Builder::segmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build())
            .build();

    private static final SdkField<String> SEGMENT_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentPrefix").getter(getter(CmafPackageCreateOrUpdateParameters::segmentPrefix))
            .setter(setter(Builder::segmentPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentPrefix").build()).build();

    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField
            .<StreamSelection> builder(MarshallingType.SDK_POJO).memberName("StreamSelection")
            .getter(getter(CmafPackageCreateOrUpdateParameters::streamSelection)).setter(setter(Builder::streamSelection))
            .constructor(StreamSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD,
            HLS_MANIFESTS_FIELD, SEGMENT_DURATION_SECONDS_FIELD, SEGMENT_PREFIX_FIELD, STREAM_SELECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CmafEncryption encryption;

    private final List<HlsManifestCreateOrUpdateParameters> hlsManifests;

    private final Integer segmentDurationSeconds;

    private final String segmentPrefix;

    private final StreamSelection streamSelection;

    private CmafPackageCreateOrUpdateParameters(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.hlsManifests = builder.hlsManifests;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.segmentPrefix = builder.segmentPrefix;
        this.streamSelection = builder.streamSelection;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public final CmafEncryption encryption() {
        return encryption;
    }

    /**
     * Returns true if the HlsManifests property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasHlsManifests() {
        return hlsManifests != null && !(hlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * A list of HLS manifest configurations
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHlsManifests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of HLS manifest configurations
     */
    public final List<HlsManifestCreateOrUpdateParameters> hlsManifests() {
        return hlsManifests;
    }

    /**
     * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source
     * segment duration.
     *
     * @return Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the
     *         source segment duration.
     */
    public final Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    /**
     * An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the
     * ChannelId.
     * 
     * @return An optional custom string that is prepended to the name of each segment. If not specified, it defaults to
     *         the ChannelId.
     */
    public final String segmentPrefix() {
        return segmentPrefix;
    }

    /**
     * Returns the value of the StreamSelection property for this object.
     * 
     * @return The value of the StreamSelection property for this object.
     */
    public final StreamSelection streamSelection() {
        return streamSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(hasHlsManifests() ? hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(segmentPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(streamSelection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafPackageCreateOrUpdateParameters)) {
            return false;
        }
        CmafPackageCreateOrUpdateParameters other = (CmafPackageCreateOrUpdateParameters) obj;
        return Objects.equals(encryption(), other.encryption()) && hasHlsManifests() == other.hasHlsManifests()
                && Objects.equals(hlsManifests(), other.hlsManifests())
                && Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds())
                && Objects.equals(segmentPrefix(), other.segmentPrefix())
                && Objects.equals(streamSelection(), other.streamSelection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CmafPackageCreateOrUpdateParameters").add("Encryption", encryption())
                .add("HlsManifests", hasHlsManifests() ? hlsManifests() : null)
                .add("SegmentDurationSeconds", segmentDurationSeconds()).add("SegmentPrefix", segmentPrefix())
                .add("StreamSelection", streamSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "HlsManifests":
            return Optional.ofNullable(clazz.cast(hlsManifests()));
        case "SegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(segmentDurationSeconds()));
        case "SegmentPrefix":
            return Optional.ofNullable(clazz.cast(segmentPrefix()));
        case "StreamSelection":
            return Optional.ofNullable(clazz.cast(streamSelection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafPackageCreateOrUpdateParameters, T> g) {
        return obj -> g.apply((CmafPackageCreateOrUpdateParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CmafPackageCreateOrUpdateParameters> {
        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(CmafEncryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience that creates an instance of the {@link CmafEncryption.Builder} avoiding the need to
         * create one manually via {@link CmafEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link CmafEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(CmafEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link CmafEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(CmafEncryption)
         */
        default Builder encryption(Consumer<CmafEncryption.Builder> encryption) {
            return encryption(CmafEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * A list of HLS manifest configurations
         * 
         * @param hlsManifests
         *        A list of HLS manifest configurations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(Collection<HlsManifestCreateOrUpdateParameters> hlsManifests);

        /**
         * A list of HLS manifest configurations
         * 
         * @param hlsManifests
         *        A list of HLS manifest configurations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(HlsManifestCreateOrUpdateParameters... hlsManifests);

        /**
         * A list of HLS manifest configurations This is a convenience that creates an instance of the {@link List
         * <HlsManifestCreateOrUpdateParameters>.Builder} avoiding the need to create one manually via {@link List
         * <HlsManifestCreateOrUpdateParameters>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HlsManifestCreateOrUpdateParameters>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #hlsManifests(List<HlsManifestCreateOrUpdateParameters>)}.
         * 
         * @param hlsManifests
         *        a consumer that will call methods on {@link List<HlsManifestCreateOrUpdateParameters>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsManifests(List<HlsManifestCreateOrUpdateParameters>)
         */
        Builder hlsManifests(Consumer<HlsManifestCreateOrUpdateParameters.Builder>... hlsManifests);

        /**
         * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source
         * segment duration.
         *
         * @param segmentDurationSeconds
         *        Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the
         *        source segment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);

        /**
         * An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the
         * ChannelId.
         * 
         * @param segmentPrefix
         *        An optional custom string that is prepended to the name of each segment. If not specified, it defaults
         *        to the ChannelId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentPrefix(String segmentPrefix);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * @param streamSelection
         *        The new value for the StreamSelection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSelection(StreamSelection streamSelection);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * This is a convenience that creates an instance of the {@link StreamSelection.Builder} avoiding the need to
         * create one manually via {@link StreamSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamSelection.Builder#build()} is called immediately and its
         * result is passed to {@link #streamSelection(StreamSelection)}.
         * 
         * @param streamSelection
         *        a consumer that will call methods on {@link StreamSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSelection(StreamSelection)
         */
        default Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return streamSelection(StreamSelection.builder().applyMutation(streamSelection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CmafEncryption encryption;

        private List<HlsManifestCreateOrUpdateParameters> hlsManifests = DefaultSdkAutoConstructList.getInstance();

        private Integer segmentDurationSeconds;

        private String segmentPrefix;

        private StreamSelection streamSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafPackageCreateOrUpdateParameters model) {
            encryption(model.encryption);
            hlsManifests(model.hlsManifests);
            segmentDurationSeconds(model.segmentDurationSeconds);
            segmentPrefix(model.segmentPrefix);
            streamSelection(model.streamSelection);
        }

        public final CmafEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(CmafEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(CmafEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final List<HlsManifestCreateOrUpdateParameters.Builder> getHlsManifests() {
            List<HlsManifestCreateOrUpdateParameters.Builder> result = ___listOfHlsManifestCreateOrUpdateParametersCopier
                    .copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder hlsManifests(Collection<HlsManifestCreateOrUpdateParameters> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCreateOrUpdateParametersCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(HlsManifestCreateOrUpdateParameters... hlsManifests) {
            hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<HlsManifestCreateOrUpdateParameters.Builder>... hlsManifests) {
            hlsManifests(Stream.of(hlsManifests).map(c -> HlsManifestCreateOrUpdateParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHlsManifests(Collection<HlsManifestCreateOrUpdateParameters.BuilderImpl> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCreateOrUpdateParametersCopier.copyFromBuilder(hlsManifests);
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final String getSegmentPrefix() {
            return segmentPrefix;
        }

        @Override
        public final Builder segmentPrefix(String segmentPrefix) {
            this.segmentPrefix = segmentPrefix;
            return this;
        }

        public final void setSegmentPrefix(String segmentPrefix) {
            this.segmentPrefix = segmentPrefix;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return streamSelection != null ? streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        @Override
        public CmafPackageCreateOrUpdateParameters build() {
            return new CmafPackageCreateOrUpdateParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
