/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHarvestJobsResponse extends MediaPackageResponse implements
        ToCopyableBuilder<ListHarvestJobsResponse.Builder, ListHarvestJobsResponse> {
    private static final SdkField<List<HarvestJob>> HARVEST_JOBS_FIELD = SdkField
            .<List<HarvestJob>> builder(MarshallingType.LIST)
            .memberName("HarvestJobs")
            .getter(getter(ListHarvestJobsResponse::harvestJobs))
            .setter(setter(Builder::harvestJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("harvestJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HarvestJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(HarvestJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHarvestJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HARVEST_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<HarvestJob> harvestJobs;

    private final String nextToken;

    private ListHarvestJobsResponse(BuilderImpl builder) {
        super(builder);
        this.harvestJobs = builder.harvestJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the HarvestJobs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHarvestJobs() {
        return harvestJobs != null && !(harvestJobs instanceof SdkAutoConstructList);
    }

    /**
     * A list of HarvestJob records.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHarvestJobs} method.
     * </p>
     * 
     * @return A list of HarvestJob records.
     */
    public final List<HarvestJob> harvestJobs() {
        return harvestJobs;
    }

    /**
     * A token that can be used to resume pagination from the end of the collection.
     * 
     * @return A token that can be used to resume pagination from the end of the collection.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHarvestJobs() ? harvestJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHarvestJobsResponse)) {
            return false;
        }
        ListHarvestJobsResponse other = (ListHarvestJobsResponse) obj;
        return hasHarvestJobs() == other.hasHarvestJobs() && Objects.equals(harvestJobs(), other.harvestJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHarvestJobsResponse").add("HarvestJobs", hasHarvestJobs() ? harvestJobs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HarvestJobs":
            return Optional.ofNullable(clazz.cast(harvestJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHarvestJobsResponse, T> g) {
        return obj -> g.apply((ListHarvestJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListHarvestJobsResponse> {
        /**
         * A list of HarvestJob records.
         * 
         * @param harvestJobs
         *        A list of HarvestJob records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder harvestJobs(Collection<HarvestJob> harvestJobs);

        /**
         * A list of HarvestJob records.
         * 
         * @param harvestJobs
         *        A list of HarvestJob records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder harvestJobs(HarvestJob... harvestJobs);

        /**
         * A list of HarvestJob records. This is a convenience that creates an instance of the {@link List
         * <HarvestJob>.Builder} avoiding the need to create one manually via {@link List<HarvestJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HarvestJob>.Builder#build()} is called immediately and its
         * result is passed to {@link #harvestJobs(List<HarvestJob>)}.
         * 
         * @param harvestJobs
         *        a consumer that will call methods on {@link List<HarvestJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #harvestJobs(List<HarvestJob>)
         */
        Builder harvestJobs(Consumer<HarvestJob.Builder>... harvestJobs);

        /**
         * A token that can be used to resume pagination from the end of the collection.
         * 
         * @param nextToken
         *        A token that can be used to resume pagination from the end of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaPackageResponse.BuilderImpl implements Builder {
        private List<HarvestJob> harvestJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHarvestJobsResponse model) {
            super(model);
            harvestJobs(model.harvestJobs);
            nextToken(model.nextToken);
        }

        public final List<HarvestJob.Builder> getHarvestJobs() {
            List<HarvestJob.Builder> result = ___listOfHarvestJobCopier.copyToBuilder(this.harvestJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHarvestJobs(Collection<HarvestJob.BuilderImpl> harvestJobs) {
            this.harvestJobs = ___listOfHarvestJobCopier.copyFromBuilder(harvestJobs);
        }

        @Override
        @Transient
        public final Builder harvestJobs(Collection<HarvestJob> harvestJobs) {
            this.harvestJobs = ___listOfHarvestJobCopier.copy(harvestJobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder harvestJobs(HarvestJob... harvestJobs) {
            harvestJobs(Arrays.asList(harvestJobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder harvestJobs(Consumer<HarvestJob.Builder>... harvestJobs) {
            harvestJobs(Stream.of(harvestJobs).map(c -> HarvestJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHarvestJobsResponse build() {
            return new ListHarvestJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
