/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * the option to configure log subscription.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigureLogsRequest extends MediaPackageRequest implements
        ToCopyableBuilder<ConfigureLogsRequest.Builder, ConfigureLogsRequest> {
    private static final SdkField<EgressAccessLogs> EGRESS_ACCESS_LOGS_FIELD = SdkField
            .<EgressAccessLogs> builder(MarshallingType.SDK_POJO).memberName("EgressAccessLogs")
            .getter(getter(ConfigureLogsRequest::egressAccessLogs)).setter(setter(Builder::egressAccessLogs))
            .constructor(EgressAccessLogs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressAccessLogs").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ConfigureLogsRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<IngressAccessLogs> INGRESS_ACCESS_LOGS_FIELD = SdkField
            .<IngressAccessLogs> builder(MarshallingType.SDK_POJO).memberName("IngressAccessLogs")
            .getter(getter(ConfigureLogsRequest::ingressAccessLogs)).setter(setter(Builder::ingressAccessLogs))
            .constructor(IngressAccessLogs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressAccessLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_ACCESS_LOGS_FIELD,
            ID_FIELD, INGRESS_ACCESS_LOGS_FIELD));

    private final EgressAccessLogs egressAccessLogs;

    private final String id;

    private final IngressAccessLogs ingressAccessLogs;

    private ConfigureLogsRequest(BuilderImpl builder) {
        super(builder);
        this.egressAccessLogs = builder.egressAccessLogs;
        this.id = builder.id;
        this.ingressAccessLogs = builder.ingressAccessLogs;
    }

    /**
     * Returns the value of the EgressAccessLogs property for this object.
     * 
     * @return The value of the EgressAccessLogs property for this object.
     */
    public final EgressAccessLogs egressAccessLogs() {
        return egressAccessLogs;
    }

    /**
     * The ID of the channel to log subscription.
     * 
     * @return The ID of the channel to log subscription.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the IngressAccessLogs property for this object.
     * 
     * @return The value of the IngressAccessLogs property for this object.
     */
    public final IngressAccessLogs ingressAccessLogs() {
        return ingressAccessLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(egressAccessLogs());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ingressAccessLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsRequest)) {
            return false;
        }
        ConfigureLogsRequest other = (ConfigureLogsRequest) obj;
        return Objects.equals(egressAccessLogs(), other.egressAccessLogs()) && Objects.equals(id(), other.id())
                && Objects.equals(ingressAccessLogs(), other.ingressAccessLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigureLogsRequest").add("EgressAccessLogs", egressAccessLogs()).add("Id", id())
                .add("IngressAccessLogs", ingressAccessLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressAccessLogs":
            return Optional.ofNullable(clazz.cast(egressAccessLogs()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IngressAccessLogs":
            return Optional.ofNullable(clazz.cast(ingressAccessLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsRequest, T> g) {
        return obj -> g.apply((ConfigureLogsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageRequest.Builder, SdkPojo, CopyableBuilder<Builder, ConfigureLogsRequest> {
        /**
         * Sets the value of the EgressAccessLogs property for this object.
         *
         * @param egressAccessLogs
         *        The new value for the EgressAccessLogs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressAccessLogs(EgressAccessLogs egressAccessLogs);

        /**
         * Sets the value of the EgressAccessLogs property for this object.
         *
         * This is a convenience that creates an instance of the {@link EgressAccessLogs.Builder} avoiding the need to
         * create one manually via {@link EgressAccessLogs#builder()}.
         *
         * When the {@link Consumer} completes, {@link EgressAccessLogs.Builder#build()} is called immediately and its
         * result is passed to {@link #egressAccessLogs(EgressAccessLogs)}.
         * 
         * @param egressAccessLogs
         *        a consumer that will call methods on {@link EgressAccessLogs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressAccessLogs(EgressAccessLogs)
         */
        default Builder egressAccessLogs(Consumer<EgressAccessLogs.Builder> egressAccessLogs) {
            return egressAccessLogs(EgressAccessLogs.builder().applyMutation(egressAccessLogs).build());
        }

        /**
         * The ID of the channel to log subscription.
         * 
         * @param id
         *        The ID of the channel to log subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the IngressAccessLogs property for this object.
         *
         * @param ingressAccessLogs
         *        The new value for the IngressAccessLogs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressAccessLogs(IngressAccessLogs ingressAccessLogs);

        /**
         * Sets the value of the IngressAccessLogs property for this object.
         *
         * This is a convenience that creates an instance of the {@link IngressAccessLogs.Builder} avoiding the need to
         * create one manually via {@link IngressAccessLogs#builder()}.
         *
         * When the {@link Consumer} completes, {@link IngressAccessLogs.Builder#build()} is called immediately and its
         * result is passed to {@link #ingressAccessLogs(IngressAccessLogs)}.
         * 
         * @param ingressAccessLogs
         *        a consumer that will call methods on {@link IngressAccessLogs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressAccessLogs(IngressAccessLogs)
         */
        default Builder ingressAccessLogs(Consumer<IngressAccessLogs.Builder> ingressAccessLogs) {
            return ingressAccessLogs(IngressAccessLogs.builder().applyMutation(ingressAccessLogs).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageRequest.BuilderImpl implements Builder {
        private EgressAccessLogs egressAccessLogs;

        private String id;

        private IngressAccessLogs ingressAccessLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsRequest model) {
            super(model);
            egressAccessLogs(model.egressAccessLogs);
            id(model.id);
            ingressAccessLogs(model.ingressAccessLogs);
        }

        public final EgressAccessLogs.Builder getEgressAccessLogs() {
            return egressAccessLogs != null ? egressAccessLogs.toBuilder() : null;
        }

        public final void setEgressAccessLogs(EgressAccessLogs.BuilderImpl egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs != null ? egressAccessLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder egressAccessLogs(EgressAccessLogs egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final IngressAccessLogs.Builder getIngressAccessLogs() {
            return ingressAccessLogs != null ? ingressAccessLogs.toBuilder() : null;
        }

        public final void setIngressAccessLogs(IngressAccessLogs.BuilderImpl ingressAccessLogs) {
            this.ingressAccessLogs = ingressAccessLogs != null ? ingressAccessLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder ingressAccessLogs(IngressAccessLogs ingressAccessLogs) {
            this.ingressAccessLogs = ingressAccessLogs;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureLogsRequest build() {
            return new ConfigureLogsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
