/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A HTTP Live Streaming (HLS) manifest configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsManifestCreateOrUpdateParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsManifestCreateOrUpdateParameters.Builder, HlsManifestCreateOrUpdateParameters> {
    private static final SdkField<String> AD_MARKERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdMarkers").getter(getter(HlsManifestCreateOrUpdateParameters::adMarkersAsString))
            .setter(setter(Builder::adMarkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build()).build();

    private static final SdkField<List<String>> AD_TRIGGERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdTriggers")
            .getter(getter(HlsManifestCreateOrUpdateParameters::adTriggersAsStrings))
            .setter(setter(Builder::adTriggersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adTriggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ADS_ON_DELIVERY_RESTRICTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdsOnDeliveryRestrictions")
            .getter(getter(HlsManifestCreateOrUpdateParameters::adsOnDeliveryRestrictionsAsString))
            .setter(setter(Builder::adsOnDeliveryRestrictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsOnDeliveryRestrictions").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(HlsManifestCreateOrUpdateParameters::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Boolean> INCLUDE_IFRAME_ONLY_STREAM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeIframeOnlyStream").getter(getter(HlsManifestCreateOrUpdateParameters::includeIframeOnlyStream))
            .setter(setter(Builder::includeIframeOnlyStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeIframeOnlyStream").build())
            .build();

    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestName").getter(getter(HlsManifestCreateOrUpdateParameters::manifestName))
            .setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()).build();

    private static final SdkField<String> PLAYLIST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaylistType").getter(getter(HlsManifestCreateOrUpdateParameters::playlistTypeAsString))
            .setter(setter(Builder::playlistType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistType").build()).build();

    private static final SdkField<Integer> PLAYLIST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PlaylistWindowSeconds").getter(getter(HlsManifestCreateOrUpdateParameters::playlistWindowSeconds))
            .setter(setter(Builder::playlistWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistWindowSeconds").build())
            .build();

    private static final SdkField<Integer> PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramDateTimeIntervalSeconds")
            .getter(getter(HlsManifestCreateOrUpdateParameters::programDateTimeIntervalSeconds))
            .setter(setter(Builder::programDateTimeIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimeIntervalSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD,
            AD_TRIGGERS_FIELD, ADS_ON_DELIVERY_RESTRICTIONS_FIELD, ID_FIELD, INCLUDE_IFRAME_ONLY_STREAM_FIELD,
            MANIFEST_NAME_FIELD, PLAYLIST_TYPE_FIELD, PLAYLIST_WINDOW_SECONDS_FIELD, PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adMarkers;

    private final List<String> adTriggers;

    private final String adsOnDeliveryRestrictions;

    private final String id;

    private final Boolean includeIframeOnlyStream;

    private final String manifestName;

    private final String playlistType;

    private final Integer playlistWindowSeconds;

    private final Integer programDateTimeIntervalSeconds;

    private HlsManifestCreateOrUpdateParameters(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.adTriggers = builder.adTriggers;
        this.adsOnDeliveryRestrictions = builder.adsOnDeliveryRestrictions;
        this.id = builder.id;
        this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
        this.manifestName = builder.manifestName;
        this.playlistType = builder.playlistType;
        this.playlistWindowSeconds = builder.playlistWindowSeconds;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
    }

    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad
     * markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments)
     * taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and
     * blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal
     * ad and program transition events in HLS and CMAF manifests. For this option, you must set a
     * programDateTimeIntervalSeconds value that is greater than 0.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkers} will
     * return {@link AdMarkers#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkersAsString}.
     * </p>
     * 
     * @return This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
     *         SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
     *         markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
     *         generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts
     *         EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this
     *         option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
     * @see AdMarkers
     */
    public final AdMarkers adMarkers() {
        return AdMarkers.fromValue(adMarkers);
    }

    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad
     * markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments)
     * taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and
     * blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal
     * ad and program transition events in HLS and CMAF manifests. For this option, you must set a
     * programDateTimeIntervalSeconds value that is greater than 0.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkers} will
     * return {@link AdMarkers#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkersAsString}.
     * </p>
     * 
     * @return This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
     *         SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
     *         markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
     *         generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts
     *         EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this
     *         option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
     * @see AdMarkers
     */
    public final String adMarkersAsString() {
        return adMarkers;
    }

    /**
     * Returns the value of the AdTriggers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the AdTriggers property for this object.
     */
    public final List<AdTriggersElement> adTriggers() {
        return AdTriggersCopier.copyStringToEnum(adTriggers);
    }

    /**
     * Returns true if the AdTriggers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAdTriggers() {
        return adTriggers != null && !(adTriggers instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AdTriggers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the AdTriggers property for this object.
     */
    public final List<String> adTriggersAsStrings() {
        return adTriggers;
    }

    /**
     * Returns the value of the AdsOnDeliveryRestrictions property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adsOnDeliveryRestrictions} will return {@link AdsOnDeliveryRestrictions#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #adsOnDeliveryRestrictionsAsString}.
     * </p>
     * 
     * @return The value of the AdsOnDeliveryRestrictions property for this object.
     * @see AdsOnDeliveryRestrictions
     */
    public final AdsOnDeliveryRestrictions adsOnDeliveryRestrictions() {
        return AdsOnDeliveryRestrictions.fromValue(adsOnDeliveryRestrictions);
    }

    /**
     * Returns the value of the AdsOnDeliveryRestrictions property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adsOnDeliveryRestrictions} will return {@link AdsOnDeliveryRestrictions#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #adsOnDeliveryRestrictionsAsString}.
     * </p>
     * 
     * @return The value of the AdsOnDeliveryRestrictions property for this object.
     * @see AdsOnDeliveryRestrictions
     */
    public final String adsOnDeliveryRestrictionsAsString() {
        return adsOnDeliveryRestrictions;
    }

    /**
     * The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is
     * created.
     * 
     * @return The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it
     *         is created.
     */
    public final String id() {
        return id;
    }

    /**
     * When enabled, an I-Frame only stream will be included in the output.
     * 
     * @return When enabled, an I-Frame only stream will be included in the output.
     */
    public final Boolean includeIframeOnlyStream() {
        return includeIframeOnlyStream;
    }

    /**
     * An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the
     * manifestName for the OriginEndpoint.
     * 
     * @return An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the
     *         manifestName for the OriginEndpoint.
     */
    public final String manifestName() {
        return manifestName;
    }

    /**
     * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playlistType} will
     * return {@link PlaylistType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #playlistTypeAsString}.
     * </p>
     * 
     * @return The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     *         EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     * @see PlaylistType
     */
    public final PlaylistType playlistType() {
        return PlaylistType.fromValue(playlistType);
    }

    /**
     * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playlistType} will
     * return {@link PlaylistType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #playlistTypeAsString}.
     * </p>
     * 
     * @return The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     *         EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     * @see PlaylistType
     */
    public final String playlistTypeAsString() {
        return playlistType;
    }

    /**
     * Time window (in seconds) contained in each parent manifest.
     * 
     * @return Time window (in seconds) contained in each parent manifest.
     */
    public final Integer playlistWindowSeconds() {
        return playlistWindowSeconds;
    }

    /**
     * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an
     * interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the
     * content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted
     * into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if
     * any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
     *
     * @return The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally,
     *         when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the
     *         ingest time of the content. If the interval is not specified, or set to 0, then no
     *         EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be
     *         generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live
     *         Streaming (HLS) input, it will be passed through to HLS output.
     */
    public final Integer programDateTimeIntervalSeconds() {
        return programDateTimeIntervalSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdTriggers() ? adTriggersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(adsOnDeliveryRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(includeIframeOnlyStream());
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(playlistTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(playlistWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimeIntervalSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsManifestCreateOrUpdateParameters)) {
            return false;
        }
        HlsManifestCreateOrUpdateParameters other = (HlsManifestCreateOrUpdateParameters) obj;
        return Objects.equals(adMarkersAsString(), other.adMarkersAsString()) && hasAdTriggers() == other.hasAdTriggers()
                && Objects.equals(adTriggersAsStrings(), other.adTriggersAsStrings())
                && Objects.equals(adsOnDeliveryRestrictionsAsString(), other.adsOnDeliveryRestrictionsAsString())
                && Objects.equals(id(), other.id()) && Objects.equals(includeIframeOnlyStream(), other.includeIframeOnlyStream())
                && Objects.equals(manifestName(), other.manifestName())
                && Objects.equals(playlistTypeAsString(), other.playlistTypeAsString())
                && Objects.equals(playlistWindowSeconds(), other.playlistWindowSeconds())
                && Objects.equals(programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsManifestCreateOrUpdateParameters").add("AdMarkers", adMarkersAsString())
                .add("AdTriggers", hasAdTriggers() ? adTriggersAsStrings() : null)
                .add("AdsOnDeliveryRestrictions", adsOnDeliveryRestrictionsAsString()).add("Id", id())
                .add("IncludeIframeOnlyStream", includeIframeOnlyStream()).add("ManifestName", manifestName())
                .add("PlaylistType", playlistTypeAsString()).add("PlaylistWindowSeconds", playlistWindowSeconds())
                .add("ProgramDateTimeIntervalSeconds", programDateTimeIntervalSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkers":
            return Optional.ofNullable(clazz.cast(adMarkersAsString()));
        case "AdTriggers":
            return Optional.ofNullable(clazz.cast(adTriggersAsStrings()));
        case "AdsOnDeliveryRestrictions":
            return Optional.ofNullable(clazz.cast(adsOnDeliveryRestrictionsAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IncludeIframeOnlyStream":
            return Optional.ofNullable(clazz.cast(includeIframeOnlyStream()));
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "PlaylistType":
            return Optional.ofNullable(clazz.cast(playlistTypeAsString()));
        case "PlaylistWindowSeconds":
            return Optional.ofNullable(clazz.cast(playlistWindowSeconds()));
        case "ProgramDateTimeIntervalSeconds":
            return Optional.ofNullable(clazz.cast(programDateTimeIntervalSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsManifestCreateOrUpdateParameters, T> g) {
        return obj -> g.apply((HlsManifestCreateOrUpdateParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsManifestCreateOrUpdateParameters> {
        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         * SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
         * markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
         * generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts
         * EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option,
         * you must set a programDateTimeIntervalSeconds value that is greater than 0.
         *
         * @param adMarkers
         *        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         *        SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35
         *        ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
         *        "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input
         *        source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and
         *        CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater
         *        than 0.
         * @see AdMarkers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkers
         */
        Builder adMarkers(String adMarkers);

        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         * SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
         * markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
         * generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts
         * EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option,
         * you must set a programDateTimeIntervalSeconds value that is greater than 0.
         *
         * @param adMarkers
         *        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         *        SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35
         *        ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
         *        "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input
         *        source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and
         *        CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater
         *        than 0.
         * @see AdMarkers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkers
         */
        Builder adMarkers(AdMarkers adMarkers);

        /**
         * Sets the value of the AdTriggers property for this object.
         *
         * @param adTriggers
         *        The new value for the AdTriggers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adTriggersWithStrings(Collection<String> adTriggers);

        /**
         * Sets the value of the AdTriggers property for this object.
         *
         * @param adTriggers
         *        The new value for the AdTriggers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adTriggersWithStrings(String... adTriggers);

        /**
         * Sets the value of the AdTriggers property for this object.
         *
         * @param adTriggers
         *        The new value for the AdTriggers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adTriggers(Collection<AdTriggersElement> adTriggers);

        /**
         * Sets the value of the AdTriggers property for this object.
         *
         * @param adTriggers
         *        The new value for the AdTriggers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adTriggers(AdTriggersElement... adTriggers);

        /**
         * Sets the value of the AdsOnDeliveryRestrictions property for this object.
         *
         * @param adsOnDeliveryRestrictions
         *        The new value for the AdsOnDeliveryRestrictions property for this object.
         * @see AdsOnDeliveryRestrictions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdsOnDeliveryRestrictions
         */
        Builder adsOnDeliveryRestrictions(String adsOnDeliveryRestrictions);

        /**
         * Sets the value of the AdsOnDeliveryRestrictions property for this object.
         *
         * @param adsOnDeliveryRestrictions
         *        The new value for the AdsOnDeliveryRestrictions property for this object.
         * @see AdsOnDeliveryRestrictions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdsOnDeliveryRestrictions
         */
        Builder adsOnDeliveryRestrictions(AdsOnDeliveryRestrictions adsOnDeliveryRestrictions);

        /**
         * The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is
         * created.
         * 
         * @param id
         *        The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after
         *        it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * When enabled, an I-Frame only stream will be included in the output.
         * 
         * @param includeIframeOnlyStream
         *        When enabled, an I-Frame only stream will be included in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream);

        /**
         * An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the
         * manifestName for the OriginEndpoint.
         * 
         * @param manifestName
         *        An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to
         *        the manifestName for the OriginEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
         * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         *
         * @param playlistType
         *        The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a
         *        corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         * @see PlaylistType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaylistType
         */
        Builder playlistType(String playlistType);

        /**
         * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
         * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         *
         * @param playlistType
         *        The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a
         *        corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         * @see PlaylistType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaylistType
         */
        Builder playlistType(PlaylistType playlistType);

        /**
         * Time window (in seconds) contained in each parent manifest.
         * 
         * @param playlistWindowSeconds
         *        Time window (in seconds) contained in each parent manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playlistWindowSeconds(Integer playlistWindowSeconds);

        /**
         * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally,
         * when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest
         * time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will
         * be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of
         * this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed
         * through to HLS output.
         *
         * @param programDateTimeIntervalSeconds
         *        The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests.
         *        Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5
         *        seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no
         *        EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be
         *        generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live
         *        Streaming (HLS) input, it will be passed through to HLS output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String adMarkers;

        private List<String> adTriggers = DefaultSdkAutoConstructList.getInstance();

        private String adsOnDeliveryRestrictions;

        private String id;

        private Boolean includeIframeOnlyStream;

        private String manifestName;

        private String playlistType;

        private Integer playlistWindowSeconds;

        private Integer programDateTimeIntervalSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsManifestCreateOrUpdateParameters model) {
            adMarkers(model.adMarkers);
            adTriggersWithStrings(model.adTriggers);
            adsOnDeliveryRestrictions(model.adsOnDeliveryRestrictions);
            id(model.id);
            includeIframeOnlyStream(model.includeIframeOnlyStream);
            manifestName(model.manifestName);
            playlistType(model.playlistType);
            playlistWindowSeconds(model.playlistWindowSeconds);
            programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
        }

        public final String getAdMarkers() {
            return adMarkers;
        }

        public final void setAdMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
        }

        @Override
        @Transient
        public final Builder adMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
            return this;
        }

        @Override
        @Transient
        public final Builder adMarkers(AdMarkers adMarkers) {
            this.adMarkers(adMarkers == null ? null : adMarkers.toString());
            return this;
        }

        public final Collection<String> getAdTriggers() {
            if (adTriggers instanceof SdkAutoConstructList) {
                return null;
            }
            return adTriggers;
        }

        public final void setAdTriggers(Collection<String> adTriggers) {
            this.adTriggers = AdTriggersCopier.copy(adTriggers);
        }

        @Override
        @Transient
        public final Builder adTriggersWithStrings(Collection<String> adTriggers) {
            this.adTriggers = AdTriggersCopier.copy(adTriggers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder adTriggersWithStrings(String... adTriggers) {
            adTriggersWithStrings(Arrays.asList(adTriggers));
            return this;
        }

        @Override
        @Transient
        public final Builder adTriggers(Collection<AdTriggersElement> adTriggers) {
            this.adTriggers = AdTriggersCopier.copyEnumToString(adTriggers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder adTriggers(AdTriggersElement... adTriggers) {
            adTriggers(Arrays.asList(adTriggers));
            return this;
        }

        public final String getAdsOnDeliveryRestrictions() {
            return adsOnDeliveryRestrictions;
        }

        public final void setAdsOnDeliveryRestrictions(String adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
        }

        @Override
        @Transient
        public final Builder adsOnDeliveryRestrictions(String adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
            return this;
        }

        @Override
        @Transient
        public final Builder adsOnDeliveryRestrictions(AdsOnDeliveryRestrictions adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions(adsOnDeliveryRestrictions == null ? null : adsOnDeliveryRestrictions.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getIncludeIframeOnlyStream() {
            return includeIframeOnlyStream;
        }

        public final void setIncludeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
        }

        @Override
        @Transient
        public final Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
            return this;
        }

        public final String getManifestName() {
            return manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        @Transient
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final String getPlaylistType() {
            return playlistType;
        }

        public final void setPlaylistType(String playlistType) {
            this.playlistType = playlistType;
        }

        @Override
        @Transient
        public final Builder playlistType(String playlistType) {
            this.playlistType = playlistType;
            return this;
        }

        @Override
        @Transient
        public final Builder playlistType(PlaylistType playlistType) {
            this.playlistType(playlistType == null ? null : playlistType.toString());
            return this;
        }

        public final Integer getPlaylistWindowSeconds() {
            return playlistWindowSeconds;
        }

        public final void setPlaylistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
        }

        @Override
        @Transient
        public final Builder playlistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
            return this;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return programDateTimeIntervalSeconds;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        @Override
        @Transient
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        @Override
        public HlsManifestCreateOrUpdateParameters build() {
            return new HlsManifestCreateOrUpdateParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
