/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configuration parameters for where in an S3 bucket to place the harvested content
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Destination implements SdkPojo, Serializable, ToCopyableBuilder<S3Destination.Builder, S3Destination> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(S3Destination::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> MANIFEST_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestKey").getter(getter(S3Destination::manifestKey)).setter(setter(Builder::manifestKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestKey").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(S3Destination::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            MANIFEST_KEY_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String manifestKey;

    private final String roleArn;

    private S3Destination(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.manifestKey = builder.manifestKey;
        this.roleArn = builder.roleArn;
    }

    /**
     * The name of an S3 bucket within which harvested content will be exported
     *
     * @return The name of an S3 bucket within which harvested content will be exported
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * The key in the specified S3 bucket where the harvested top-level manifest will be placed.
     *
     * @return The key in the specified S3 bucket where the harvested top-level manifest will be placed.
     */
    public final String manifestKey() {
        return manifestKey;
    }

    /**
     * The IAM role used to write to the specified S3 bucket
     *
     * @return The IAM role used to write to the specified S3 bucket
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(manifestKey());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Destination)) {
            return false;
        }
        S3Destination other = (S3Destination) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(manifestKey(), other.manifestKey())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Destination").add("BucketName", bucketName()).add("ManifestKey", manifestKey())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "ManifestKey":
            return Optional.ofNullable(clazz.cast(manifestKey()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Destination, T> g) {
        return obj -> g.apply((S3Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Destination> {
        /**
         * The name of an S3 bucket within which harvested content will be exported
         *
         * @param bucketName
         *        The name of an S3 bucket within which harvested content will be exported
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * The key in the specified S3 bucket where the harvested top-level manifest will be placed.
         *
         * @param manifestKey
         *        The key in the specified S3 bucket where the harvested top-level manifest will be placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestKey(String manifestKey);

        /**
         * The IAM role used to write to the specified S3 bucket
         *
         * @param roleArn
         *        The IAM role used to write to the specified S3 bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String manifestKey;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Destination model) {
            bucketName(model.bucketName);
            manifestKey(model.manifestKey);
            roleArn(model.roleArn);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getManifestKey() {
            return manifestKey;
        }

        public final void setManifestKey(String manifestKey) {
            this.manifestKey = manifestKey;
        }

        @Override
        public final Builder manifestKey(String manifestKey) {
            this.manifestKey = manifestKey;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public S3Destination build() {
            return new S3Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
