/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RotateIngestEndpointCredentialsResponse extends MediaPackageResponse implements
        ToCopyableBuilder<RotateIngestEndpointCredentialsResponse.Builder, RotateIngestEndpointCredentialsResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RotateIngestEndpointCredentialsResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RotateIngestEndpointCredentialsResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<EgressAccessLogs> EGRESS_ACCESS_LOGS_FIELD = SdkField
            .<EgressAccessLogs> builder(MarshallingType.SDK_POJO).memberName("EgressAccessLogs")
            .getter(getter(RotateIngestEndpointCredentialsResponse::egressAccessLogs)).setter(setter(Builder::egressAccessLogs))
            .constructor(EgressAccessLogs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressAccessLogs").build()).build();

    private static final SdkField<HlsIngest> HLS_INGEST_FIELD = SdkField.<HlsIngest> builder(MarshallingType.SDK_POJO)
            .memberName("HlsIngest").getter(getter(RotateIngestEndpointCredentialsResponse::hlsIngest))
            .setter(setter(Builder::hlsIngest)).constructor(HlsIngest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsIngest").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RotateIngestEndpointCredentialsResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<IngressAccessLogs> INGRESS_ACCESS_LOGS_FIELD = SdkField
            .<IngressAccessLogs> builder(MarshallingType.SDK_POJO).memberName("IngressAccessLogs")
            .getter(getter(RotateIngestEndpointCredentialsResponse::ingressAccessLogs))
            .setter(setter(Builder::ingressAccessLogs)).constructor(IngressAccessLogs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressAccessLogs").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(RotateIngestEndpointCredentialsResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            EGRESS_ACCESS_LOGS_FIELD, HLS_INGEST_FIELD, ID_FIELD, INGRESS_ACCESS_LOGS_FIELD, TAGS_FIELD));

    private final String arn;

    private final String description;

    private final EgressAccessLogs egressAccessLogs;

    private final HlsIngest hlsIngest;

    private final String id;

    private final IngressAccessLogs ingressAccessLogs;

    private final Map<String, String> tags;

    private RotateIngestEndpointCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.egressAccessLogs = builder.egressAccessLogs;
        this.hlsIngest = builder.hlsIngest;
        this.id = builder.id;
        this.ingressAccessLogs = builder.ingressAccessLogs;
        this.tags = builder.tags;
    }

    /**
     * The Amazon Resource Name (ARN) assigned to the Channel.
     * 
     * @return The Amazon Resource Name (ARN) assigned to the Channel.
     */
    public final String arn() {
        return arn;
    }

    /**
     * A short text description of the Channel.
     * 
     * @return A short text description of the Channel.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the EgressAccessLogs property for this object.
     * 
     * @return The value of the EgressAccessLogs property for this object.
     */
    public final EgressAccessLogs egressAccessLogs() {
        return egressAccessLogs;
    }

    /**
     * Returns the value of the HlsIngest property for this object.
     * 
     * @return The value of the HlsIngest property for this object.
     */
    public final HlsIngest hlsIngest() {
        return hlsIngest;
    }

    /**
     * The ID of the Channel.
     * 
     * @return The ID of the Channel.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the IngressAccessLogs property for this object.
     * 
     * @return The value of the IngressAccessLogs property for this object.
     */
    public final IngressAccessLogs ingressAccessLogs() {
        return ingressAccessLogs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(egressAccessLogs());
        hashCode = 31 * hashCode + Objects.hashCode(hlsIngest());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ingressAccessLogs());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotateIngestEndpointCredentialsResponse)) {
            return false;
        }
        RotateIngestEndpointCredentialsResponse other = (RotateIngestEndpointCredentialsResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(egressAccessLogs(), other.egressAccessLogs()) && Objects.equals(hlsIngest(), other.hlsIngest())
                && Objects.equals(id(), other.id()) && Objects.equals(ingressAccessLogs(), other.ingressAccessLogs())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RotateIngestEndpointCredentialsResponse").add("Arn", arn()).add("Description", description())
                .add("EgressAccessLogs", egressAccessLogs()).add("HlsIngest", hlsIngest()).add("Id", id())
                .add("IngressAccessLogs", ingressAccessLogs()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EgressAccessLogs":
            return Optional.ofNullable(clazz.cast(egressAccessLogs()));
        case "HlsIngest":
            return Optional.ofNullable(clazz.cast(hlsIngest()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IngressAccessLogs":
            return Optional.ofNullable(clazz.cast(ingressAccessLogs()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RotateIngestEndpointCredentialsResponse, T> g) {
        return obj -> g.apply((RotateIngestEndpointCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RotateIngestEndpointCredentialsResponse> {
        /**
         * The Amazon Resource Name (ARN) assigned to the Channel.
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) assigned to the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * A short text description of the Channel.
         * 
         * @param description
         *        A short text description of the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the EgressAccessLogs property for this object.
         *
         * @param egressAccessLogs
         *        The new value for the EgressAccessLogs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressAccessLogs(EgressAccessLogs egressAccessLogs);

        /**
         * Sets the value of the EgressAccessLogs property for this object.
         *
         * This is a convenience that creates an instance of the {@link EgressAccessLogs.Builder} avoiding the need to
         * create one manually via {@link EgressAccessLogs#builder()}.
         *
         * When the {@link Consumer} completes, {@link EgressAccessLogs.Builder#build()} is called immediately and its
         * result is passed to {@link #egressAccessLogs(EgressAccessLogs)}.
         * 
         * @param egressAccessLogs
         *        a consumer that will call methods on {@link EgressAccessLogs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressAccessLogs(EgressAccessLogs)
         */
        default Builder egressAccessLogs(Consumer<EgressAccessLogs.Builder> egressAccessLogs) {
            return egressAccessLogs(EgressAccessLogs.builder().applyMutation(egressAccessLogs).build());
        }

        /**
         * Sets the value of the HlsIngest property for this object.
         *
         * @param hlsIngest
         *        The new value for the HlsIngest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsIngest(HlsIngest hlsIngest);

        /**
         * Sets the value of the HlsIngest property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsIngest.Builder} avoiding the need to create
         * one manually via {@link HlsIngest#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsIngest.Builder#build()} is called immediately and its result
         * is passed to {@link #hlsIngest(HlsIngest)}.
         * 
         * @param hlsIngest
         *        a consumer that will call methods on {@link HlsIngest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsIngest(HlsIngest)
         */
        default Builder hlsIngest(Consumer<HlsIngest.Builder> hlsIngest) {
            return hlsIngest(HlsIngest.builder().applyMutation(hlsIngest).build());
        }

        /**
         * The ID of the Channel.
         * 
         * @param id
         *        The ID of the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the IngressAccessLogs property for this object.
         *
         * @param ingressAccessLogs
         *        The new value for the IngressAccessLogs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressAccessLogs(IngressAccessLogs ingressAccessLogs);

        /**
         * Sets the value of the IngressAccessLogs property for this object.
         *
         * This is a convenience that creates an instance of the {@link IngressAccessLogs.Builder} avoiding the need to
         * create one manually via {@link IngressAccessLogs#builder()}.
         *
         * When the {@link Consumer} completes, {@link IngressAccessLogs.Builder#build()} is called immediately and its
         * result is passed to {@link #ingressAccessLogs(IngressAccessLogs)}.
         * 
         * @param ingressAccessLogs
         *        a consumer that will call methods on {@link IngressAccessLogs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressAccessLogs(IngressAccessLogs)
         */
        default Builder ingressAccessLogs(Consumer<IngressAccessLogs.Builder> ingressAccessLogs) {
            return ingressAccessLogs(IngressAccessLogs.builder().applyMutation(ingressAccessLogs).build());
        }

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaPackageResponse.BuilderImpl implements Builder {
        private String arn;

        private String description;

        private EgressAccessLogs egressAccessLogs;

        private HlsIngest hlsIngest;

        private String id;

        private IngressAccessLogs ingressAccessLogs;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RotateIngestEndpointCredentialsResponse model) {
            super(model);
            arn(model.arn);
            description(model.description);
            egressAccessLogs(model.egressAccessLogs);
            hlsIngest(model.hlsIngest);
            id(model.id);
            ingressAccessLogs(model.ingressAccessLogs);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EgressAccessLogs.Builder getEgressAccessLogs() {
            return egressAccessLogs != null ? egressAccessLogs.toBuilder() : null;
        }

        public final void setEgressAccessLogs(EgressAccessLogs.BuilderImpl egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs != null ? egressAccessLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder egressAccessLogs(EgressAccessLogs egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs;
            return this;
        }

        public final HlsIngest.Builder getHlsIngest() {
            return hlsIngest != null ? hlsIngest.toBuilder() : null;
        }

        public final void setHlsIngest(HlsIngest.BuilderImpl hlsIngest) {
            this.hlsIngest = hlsIngest != null ? hlsIngest.build() : null;
        }

        @Override
        @Transient
        public final Builder hlsIngest(HlsIngest hlsIngest) {
            this.hlsIngest = hlsIngest;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final IngressAccessLogs.Builder getIngressAccessLogs() {
            return ingressAccessLogs != null ? ingressAccessLogs.toBuilder() : null;
        }

        public final void setIngressAccessLogs(IngressAccessLogs.BuilderImpl ingressAccessLogs) {
            this.ingressAccessLogs = ingressAccessLogs != null ? ingressAccessLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder ingressAccessLogs(IngressAccessLogs ingressAccessLogs) {
            this.ingressAccessLogs = ingressAccessLogs;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public RotateIngestEndpointCredentialsResponse build() {
            return new RotateIngestEndpointCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
