/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Profile {
    NONE("NONE"),
    HBBTV_1_5("HBBTV_1_5"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Profile> VALUE_MAP;
    private final String value;

    private Profile(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Profile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Profile> knownValues() {
        EnumSet<Profile> knownValues = EnumSet.allOf(Profile.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Profile.class, Profile::toString);
    }
}

