/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackage.model.Authorization;
import software.amazon.awssdk.services.mediapackage.model.CmafPackage;
import software.amazon.awssdk.services.mediapackage.model.DashPackage;
import software.amazon.awssdk.services.mediapackage.model.HlsPackage;
import software.amazon.awssdk.services.mediapackage.model.MediaPackageResponse;
import software.amazon.awssdk.services.mediapackage.model.MssPackage;
import software.amazon.awssdk.services.mediapackage.model.Origination;
import software.amazon.awssdk.services.mediapackage.model.TagsCopier;
import software.amazon.awssdk.services.mediapackage.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOriginEndpointResponse
extends MediaPackageResponse
implements ToCopyableBuilder<Builder, CreateOriginEndpointResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::arn)).setter(CreateOriginEndpointResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Authorization> AUTHORIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authorization").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::authorization)).setter(CreateOriginEndpointResponse.setter(Builder::authorization)).constructor(Authorization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorization").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::channelId)).setter(CreateOriginEndpointResponse.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()}).build();
    private static final SdkField<CmafPackage> CMAF_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CmafPackage").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::cmafPackage)).setter(CreateOriginEndpointResponse.setter(Builder::cmafPackage)).constructor(CmafPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafPackage").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::createdAt)).setter(CreateOriginEndpointResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<DashPackage> DASH_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashPackage").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::dashPackage)).setter(CreateOriginEndpointResponse.setter(Builder::dashPackage)).constructor(DashPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashPackage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::description)).setter(CreateOriginEndpointResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<HlsPackage> HLS_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsPackage").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::hlsPackage)).setter(CreateOriginEndpointResponse.setter(Builder::hlsPackage)).constructor(HlsPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsPackage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::id)).setter(CreateOriginEndpointResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestName").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::manifestName)).setter(CreateOriginEndpointResponse.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()}).build();
    private static final SdkField<MssPackage> MSS_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MssPackage").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::mssPackage)).setter(CreateOriginEndpointResponse.setter(Builder::mssPackage)).constructor(MssPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mssPackage").build()}).build();
    private static final SdkField<String> ORIGINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Origination").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::originationAsString)).setter(CreateOriginEndpointResponse.setter(Builder::origination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origination").build()}).build();
    private static final SdkField<Integer> STARTOVER_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartoverWindowSeconds").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::startoverWindowSeconds)).setter(CreateOriginEndpointResponse.setter(Builder::startoverWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startoverWindowSeconds").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::tags)).setter(CreateOriginEndpointResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> TIME_DELAY_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeDelaySeconds").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::timeDelaySeconds)).setter(CreateOriginEndpointResponse.setter(Builder::timeDelaySeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDelaySeconds").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::url)).setter(CreateOriginEndpointResponse.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<List<String>> WHITELIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Whitelist").getter(CreateOriginEndpointResponse.getter(CreateOriginEndpointResponse::whitelist)).setter(CreateOriginEndpointResponse.setter(Builder::whitelist)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelist").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTHORIZATION_FIELD, CHANNEL_ID_FIELD, CMAF_PACKAGE_FIELD, CREATED_AT_FIELD, DASH_PACKAGE_FIELD, DESCRIPTION_FIELD, HLS_PACKAGE_FIELD, ID_FIELD, MANIFEST_NAME_FIELD, MSS_PACKAGE_FIELD, ORIGINATION_FIELD, STARTOVER_WINDOW_SECONDS_FIELD, TAGS_FIELD, TIME_DELAY_SECONDS_FIELD, URL_FIELD, WHITELIST_FIELD));
    private final String arn;
    private final Authorization authorization;
    private final String channelId;
    private final CmafPackage cmafPackage;
    private final String createdAt;
    private final DashPackage dashPackage;
    private final String description;
    private final HlsPackage hlsPackage;
    private final String id;
    private final String manifestName;
    private final MssPackage mssPackage;
    private final String origination;
    private final Integer startoverWindowSeconds;
    private final Map<String, String> tags;
    private final Integer timeDelaySeconds;
    private final String url;
    private final List<String> whitelist;

    private CreateOriginEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.authorization = builder.authorization;
        this.channelId = builder.channelId;
        this.cmafPackage = builder.cmafPackage;
        this.createdAt = builder.createdAt;
        this.dashPackage = builder.dashPackage;
        this.description = builder.description;
        this.hlsPackage = builder.hlsPackage;
        this.id = builder.id;
        this.manifestName = builder.manifestName;
        this.mssPackage = builder.mssPackage;
        this.origination = builder.origination;
        this.startoverWindowSeconds = builder.startoverWindowSeconds;
        this.tags = builder.tags;
        this.timeDelaySeconds = builder.timeDelaySeconds;
        this.url = builder.url;
        this.whitelist = builder.whitelist;
    }

    public final String arn() {
        return this.arn;
    }

    public final Authorization authorization() {
        return this.authorization;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final CmafPackage cmafPackage() {
        return this.cmafPackage;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final DashPackage dashPackage() {
        return this.dashPackage;
    }

    public final String description() {
        return this.description;
    }

    public final HlsPackage hlsPackage() {
        return this.hlsPackage;
    }

    public final String id() {
        return this.id;
    }

    public final String manifestName() {
        return this.manifestName;
    }

    public final MssPackage mssPackage() {
        return this.mssPackage;
    }

    public final Origination origination() {
        return Origination.fromValue(this.origination);
    }

    public final String originationAsString() {
        return this.origination;
    }

    public final Integer startoverWindowSeconds() {
        return this.startoverWindowSeconds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Integer timeDelaySeconds() {
        return this.timeDelaySeconds;
    }

    public final String url() {
        return this.url;
    }

    public final boolean hasWhitelist() {
        return this.whitelist != null && !(this.whitelist instanceof SdkAutoConstructList);
    }

    public final List<String> whitelist() {
        return this.whitelist;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorization());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cmafPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mssPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startoverWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeDelaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWhitelist() ? this.whitelist() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOriginEndpointResponse)) {
            return false;
        }
        CreateOriginEndpointResponse other = (CreateOriginEndpointResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.authorization(), other.authorization()) && Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.cmafPackage(), other.cmafPackage()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dashPackage(), other.dashPackage()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.hlsPackage(), other.hlsPackage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.mssPackage(), other.mssPackage()) && Objects.equals(this.originationAsString(), other.originationAsString()) && Objects.equals(this.startoverWindowSeconds(), other.startoverWindowSeconds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.timeDelaySeconds(), other.timeDelaySeconds()) && Objects.equals(this.url(), other.url()) && this.hasWhitelist() == other.hasWhitelist() && Objects.equals(this.whitelist(), other.whitelist());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOriginEndpointResponse").add("Arn", (Object)this.arn()).add("Authorization", (Object)this.authorization()).add("ChannelId", (Object)this.channelId()).add("CmafPackage", (Object)this.cmafPackage()).add("CreatedAt", (Object)this.createdAt()).add("DashPackage", (Object)this.dashPackage()).add("Description", (Object)this.description()).add("HlsPackage", (Object)this.hlsPackage()).add("Id", (Object)this.id()).add("ManifestName", (Object)this.manifestName()).add("MssPackage", (Object)this.mssPackage()).add("Origination", (Object)this.originationAsString()).add("StartoverWindowSeconds", (Object)this.startoverWindowSeconds()).add("Tags", this.hasTags() ? this.tags() : null).add("TimeDelaySeconds", (Object)this.timeDelaySeconds()).add("Url", (Object)this.url()).add("Whitelist", this.hasWhitelist() ? this.whitelist() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Authorization": {
                return Optional.ofNullable(clazz.cast(this.authorization()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "CmafPackage": {
                return Optional.ofNullable(clazz.cast(this.cmafPackage()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DashPackage": {
                return Optional.ofNullable(clazz.cast(this.dashPackage()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HlsPackage": {
                return Optional.ofNullable(clazz.cast(this.hlsPackage()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "MssPackage": {
                return Optional.ofNullable(clazz.cast(this.mssPackage()));
            }
            case "Origination": {
                return Optional.ofNullable(clazz.cast(this.originationAsString()));
            }
            case "StartoverWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.startoverWindowSeconds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TimeDelaySeconds": {
                return Optional.ofNullable(clazz.cast(this.timeDelaySeconds()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "Whitelist": {
                return Optional.ofNullable(clazz.cast(this.whitelist()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOriginEndpointResponse, T> g) {
        return obj -> g.apply((CreateOriginEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Authorization authorization;
        private String channelId;
        private CmafPackage cmafPackage;
        private String createdAt;
        private DashPackage dashPackage;
        private String description;
        private HlsPackage hlsPackage;
        private String id;
        private String manifestName;
        private MssPackage mssPackage;
        private String origination;
        private Integer startoverWindowSeconds;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer timeDelaySeconds;
        private String url;
        private List<String> whitelist = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOriginEndpointResponse model) {
            super(model);
            this.arn(model.arn);
            this.authorization(model.authorization);
            this.channelId(model.channelId);
            this.cmafPackage(model.cmafPackage);
            this.createdAt(model.createdAt);
            this.dashPackage(model.dashPackage);
            this.description(model.description);
            this.hlsPackage(model.hlsPackage);
            this.id(model.id);
            this.manifestName(model.manifestName);
            this.mssPackage(model.mssPackage);
            this.origination(model.origination);
            this.startoverWindowSeconds(model.startoverWindowSeconds);
            this.tags(model.tags);
            this.timeDelaySeconds(model.timeDelaySeconds);
            this.url(model.url);
            this.whitelist(model.whitelist);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Authorization.Builder getAuthorization() {
            return this.authorization != null ? this.authorization.toBuilder() : null;
        }

        public final void setAuthorization(Authorization.BuilderImpl authorization) {
            this.authorization = authorization != null ? authorization.build() : null;
        }

        @Override
        public final Builder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final CmafPackage.Builder getCmafPackage() {
            return this.cmafPackage != null ? this.cmafPackage.toBuilder() : null;
        }

        public final void setCmafPackage(CmafPackage.BuilderImpl cmafPackage) {
            this.cmafPackage = cmafPackage != null ? cmafPackage.build() : null;
        }

        @Override
        public final Builder cmafPackage(CmafPackage cmafPackage) {
            this.cmafPackage = cmafPackage;
            return this;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final DashPackage.Builder getDashPackage() {
            return this.dashPackage != null ? this.dashPackage.toBuilder() : null;
        }

        public final void setDashPackage(DashPackage.BuilderImpl dashPackage) {
            this.dashPackage = dashPackage != null ? dashPackage.build() : null;
        }

        @Override
        public final Builder dashPackage(DashPackage dashPackage) {
            this.dashPackage = dashPackage;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final HlsPackage.Builder getHlsPackage() {
            return this.hlsPackage != null ? this.hlsPackage.toBuilder() : null;
        }

        public final void setHlsPackage(HlsPackage.BuilderImpl hlsPackage) {
            this.hlsPackage = hlsPackage != null ? hlsPackage.build() : null;
        }

        @Override
        public final Builder hlsPackage(HlsPackage hlsPackage) {
            this.hlsPackage = hlsPackage;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final MssPackage.Builder getMssPackage() {
            return this.mssPackage != null ? this.mssPackage.toBuilder() : null;
        }

        public final void setMssPackage(MssPackage.BuilderImpl mssPackage) {
            this.mssPackage = mssPackage != null ? mssPackage.build() : null;
        }

        @Override
        public final Builder mssPackage(MssPackage mssPackage) {
            this.mssPackage = mssPackage;
            return this;
        }

        public final String getOrigination() {
            return this.origination;
        }

        public final void setOrigination(String origination) {
            this.origination = origination;
        }

        @Override
        public final Builder origination(String origination) {
            this.origination = origination;
            return this;
        }

        @Override
        public final Builder origination(Origination origination) {
            this.origination(origination == null ? null : origination.toString());
            return this;
        }

        public final Integer getStartoverWindowSeconds() {
            return this.startoverWindowSeconds;
        }

        public final void setStartoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
        }

        @Override
        public final Builder startoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Integer getTimeDelaySeconds() {
            return this.timeDelaySeconds;
        }

        public final void setTimeDelaySeconds(Integer timeDelaySeconds) {
            this.timeDelaySeconds = timeDelaySeconds;
        }

        @Override
        public final Builder timeDelaySeconds(Integer timeDelaySeconds) {
            this.timeDelaySeconds = timeDelaySeconds;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Collection<String> getWhitelist() {
            if (this.whitelist instanceof SdkAutoConstructList) {
                return null;
            }
            return this.whitelist;
        }

        public final void setWhitelist(Collection<String> whitelist) {
            this.whitelist = ___listOf__stringCopier.copy(whitelist);
        }

        @Override
        public final Builder whitelist(Collection<String> whitelist) {
            this.whitelist = ___listOf__stringCopier.copy(whitelist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelist(String ... whitelist) {
            this.whitelist(Arrays.asList(whitelist));
            return this;
        }

        @Override
        public CreateOriginEndpointResponse build() {
            return new CreateOriginEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOriginEndpointResponse> {
        public Builder arn(String var1);

        public Builder authorization(Authorization var1);

        default public Builder authorization(Consumer<Authorization.Builder> authorization) {
            return this.authorization((Authorization)((Authorization.Builder)Authorization.builder().applyMutation(authorization)).build());
        }

        public Builder channelId(String var1);

        public Builder cmafPackage(CmafPackage var1);

        default public Builder cmafPackage(Consumer<CmafPackage.Builder> cmafPackage) {
            return this.cmafPackage((CmafPackage)((CmafPackage.Builder)CmafPackage.builder().applyMutation(cmafPackage)).build());
        }

        public Builder createdAt(String var1);

        public Builder dashPackage(DashPackage var1);

        default public Builder dashPackage(Consumer<DashPackage.Builder> dashPackage) {
            return this.dashPackage((DashPackage)((DashPackage.Builder)DashPackage.builder().applyMutation(dashPackage)).build());
        }

        public Builder description(String var1);

        public Builder hlsPackage(HlsPackage var1);

        default public Builder hlsPackage(Consumer<HlsPackage.Builder> hlsPackage) {
            return this.hlsPackage((HlsPackage)((HlsPackage.Builder)HlsPackage.builder().applyMutation(hlsPackage)).build());
        }

        public Builder id(String var1);

        public Builder manifestName(String var1);

        public Builder mssPackage(MssPackage var1);

        default public Builder mssPackage(Consumer<MssPackage.Builder> mssPackage) {
            return this.mssPackage((MssPackage)((MssPackage.Builder)MssPackage.builder().applyMutation(mssPackage)).build());
        }

        public Builder origination(String var1);

        public Builder origination(Origination var1);

        public Builder startoverWindowSeconds(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder timeDelaySeconds(Integer var1);

        public Builder url(String var1);

        public Builder whitelist(Collection<String> var1);

        public Builder whitelist(String ... var1);
    }
}

