/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PlaylistType {
    NONE("NONE"),
    EVENT("EVENT"),
    VOD("VOD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PlaylistType> VALUE_MAP;
    private final String value;

    private PlaylistType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlaylistType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlaylistType> knownValues() {
        EnumSet<PlaylistType> knownValues = EnumSet.allOf(PlaylistType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PlaylistType.class, PlaylistType::toString);
    }
}

