/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide
 * encryption keys.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpekeKeyProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<SpekeKeyProvider.Builder, SpekeKeyProvider> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SpekeKeyProvider::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SpekeKeyProvider::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SpekeKeyProvider::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<String>> SYSTEM_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SpekeKeyProvider::systemIds))
            .setter(setter(Builder::systemIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SpekeKeyProvider::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            RESOURCE_ID_FIELD, ROLE_ARN_FIELD, SYSTEM_IDS_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateArn;

    private final String resourceId;

    private final String roleArn;

    private final List<String> systemIds;

    private final String url;

    private SpekeKeyProvider(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.resourceId = builder.resourceId;
        this.roleArn = builder.roleArn;
        this.systemIds = builder.systemIds;
        this.url = builder.url;
    }

    /**
     * An Amazon Resource Name (ARN) of a Certificate Manager certificate that MediaPackage will use for enforcing
     * secure end-to-end data transfer with the key provider service.
     *
     * @return An Amazon Resource Name (ARN) of a Certificate Manager certificate that MediaPackage will use for
     *         enforcing secure end-to-end data transfer with the key provider service.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * The resource ID to include in key requests.
     * 
     * @return The resource ID to include in key requests.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * An Amazon Resource Name (ARN) of an IAM role that AWS Elemental MediaPackage will assume when accessing the key
     * provider service.
     *
     * @return An Amazon Resource Name (ARN) of an IAM role that AWS Elemental MediaPackage will assume when accessing
     *         the key provider service.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * The system IDs to include in key requests.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The system IDs to include in key requests.
     */
    public List<String> systemIds() {
        return systemIds;
    }

    /**
     * The URL of the external key provider service.
     * 
     * @return The URL of the external key provider service.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(systemIds());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpekeKeyProvider)) {
            return false;
        }
        SpekeKeyProvider other = (SpekeKeyProvider) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(systemIds(), other.systemIds())
                && Objects.equals(url(), other.url());
    }

    @Override
    public String toString() {
        return ToString.builder("SpekeKeyProvider").add("CertificateArn", certificateArn()).add("ResourceId", resourceId())
                .add("RoleArn", roleArn()).add("SystemIds", systemIds()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SystemIds":
            return Optional.ofNullable(clazz.cast(systemIds()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpekeKeyProvider, T> g) {
        return obj -> g.apply((SpekeKeyProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpekeKeyProvider> {
        /**
         * An Amazon Resource Name (ARN) of a Certificate Manager certificate that MediaPackage will use for enforcing
         * secure end-to-end data transfer with the key provider service.
         *
         * @param certificateArn
         *        An Amazon Resource Name (ARN) of a Certificate Manager certificate that MediaPackage will use for
         *        enforcing secure end-to-end data transfer with the key provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * The resource ID to include in key requests.
         * 
         * @param resourceId
         *        The resource ID to include in key requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * An Amazon Resource Name (ARN) of an IAM role that AWS Elemental MediaPackage will assume when accessing the
         * key provider service.
         *
         * @param roleArn
         *        An Amazon Resource Name (ARN) of an IAM role that AWS Elemental MediaPackage will assume when
         *        accessing the key provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * The system IDs to include in key requests.
         * 
         * @param systemIds
         *        The system IDs to include in key requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemIds(Collection<String> systemIds);

        /**
         * The system IDs to include in key requests.
         * 
         * @param systemIds
         *        The system IDs to include in key requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemIds(String... systemIds);

        /**
         * The URL of the external key provider service.
         * 
         * @param url
         *        The URL of the external key provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String resourceId;

        private String roleArn;

        private List<String> systemIds = DefaultSdkAutoConstructList.getInstance();

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(SpekeKeyProvider model) {
            certificateArn(model.certificateArn);
            resourceId(model.resourceId);
            roleArn(model.roleArn);
            systemIds(model.systemIds);
            url(model.url);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getSystemIds() {
            return systemIds;
        }

        @Override
        public final Builder systemIds(Collection<String> systemIds) {
            this.systemIds = ___listOf__stringCopier.copy(systemIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemIds(String... systemIds) {
            systemIds(Arrays.asList(systemIds));
            return this;
        }

        public final void setSystemIds(Collection<String> systemIds) {
            this.systemIds = ___listOf__stringCopier.copy(systemIds);
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public SpekeKeyProvider build() {
            return new SpekeKeyProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
