/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Authorization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Authorization> {
    private static final SdkField<String> CDN_IDENTIFIER_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CdnIdentifierSecret").getter(Authorization.getter(Authorization::cdnIdentifierSecret)).setter(Authorization.setter(Builder::cdnIdentifierSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cdnIdentifierSecret").build()}).build();
    private static final SdkField<String> SECRETS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsRoleArn").getter(Authorization.getter(Authorization::secretsRoleArn)).setter(Authorization.setter(Builder::secretsRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDN_IDENTIFIER_SECRET_FIELD, SECRETS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Authorization.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cdnIdentifierSecret;
    private final String secretsRoleArn;

    private Authorization(BuilderImpl builder) {
        this.cdnIdentifierSecret = builder.cdnIdentifierSecret;
        this.secretsRoleArn = builder.secretsRoleArn;
    }

    public final String cdnIdentifierSecret() {
        return this.cdnIdentifierSecret;
    }

    public final String secretsRoleArn() {
        return this.secretsRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cdnIdentifierSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Authorization)) {
            return false;
        }
        Authorization other = (Authorization)obj;
        return Objects.equals(this.cdnIdentifierSecret(), other.cdnIdentifierSecret()) && Objects.equals(this.secretsRoleArn(), other.secretsRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"Authorization").add("CdnIdentifierSecret", (Object)this.cdnIdentifierSecret()).add("SecretsRoleArn", (Object)this.secretsRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CdnIdentifierSecret": {
                return Optional.ofNullable(clazz.cast(this.cdnIdentifierSecret()));
            }
            case "SecretsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("cdnIdentifierSecret", CDN_IDENTIFIER_SECRET_FIELD);
        map.put("secretsRoleArn", SECRETS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Authorization, T> g) {
        return obj -> g.apply((Authorization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cdnIdentifierSecret;
        private String secretsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Authorization model) {
            this.cdnIdentifierSecret(model.cdnIdentifierSecret);
            this.secretsRoleArn(model.secretsRoleArn);
        }

        public final String getCdnIdentifierSecret() {
            return this.cdnIdentifierSecret;
        }

        public final void setCdnIdentifierSecret(String cdnIdentifierSecret) {
            this.cdnIdentifierSecret = cdnIdentifierSecret;
        }

        @Override
        public final Builder cdnIdentifierSecret(String cdnIdentifierSecret) {
            this.cdnIdentifierSecret = cdnIdentifierSecret;
            return this;
        }

        public final String getSecretsRoleArn() {
            return this.secretsRoleArn;
        }

        public final void setSecretsRoleArn(String secretsRoleArn) {
            this.secretsRoleArn = secretsRoleArn;
        }

        @Override
        public final Builder secretsRoleArn(String secretsRoleArn) {
            this.secretsRoleArn = secretsRoleArn;
            return this;
        }

        public Authorization build() {
            return new Authorization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Authorization> {
        public Builder cdnIdentifierSecret(String var1);

        public Builder secretsRoleArn(String var1);
    }
}

