/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An endpoint for ingesting source content for a Channel.
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<IngestEndpoint.Builder, IngestEndpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IngestEndpoint::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IngestEndpoint::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IngestEndpoint::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IngestEndpoint::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PASSWORD_FIELD,
            URL_FIELD, USERNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String password;

    private final String url;

    private final String username;

    private IngestEndpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.password = builder.password;
        this.url = builder.url;
        this.username = builder.username;
    }

    /**
     * The system generated unique identifier for the IngestEndpoint
     * 
     * @return The system generated unique identifier for the IngestEndpoint
     */
    public String id() {
        return id;
    }

    /**
     * The system generated password for ingest authentication.
     * 
     * @return The system generated password for ingest authentication.
     */
    public String password() {
        return password;
    }

    /**
     * The ingest URL to which the source stream should be sent.
     * 
     * @return The ingest URL to which the source stream should be sent.
     */
    public String url() {
        return url;
    }

    /**
     * The system generated username for ingest authentication.
     * 
     * @return The system generated username for ingest authentication.
     */
    public String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestEndpoint)) {
            return false;
        }
        IngestEndpoint other = (IngestEndpoint) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(password(), other.password())
                && Objects.equals(url(), other.url()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IngestEndpoint").add("Id", id()).add("Password", password()).add("Url", url())
                .add("Username", username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestEndpoint, T> g) {
        return obj -> g.apply((IngestEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestEndpoint> {
        /**
         * The system generated unique identifier for the IngestEndpoint
         * 
         * @param id
         *        The system generated unique identifier for the IngestEndpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The system generated password for ingest authentication.
         * 
         * @param password
         *        The system generated password for ingest authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * The ingest URL to which the source stream should be sent.
         * 
         * @param url
         *        The ingest URL to which the source stream should be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * The system generated username for ingest authentication.
         * 
         * @param username
         *        The system generated username for ingest authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String password;

        private String url;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestEndpoint model) {
            id(model.id);
            password(model.password);
            url(model.url);
            username(model.username);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public IngestEndpoint build() {
            return new IngestEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
