/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An HTTP Live Streaming (HLS) packaging configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsPackage implements SdkPojo, Serializable, ToCopyableBuilder<HlsPackage.Builder, HlsPackage> {
    private static final SdkField<String> AD_MARKERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsPackage::adMarkersAsString)).setter(setter(Builder::adMarkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build()).build();

    private static final SdkField<HlsEncryption> ENCRYPTION_FIELD = SdkField.<HlsEncryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(HlsPackage::encryption)).setter(setter(Builder::encryption)).constructor(HlsEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<Boolean> INCLUDE_IFRAME_ONLY_STREAM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(HlsPackage::includeIframeOnlyStream)).setter(setter(Builder::includeIframeOnlyStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeIframeOnlyStream").build())
            .build();

    private static final SdkField<String> PLAYLIST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsPackage::playlistTypeAsString)).setter(setter(Builder::playlistType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistType").build()).build();

    private static final SdkField<Integer> PLAYLIST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsPackage::playlistWindowSeconds)).setter(setter(Builder::playlistWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistWindowSeconds").build())
            .build();

    private static final SdkField<Integer> PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsPackage::programDateTimeIntervalSeconds))
            .setter(setter(Builder::programDateTimeIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimeIntervalSeconds")
                    .build()).build();

    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsPackage::segmentDurationSeconds)).setter(setter(Builder::segmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build())
            .build();

    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField
            .<StreamSelection> builder(MarshallingType.SDK_POJO).getter(getter(HlsPackage::streamSelection))
            .setter(setter(Builder::streamSelection)).constructor(StreamSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()).build();

    private static final SdkField<Boolean> USE_AUDIO_RENDITION_GROUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(HlsPackage::useAudioRenditionGroup)).setter(setter(Builder::useAudioRenditionGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useAudioRenditionGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD,
            ENCRYPTION_FIELD, INCLUDE_IFRAME_ONLY_STREAM_FIELD, PLAYLIST_TYPE_FIELD, PLAYLIST_WINDOW_SECONDS_FIELD,
            PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD, SEGMENT_DURATION_SECONDS_FIELD, STREAM_SELECTION_FIELD,
            USE_AUDIO_RENDITION_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adMarkers;

    private final HlsEncryption encryption;

    private final Boolean includeIframeOnlyStream;

    private final String playlistType;

    private final Integer playlistWindowSeconds;

    private final Integer programDateTimeIntervalSeconds;

    private final Integer segmentDurationSeconds;

    private final StreamSelection streamSelection;

    private final Boolean useAudioRenditionGroup;

    private HlsPackage(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.encryption = builder.encryption;
        this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
        this.playlistType = builder.playlistType;
        this.playlistWindowSeconds = builder.playlistWindowSeconds;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.streamSelection = builder.streamSelection;
        this.useAudioRenditionGroup = builder.useAudioRenditionGroup;
    }

    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad
     * markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments)
     * taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and
     * blackout tags based on SCTE-35 messages in the input source.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkers} will
     * return {@link AdMarkers#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkersAsString}.
     * </p>
     * 
     * @return This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
     *         SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
     *         markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
     *         generates ad markers and blackout tags based on SCTE-35 messages in the input source.
     * @see AdMarkers
     */
    public AdMarkers adMarkers() {
        return AdMarkers.fromValue(adMarkers);
    }

    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad
     * markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments)
     * taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and
     * blackout tags based on SCTE-35 messages in the input source.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkers} will
     * return {@link AdMarkers#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkersAsString}.
     * </p>
     * 
     * @return This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
     *         SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
     *         markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
     *         generates ad markers and blackout tags based on SCTE-35 messages in the input source.
     * @see AdMarkers
     */
    public String adMarkersAsString() {
        return adMarkers;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public HlsEncryption encryption() {
        return encryption;
    }

    /**
     * When enabled, an I-Frame only stream will be included in the output.
     * 
     * @return When enabled, an I-Frame only stream will be included in the output.
     */
    public Boolean includeIframeOnlyStream() {
        return includeIframeOnlyStream;
    }

    /**
     * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playlistType} will
     * return {@link PlaylistType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #playlistTypeAsString}.
     * </p>
     * 
     * @return The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     *         EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     * @see PlaylistType
     */
    public PlaylistType playlistType() {
        return PlaylistType.fromValue(playlistType);
    }

    /**
     * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playlistType} will
     * return {@link PlaylistType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #playlistTypeAsString}.
     * </p>
     * 
     * @return The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     *         EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     * @see PlaylistType
     */
    public String playlistTypeAsString() {
        return playlistType;
    }

    /**
     * Time window (in seconds) contained in each parent manifest.
     * 
     * @return Time window (in seconds) contained in each parent manifest.
     */
    public Integer playlistWindowSeconds() {
        return playlistWindowSeconds;
    }

    /**
     * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an
     * interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the
     * content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted
     * into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if
     * any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
     *
     * @return The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally,
     *         when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the
     *         ingest time of the content. If the interval is not specified, or set to 0, then no
     *         EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be
     *         generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live
     *         Streaming (HLS) input, it will be passed through to HLS output.
     */
    public Integer programDateTimeIntervalSeconds() {
        return programDateTimeIntervalSeconds;
    }

    /**
     * Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the source
     * fragment duration.
     *
     * @return Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the
     *         source fragment duration.
     */
    public Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    /**
     * Returns the value of the StreamSelection property for this object.
     * 
     * @return The value of the StreamSelection property for this object.
     */
    public StreamSelection streamSelection() {
        return streamSelection;
    }

    /**
     * When enabled, audio streams will be placed in rendition groups in the output.
     * 
     * @return When enabled, audio streams will be placed in rendition groups in the output.
     */
    public Boolean useAudioRenditionGroup() {
        return useAudioRenditionGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(includeIframeOnlyStream());
        hashCode = 31 * hashCode + Objects.hashCode(playlistTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(playlistWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimeIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(streamSelection());
        hashCode = 31 * hashCode + Objects.hashCode(useAudioRenditionGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsPackage)) {
            return false;
        }
        HlsPackage other = (HlsPackage) obj;
        return Objects.equals(adMarkersAsString(), other.adMarkersAsString()) && Objects.equals(encryption(), other.encryption())
                && Objects.equals(includeIframeOnlyStream(), other.includeIframeOnlyStream())
                && Objects.equals(playlistTypeAsString(), other.playlistTypeAsString())
                && Objects.equals(playlistWindowSeconds(), other.playlistWindowSeconds())
                && Objects.equals(programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds())
                && Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds())
                && Objects.equals(streamSelection(), other.streamSelection())
                && Objects.equals(useAudioRenditionGroup(), other.useAudioRenditionGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HlsPackage").add("AdMarkers", adMarkersAsString()).add("Encryption", encryption())
                .add("IncludeIframeOnlyStream", includeIframeOnlyStream()).add("PlaylistType", playlistTypeAsString())
                .add("PlaylistWindowSeconds", playlistWindowSeconds())
                .add("ProgramDateTimeIntervalSeconds", programDateTimeIntervalSeconds())
                .add("SegmentDurationSeconds", segmentDurationSeconds()).add("StreamSelection", streamSelection())
                .add("UseAudioRenditionGroup", useAudioRenditionGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkers":
            return Optional.ofNullable(clazz.cast(adMarkersAsString()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "IncludeIframeOnlyStream":
            return Optional.ofNullable(clazz.cast(includeIframeOnlyStream()));
        case "PlaylistType":
            return Optional.ofNullable(clazz.cast(playlistTypeAsString()));
        case "PlaylistWindowSeconds":
            return Optional.ofNullable(clazz.cast(playlistWindowSeconds()));
        case "ProgramDateTimeIntervalSeconds":
            return Optional.ofNullable(clazz.cast(programDateTimeIntervalSeconds()));
        case "SegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(segmentDurationSeconds()));
        case "StreamSelection":
            return Optional.ofNullable(clazz.cast(streamSelection()));
        case "UseAudioRenditionGroup":
            return Optional.ofNullable(clazz.cast(useAudioRenditionGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsPackage, T> g) {
        return obj -> g.apply((HlsPackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsPackage> {
        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         * SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
         * markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
         * generates ad markers and blackout tags based on SCTE-35 messages in the input source.
         *
         * @param adMarkers
         *        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         *        SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35
         *        ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
         *        "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input
         *        source.
         * @see AdMarkers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkers
         */
        Builder adMarkers(String adMarkers);

        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         * SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
         * markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
         * generates ad markers and blackout tags based on SCTE-35 messages in the input source.
         *
         * @param adMarkers
         *        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         *        SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35
         *        ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
         *        "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input
         *        source.
         * @see AdMarkers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkers
         */
        Builder adMarkers(AdMarkers adMarkers);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(HlsEncryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsEncryption.Builder} avoiding the need to
         * create one manually via {@link HlsEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(HlsEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link HlsEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(HlsEncryption)
         */
        default Builder encryption(Consumer<HlsEncryption.Builder> encryption) {
            return encryption(HlsEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * When enabled, an I-Frame only stream will be included in the output.
         * 
         * @param includeIframeOnlyStream
         *        When enabled, an I-Frame only stream will be included in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream);

        /**
         * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
         * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         *
         * @param playlistType
         *        The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a
         *        corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         * @see PlaylistType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaylistType
         */
        Builder playlistType(String playlistType);

        /**
         * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
         * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         *
         * @param playlistType
         *        The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a
         *        corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         * @see PlaylistType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaylistType
         */
        Builder playlistType(PlaylistType playlistType);

        /**
         * Time window (in seconds) contained in each parent manifest.
         * 
         * @param playlistWindowSeconds
         *        Time window (in seconds) contained in each parent manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playlistWindowSeconds(Integer playlistWindowSeconds);

        /**
         * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally,
         * when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest
         * time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will
         * be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of
         * this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed
         * through to HLS output.
         *
         * @param programDateTimeIntervalSeconds
         *        The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests.
         *        Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5
         *        seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no
         *        EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be
         *        generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live
         *        Streaming (HLS) input, it will be passed through to HLS output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds);

        /**
         * Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the
         * source fragment duration.
         *
         * @param segmentDurationSeconds
         *        Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of
         *        the source fragment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * @param streamSelection
         *        The new value for the StreamSelection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSelection(StreamSelection streamSelection);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * This is a convenience that creates an instance of the {@link StreamSelection.Builder} avoiding the need to
         * create one manually via {@link StreamSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamSelection.Builder#build()} is called immediately and its
         * result is passed to {@link #streamSelection(StreamSelection)}.
         * 
         * @param streamSelection
         *        a consumer that will call methods on {@link StreamSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSelection(StreamSelection)
         */
        default Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return streamSelection(StreamSelection.builder().applyMutation(streamSelection).build());
        }

        /**
         * When enabled, audio streams will be placed in rendition groups in the output.
         * 
         * @param useAudioRenditionGroup
         *        When enabled, audio streams will be placed in rendition groups in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useAudioRenditionGroup(Boolean useAudioRenditionGroup);
    }

    static final class BuilderImpl implements Builder {
        private String adMarkers;

        private HlsEncryption encryption;

        private Boolean includeIframeOnlyStream;

        private String playlistType;

        private Integer playlistWindowSeconds;

        private Integer programDateTimeIntervalSeconds;

        private Integer segmentDurationSeconds;

        private StreamSelection streamSelection;

        private Boolean useAudioRenditionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsPackage model) {
            adMarkers(model.adMarkers);
            encryption(model.encryption);
            includeIframeOnlyStream(model.includeIframeOnlyStream);
            playlistType(model.playlistType);
            playlistWindowSeconds(model.playlistWindowSeconds);
            programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
            segmentDurationSeconds(model.segmentDurationSeconds);
            streamSelection(model.streamSelection);
            useAudioRenditionGroup(model.useAudioRenditionGroup);
        }

        public final String getAdMarkersAsString() {
            return adMarkers;
        }

        @Override
        public final Builder adMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
            return this;
        }

        @Override
        public final Builder adMarkers(AdMarkers adMarkers) {
            this.adMarkers(adMarkers.toString());
            return this;
        }

        public final void setAdMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
        }

        public final HlsEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(HlsEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(HlsEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Boolean getIncludeIframeOnlyStream() {
            return includeIframeOnlyStream;
        }

        @Override
        public final Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
            return this;
        }

        public final void setIncludeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
        }

        public final String getPlaylistTypeAsString() {
            return playlistType;
        }

        @Override
        public final Builder playlistType(String playlistType) {
            this.playlistType = playlistType;
            return this;
        }

        @Override
        public final Builder playlistType(PlaylistType playlistType) {
            this.playlistType(playlistType.toString());
            return this;
        }

        public final void setPlaylistType(String playlistType) {
            this.playlistType = playlistType;
        }

        public final Integer getPlaylistWindowSeconds() {
            return playlistWindowSeconds;
        }

        @Override
        public final Builder playlistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
            return this;
        }

        public final void setPlaylistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return programDateTimeIntervalSeconds;
        }

        @Override
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return streamSelection != null ? streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public final Boolean getUseAudioRenditionGroup() {
            return useAudioRenditionGroup;
        }

        @Override
        public final Builder useAudioRenditionGroup(Boolean useAudioRenditionGroup) {
            this.useAudioRenditionGroup = useAudioRenditionGroup;
            return this;
        }

        public final void setUseAudioRenditionGroup(Boolean useAudioRenditionGroup) {
            this.useAudioRenditionGroup = useAudioRenditionGroup;
        }

        @Override
        public HlsPackage build() {
            return new HlsPackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
