/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackage.model.CmafPackage;
import software.amazon.awssdk.services.mediapackage.model.DashPackage;
import software.amazon.awssdk.services.mediapackage.model.HlsPackage;
import software.amazon.awssdk.services.mediapackage.model.MssPackage;
import software.amazon.awssdk.services.mediapackage.model.TagsCopier;
import software.amazon.awssdk.services.mediapackage.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginEndpoint> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OriginEndpoint.getter(OriginEndpoint::arn)).setter(OriginEndpoint.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OriginEndpoint.getter(OriginEndpoint::channelId)).setter(OriginEndpoint.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()}).build();
    private static final SdkField<CmafPackage> CMAF_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OriginEndpoint.getter(OriginEndpoint::cmafPackage)).setter(OriginEndpoint.setter(Builder::cmafPackage)).constructor(CmafPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafPackage").build()}).build();
    private static final SdkField<DashPackage> DASH_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OriginEndpoint.getter(OriginEndpoint::dashPackage)).setter(OriginEndpoint.setter(Builder::dashPackage)).constructor(DashPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashPackage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OriginEndpoint.getter(OriginEndpoint::description)).setter(OriginEndpoint.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<HlsPackage> HLS_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OriginEndpoint.getter(OriginEndpoint::hlsPackage)).setter(OriginEndpoint.setter(Builder::hlsPackage)).constructor(HlsPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsPackage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OriginEndpoint.getter(OriginEndpoint::id)).setter(OriginEndpoint.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OriginEndpoint.getter(OriginEndpoint::manifestName)).setter(OriginEndpoint.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()}).build();
    private static final SdkField<MssPackage> MSS_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OriginEndpoint.getter(OriginEndpoint::mssPackage)).setter(OriginEndpoint.setter(Builder::mssPackage)).constructor(MssPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mssPackage").build()}).build();
    private static final SdkField<Integer> STARTOVER_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OriginEndpoint.getter(OriginEndpoint::startoverWindowSeconds)).setter(OriginEndpoint.setter(Builder::startoverWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startoverWindowSeconds").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(OriginEndpoint.getter(OriginEndpoint::tags)).setter(OriginEndpoint.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> TIME_DELAY_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OriginEndpoint.getter(OriginEndpoint::timeDelaySeconds)).setter(OriginEndpoint.setter(Builder::timeDelaySeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDelaySeconds").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OriginEndpoint.getter(OriginEndpoint::url)).setter(OriginEndpoint.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<List<String>> WHITELIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OriginEndpoint.getter(OriginEndpoint::whitelist)).setter(OriginEndpoint.setter(Builder::whitelist)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelist").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_ID_FIELD, CMAF_PACKAGE_FIELD, DASH_PACKAGE_FIELD, DESCRIPTION_FIELD, HLS_PACKAGE_FIELD, ID_FIELD, MANIFEST_NAME_FIELD, MSS_PACKAGE_FIELD, STARTOVER_WINDOW_SECONDS_FIELD, TAGS_FIELD, TIME_DELAY_SECONDS_FIELD, URL_FIELD, WHITELIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String channelId;
    private final CmafPackage cmafPackage;
    private final DashPackage dashPackage;
    private final String description;
    private final HlsPackage hlsPackage;
    private final String id;
    private final String manifestName;
    private final MssPackage mssPackage;
    private final Integer startoverWindowSeconds;
    private final Map<String, String> tags;
    private final Integer timeDelaySeconds;
    private final String url;
    private final List<String> whitelist;

    private OriginEndpoint(BuilderImpl builder) {
        this.arn = builder.arn;
        this.channelId = builder.channelId;
        this.cmafPackage = builder.cmafPackage;
        this.dashPackage = builder.dashPackage;
        this.description = builder.description;
        this.hlsPackage = builder.hlsPackage;
        this.id = builder.id;
        this.manifestName = builder.manifestName;
        this.mssPackage = builder.mssPackage;
        this.startoverWindowSeconds = builder.startoverWindowSeconds;
        this.tags = builder.tags;
        this.timeDelaySeconds = builder.timeDelaySeconds;
        this.url = builder.url;
        this.whitelist = builder.whitelist;
    }

    public String arn() {
        return this.arn;
    }

    public String channelId() {
        return this.channelId;
    }

    public CmafPackage cmafPackage() {
        return this.cmafPackage;
    }

    public DashPackage dashPackage() {
        return this.dashPackage;
    }

    public String description() {
        return this.description;
    }

    public HlsPackage hlsPackage() {
        return this.hlsPackage;
    }

    public String id() {
        return this.id;
    }

    public String manifestName() {
        return this.manifestName;
    }

    public MssPackage mssPackage() {
        return this.mssPackage;
    }

    public Integer startoverWindowSeconds() {
        return this.startoverWindowSeconds;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Integer timeDelaySeconds() {
        return this.timeDelaySeconds;
    }

    public String url() {
        return this.url;
    }

    public List<String> whitelist() {
        return this.whitelist;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cmafPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mssPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.startoverWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeDelaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelist());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginEndpoint)) {
            return false;
        }
        OriginEndpoint other = (OriginEndpoint)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.cmafPackage(), other.cmafPackage()) && Objects.equals(this.dashPackage(), other.dashPackage()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.hlsPackage(), other.hlsPackage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.mssPackage(), other.mssPackage()) && Objects.equals(this.startoverWindowSeconds(), other.startoverWindowSeconds()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.timeDelaySeconds(), other.timeDelaySeconds()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.whitelist(), other.whitelist());
    }

    public String toString() {
        return ToString.builder((String)"OriginEndpoint").add("Arn", (Object)this.arn()).add("ChannelId", (Object)this.channelId()).add("CmafPackage", (Object)this.cmafPackage()).add("DashPackage", (Object)this.dashPackage()).add("Description", (Object)this.description()).add("HlsPackage", (Object)this.hlsPackage()).add("Id", (Object)this.id()).add("ManifestName", (Object)this.manifestName()).add("MssPackage", (Object)this.mssPackage()).add("StartoverWindowSeconds", (Object)this.startoverWindowSeconds()).add("Tags", this.tags()).add("TimeDelaySeconds", (Object)this.timeDelaySeconds()).add("Url", (Object)this.url()).add("Whitelist", this.whitelist()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "CmafPackage": {
                return Optional.ofNullable(clazz.cast(this.cmafPackage()));
            }
            case "DashPackage": {
                return Optional.ofNullable(clazz.cast(this.dashPackage()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HlsPackage": {
                return Optional.ofNullable(clazz.cast(this.hlsPackage()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "MssPackage": {
                return Optional.ofNullable(clazz.cast(this.mssPackage()));
            }
            case "StartoverWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.startoverWindowSeconds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TimeDelaySeconds": {
                return Optional.ofNullable(clazz.cast(this.timeDelaySeconds()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "Whitelist": {
                return Optional.ofNullable(clazz.cast(this.whitelist()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginEndpoint, T> g) {
        return obj -> g.apply((OriginEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String channelId;
        private CmafPackage cmafPackage;
        private DashPackage dashPackage;
        private String description;
        private HlsPackage hlsPackage;
        private String id;
        private String manifestName;
        private MssPackage mssPackage;
        private Integer startoverWindowSeconds;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer timeDelaySeconds;
        private String url;
        private List<String> whitelist = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OriginEndpoint model) {
            this.arn(model.arn);
            this.channelId(model.channelId);
            this.cmafPackage(model.cmafPackage);
            this.dashPackage(model.dashPackage);
            this.description(model.description);
            this.hlsPackage(model.hlsPackage);
            this.id(model.id);
            this.manifestName(model.manifestName);
            this.mssPackage(model.mssPackage);
            this.startoverWindowSeconds(model.startoverWindowSeconds);
            this.tags(model.tags);
            this.timeDelaySeconds(model.timeDelaySeconds);
            this.url(model.url);
            this.whitelist(model.whitelist);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public final CmafPackage.Builder getCmafPackage() {
            return this.cmafPackage != null ? this.cmafPackage.toBuilder() : null;
        }

        @Override
        public final Builder cmafPackage(CmafPackage cmafPackage) {
            this.cmafPackage = cmafPackage;
            return this;
        }

        public final void setCmafPackage(CmafPackage.BuilderImpl cmafPackage) {
            this.cmafPackage = cmafPackage != null ? cmafPackage.build() : null;
        }

        public final DashPackage.Builder getDashPackage() {
            return this.dashPackage != null ? this.dashPackage.toBuilder() : null;
        }

        @Override
        public final Builder dashPackage(DashPackage dashPackage) {
            this.dashPackage = dashPackage;
            return this;
        }

        public final void setDashPackage(DashPackage.BuilderImpl dashPackage) {
            this.dashPackage = dashPackage != null ? dashPackage.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final HlsPackage.Builder getHlsPackage() {
            return this.hlsPackage != null ? this.hlsPackage.toBuilder() : null;
        }

        @Override
        public final Builder hlsPackage(HlsPackage hlsPackage) {
            this.hlsPackage = hlsPackage;
            return this;
        }

        public final void setHlsPackage(HlsPackage.BuilderImpl hlsPackage) {
            this.hlsPackage = hlsPackage != null ? hlsPackage.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        public final MssPackage.Builder getMssPackage() {
            return this.mssPackage != null ? this.mssPackage.toBuilder() : null;
        }

        @Override
        public final Builder mssPackage(MssPackage mssPackage) {
            this.mssPackage = mssPackage;
            return this;
        }

        public final void setMssPackage(MssPackage.BuilderImpl mssPackage) {
            this.mssPackage = mssPackage != null ? mssPackage.build() : null;
        }

        public final Integer getStartoverWindowSeconds() {
            return this.startoverWindowSeconds;
        }

        @Override
        public final Builder startoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
            return this;
        }

        public final void setStartoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Integer getTimeDelaySeconds() {
            return this.timeDelaySeconds;
        }

        @Override
        public final Builder timeDelaySeconds(Integer timeDelaySeconds) {
            this.timeDelaySeconds = timeDelaySeconds;
            return this;
        }

        public final void setTimeDelaySeconds(Integer timeDelaySeconds) {
            this.timeDelaySeconds = timeDelaySeconds;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final Collection<String> getWhitelist() {
            return this.whitelist;
        }

        @Override
        public final Builder whitelist(Collection<String> whitelist) {
            this.whitelist = ___listOf__stringCopier.copy(whitelist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelist(String ... whitelist) {
            this.whitelist(Arrays.asList(whitelist));
            return this;
        }

        public final void setWhitelist(Collection<String> whitelist) {
            this.whitelist = ___listOf__stringCopier.copy(whitelist);
        }

        public OriginEndpoint build() {
            return new OriginEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginEndpoint> {
        public Builder arn(String var1);

        public Builder channelId(String var1);

        public Builder cmafPackage(CmafPackage var1);

        default public Builder cmafPackage(Consumer<CmafPackage.Builder> cmafPackage) {
            return this.cmafPackage((CmafPackage)((CmafPackage.Builder)CmafPackage.builder().applyMutation(cmafPackage)).build());
        }

        public Builder dashPackage(DashPackage var1);

        default public Builder dashPackage(Consumer<DashPackage.Builder> dashPackage) {
            return this.dashPackage((DashPackage)((DashPackage.Builder)DashPackage.builder().applyMutation(dashPackage)).build());
        }

        public Builder description(String var1);

        public Builder hlsPackage(HlsPackage var1);

        default public Builder hlsPackage(Consumer<HlsPackage.Builder> hlsPackage) {
            return this.hlsPackage((HlsPackage)((HlsPackage.Builder)HlsPackage.builder().applyMutation(hlsPackage)).build());
        }

        public Builder id(String var1);

        public Builder manifestName(String var1);

        public Builder mssPackage(MssPackage var1);

        default public Builder mssPackage(Consumer<MssPackage.Builder> mssPackage) {
            return this.mssPackage((MssPackage)((MssPackage.Builder)MssPackage.builder().applyMutation(mssPackage)).build());
        }

        public Builder startoverWindowSeconds(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder timeDelaySeconds(Integer var1);

        public Builder url(String var1);

        public Builder whitelist(Collection<String> var1);

        public Builder whitelist(String ... var1);
    }
}

