/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configuration parameters used to update an existing OriginEndpoint.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOriginEndpointRequest extends MediaPackageRequest implements
        ToCopyableBuilder<UpdateOriginEndpointRequest.Builder, UpdateOriginEndpointRequest> {
    private static final SdkField<CmafPackageCreateOrUpdateParameters> CMAF_PACKAGE_FIELD = SdkField
            .<CmafPackageCreateOrUpdateParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateOriginEndpointRequest::cmafPackage)).setter(setter(Builder::cmafPackage))
            .constructor(CmafPackageCreateOrUpdateParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafPackage").build()).build();

    private static final SdkField<DashPackage> DASH_PACKAGE_FIELD = SdkField.<DashPackage> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateOriginEndpointRequest::dashPackage)).setter(setter(Builder::dashPackage))
            .constructor(DashPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashPackage").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateOriginEndpointRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<HlsPackage> HLS_PACKAGE_FIELD = SdkField.<HlsPackage> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateOriginEndpointRequest::hlsPackage)).setter(setter(Builder::hlsPackage))
            .constructor(HlsPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsPackage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateOriginEndpointRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateOriginEndpointRequest::manifestName)).setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()).build();

    private static final SdkField<MssPackage> MSS_PACKAGE_FIELD = SdkField.<MssPackage> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateOriginEndpointRequest::mssPackage)).setter(setter(Builder::mssPackage))
            .constructor(MssPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mssPackage").build()).build();

    private static final SdkField<Integer> STARTOVER_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateOriginEndpointRequest::startoverWindowSeconds)).setter(setter(Builder::startoverWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startoverWindowSeconds").build())
            .build();

    private static final SdkField<Integer> TIME_DELAY_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateOriginEndpointRequest::timeDelaySeconds)).setter(setter(Builder::timeDelaySeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDelaySeconds").build()).build();

    private static final SdkField<List<String>> WHITELIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateOriginEndpointRequest::whitelist))
            .setter(setter(Builder::whitelist))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelist").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CMAF_PACKAGE_FIELD,
            DASH_PACKAGE_FIELD, DESCRIPTION_FIELD, HLS_PACKAGE_FIELD, ID_FIELD, MANIFEST_NAME_FIELD, MSS_PACKAGE_FIELD,
            STARTOVER_WINDOW_SECONDS_FIELD, TIME_DELAY_SECONDS_FIELD, WHITELIST_FIELD));

    private final CmafPackageCreateOrUpdateParameters cmafPackage;

    private final DashPackage dashPackage;

    private final String description;

    private final HlsPackage hlsPackage;

    private final String id;

    private final String manifestName;

    private final MssPackage mssPackage;

    private final Integer startoverWindowSeconds;

    private final Integer timeDelaySeconds;

    private final List<String> whitelist;

    private UpdateOriginEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.cmafPackage = builder.cmafPackage;
        this.dashPackage = builder.dashPackage;
        this.description = builder.description;
        this.hlsPackage = builder.hlsPackage;
        this.id = builder.id;
        this.manifestName = builder.manifestName;
        this.mssPackage = builder.mssPackage;
        this.startoverWindowSeconds = builder.startoverWindowSeconds;
        this.timeDelaySeconds = builder.timeDelaySeconds;
        this.whitelist = builder.whitelist;
    }

    /**
     * Returns the value of the CmafPackage property for this object.
     * 
     * @return The value of the CmafPackage property for this object.
     */
    public CmafPackageCreateOrUpdateParameters cmafPackage() {
        return cmafPackage;
    }

    /**
     * Returns the value of the DashPackage property for this object.
     * 
     * @return The value of the DashPackage property for this object.
     */
    public DashPackage dashPackage() {
        return dashPackage;
    }

    /**
     * A short text description of the OriginEndpoint.
     * 
     * @return A short text description of the OriginEndpoint.
     */
    public String description() {
        return description;
    }

    /**
     * Returns the value of the HlsPackage property for this object.
     * 
     * @return The value of the HlsPackage property for this object.
     */
    public HlsPackage hlsPackage() {
        return hlsPackage;
    }

    /**
     * The ID of the OriginEndpoint to update.
     * 
     * @return The ID of the OriginEndpoint to update.
     */
    public String id() {
        return id;
    }

    /**
     * A short string that will be appended to the end of the Endpoint URL.
     * 
     * @return A short string that will be appended to the end of the Endpoint URL.
     */
    public String manifestName() {
        return manifestName;
    }

    /**
     * Returns the value of the MssPackage property for this object.
     * 
     * @return The value of the MssPackage property for this object.
     */
    public MssPackage mssPackage() {
        return mssPackage;
    }

    /**
     * Maximum duration (in seconds) of content to retain for startover playback. If not specified, startover playback
     * will be disabled for the OriginEndpoint.
     *
     * @return Maximum duration (in seconds) of content to retain for startover playback. If not specified, startover
     *         playback will be disabled for the OriginEndpoint.
     */
    public Integer startoverWindowSeconds() {
        return startoverWindowSeconds;
    }

    /**
     * Amount of delay (in seconds) to enforce on the playback of live content. If not specified, there will be no time
     * delay in effect for the OriginEndpoint.
     *
     * @return Amount of delay (in seconds) to enforce on the playback of live content. If not specified, there will be
     *         no time delay in effect for the OriginEndpoint.
     */
    public Integer timeDelaySeconds() {
        return timeDelaySeconds;
    }

    /**
     * A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
     */
    public List<String> whitelist() {
        return whitelist;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cmafPackage());
        hashCode = 31 * hashCode + Objects.hashCode(dashPackage());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hlsPackage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(mssPackage());
        hashCode = 31 * hashCode + Objects.hashCode(startoverWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(timeDelaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(whitelist());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOriginEndpointRequest)) {
            return false;
        }
        UpdateOriginEndpointRequest other = (UpdateOriginEndpointRequest) obj;
        return Objects.equals(cmafPackage(), other.cmafPackage()) && Objects.equals(dashPackage(), other.dashPackage())
                && Objects.equals(description(), other.description()) && Objects.equals(hlsPackage(), other.hlsPackage())
                && Objects.equals(id(), other.id()) && Objects.equals(manifestName(), other.manifestName())
                && Objects.equals(mssPackage(), other.mssPackage())
                && Objects.equals(startoverWindowSeconds(), other.startoverWindowSeconds())
                && Objects.equals(timeDelaySeconds(), other.timeDelaySeconds()) && Objects.equals(whitelist(), other.whitelist());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateOriginEndpointRequest").add("CmafPackage", cmafPackage())
                .add("DashPackage", dashPackage()).add("Description", description()).add("HlsPackage", hlsPackage())
                .add("Id", id()).add("ManifestName", manifestName()).add("MssPackage", mssPackage())
                .add("StartoverWindowSeconds", startoverWindowSeconds()).add("TimeDelaySeconds", timeDelaySeconds())
                .add("Whitelist", whitelist()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CmafPackage":
            return Optional.ofNullable(clazz.cast(cmafPackage()));
        case "DashPackage":
            return Optional.ofNullable(clazz.cast(dashPackage()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HlsPackage":
            return Optional.ofNullable(clazz.cast(hlsPackage()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "MssPackage":
            return Optional.ofNullable(clazz.cast(mssPackage()));
        case "StartoverWindowSeconds":
            return Optional.ofNullable(clazz.cast(startoverWindowSeconds()));
        case "TimeDelaySeconds":
            return Optional.ofNullable(clazz.cast(timeDelaySeconds()));
        case "Whitelist":
            return Optional.ofNullable(clazz.cast(whitelist()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOriginEndpointRequest, T> g) {
        return obj -> g.apply((UpdateOriginEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateOriginEndpointRequest> {
        /**
         * Sets the value of the CmafPackage property for this object.
         *
         * @param cmafPackage
         *        The new value for the CmafPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cmafPackage(CmafPackageCreateOrUpdateParameters cmafPackage);

        /**
         * Sets the value of the CmafPackage property for this object.
         *
         * This is a convenience that creates an instance of the {@link CmafPackageCreateOrUpdateParameters.Builder}
         * avoiding the need to create one manually via {@link CmafPackageCreateOrUpdateParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link CmafPackageCreateOrUpdateParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #cmafPackage(CmafPackageCreateOrUpdateParameters)}.
         * 
         * @param cmafPackage
         *        a consumer that will call methods on {@link CmafPackageCreateOrUpdateParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cmafPackage(CmafPackageCreateOrUpdateParameters)
         */
        default Builder cmafPackage(Consumer<CmafPackageCreateOrUpdateParameters.Builder> cmafPackage) {
            return cmafPackage(CmafPackageCreateOrUpdateParameters.builder().applyMutation(cmafPackage).build());
        }

        /**
         * Sets the value of the DashPackage property for this object.
         *
         * @param dashPackage
         *        The new value for the DashPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashPackage(DashPackage dashPackage);

        /**
         * Sets the value of the DashPackage property for this object.
         *
         * This is a convenience that creates an instance of the {@link DashPackage.Builder} avoiding the need to create
         * one manually via {@link DashPackage#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #dashPackage(DashPackage)}.
         * 
         * @param dashPackage
         *        a consumer that will call methods on {@link DashPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashPackage(DashPackage)
         */
        default Builder dashPackage(Consumer<DashPackage.Builder> dashPackage) {
            return dashPackage(DashPackage.builder().applyMutation(dashPackage).build());
        }

        /**
         * A short text description of the OriginEndpoint.
         * 
         * @param description
         *        A short text description of the OriginEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the HlsPackage property for this object.
         *
         * @param hlsPackage
         *        The new value for the HlsPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsPackage(HlsPackage hlsPackage);

        /**
         * Sets the value of the HlsPackage property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsPackage.Builder} avoiding the need to create
         * one manually via {@link HlsPackage#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #hlsPackage(HlsPackage)}.
         * 
         * @param hlsPackage
         *        a consumer that will call methods on {@link HlsPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsPackage(HlsPackage)
         */
        default Builder hlsPackage(Consumer<HlsPackage.Builder> hlsPackage) {
            return hlsPackage(HlsPackage.builder().applyMutation(hlsPackage).build());
        }

        /**
         * The ID of the OriginEndpoint to update.
         * 
         * @param id
         *        The ID of the OriginEndpoint to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * A short string that will be appended to the end of the Endpoint URL.
         * 
         * @param manifestName
         *        A short string that will be appended to the end of the Endpoint URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * Sets the value of the MssPackage property for this object.
         *
         * @param mssPackage
         *        The new value for the MssPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mssPackage(MssPackage mssPackage);

        /**
         * Sets the value of the MssPackage property for this object.
         *
         * This is a convenience that creates an instance of the {@link MssPackage.Builder} avoiding the need to create
         * one manually via {@link MssPackage#builder()}.
         *
         * When the {@link Consumer} completes, {@link MssPackage.Builder#build()} is called immediately and its result
         * is passed to {@link #mssPackage(MssPackage)}.
         * 
         * @param mssPackage
         *        a consumer that will call methods on {@link MssPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mssPackage(MssPackage)
         */
        default Builder mssPackage(Consumer<MssPackage.Builder> mssPackage) {
            return mssPackage(MssPackage.builder().applyMutation(mssPackage).build());
        }

        /**
         * Maximum duration (in seconds) of content to retain for startover playback. If not specified, startover
         * playback will be disabled for the OriginEndpoint.
         *
         * @param startoverWindowSeconds
         *        Maximum duration (in seconds) of content to retain for startover playback. If not specified, startover
         *        playback will be disabled for the OriginEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startoverWindowSeconds(Integer startoverWindowSeconds);

        /**
         * Amount of delay (in seconds) to enforce on the playback of live content. If not specified, there will be no
         * time delay in effect for the OriginEndpoint.
         *
         * @param timeDelaySeconds
         *        Amount of delay (in seconds) to enforce on the playback of live content. If not specified, there will
         *        be no time delay in effect for the OriginEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeDelaySeconds(Integer timeDelaySeconds);

        /**
         * A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
         * 
         * @param whitelist
         *        A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelist(Collection<String> whitelist);

        /**
         * A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
         * 
         * @param whitelist
         *        A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelist(String... whitelist);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageRequest.BuilderImpl implements Builder {
        private CmafPackageCreateOrUpdateParameters cmafPackage;

        private DashPackage dashPackage;

        private String description;

        private HlsPackage hlsPackage;

        private String id;

        private String manifestName;

        private MssPackage mssPackage;

        private Integer startoverWindowSeconds;

        private Integer timeDelaySeconds;

        private List<String> whitelist = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOriginEndpointRequest model) {
            super(model);
            cmafPackage(model.cmafPackage);
            dashPackage(model.dashPackage);
            description(model.description);
            hlsPackage(model.hlsPackage);
            id(model.id);
            manifestName(model.manifestName);
            mssPackage(model.mssPackage);
            startoverWindowSeconds(model.startoverWindowSeconds);
            timeDelaySeconds(model.timeDelaySeconds);
            whitelist(model.whitelist);
        }

        public final CmafPackageCreateOrUpdateParameters.Builder getCmafPackage() {
            return cmafPackage != null ? cmafPackage.toBuilder() : null;
        }

        @Override
        public final Builder cmafPackage(CmafPackageCreateOrUpdateParameters cmafPackage) {
            this.cmafPackage = cmafPackage;
            return this;
        }

        public final void setCmafPackage(CmafPackageCreateOrUpdateParameters.BuilderImpl cmafPackage) {
            this.cmafPackage = cmafPackage != null ? cmafPackage.build() : null;
        }

        public final DashPackage.Builder getDashPackage() {
            return dashPackage != null ? dashPackage.toBuilder() : null;
        }

        @Override
        public final Builder dashPackage(DashPackage dashPackage) {
            this.dashPackage = dashPackage;
            return this;
        }

        public final void setDashPackage(DashPackage.BuilderImpl dashPackage) {
            this.dashPackage = dashPackage != null ? dashPackage.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final HlsPackage.Builder getHlsPackage() {
            return hlsPackage != null ? hlsPackage.toBuilder() : null;
        }

        @Override
        public final Builder hlsPackage(HlsPackage hlsPackage) {
            this.hlsPackage = hlsPackage;
            return this;
        }

        public final void setHlsPackage(HlsPackage.BuilderImpl hlsPackage) {
            this.hlsPackage = hlsPackage != null ? hlsPackage.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getManifestName() {
            return manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        public final MssPackage.Builder getMssPackage() {
            return mssPackage != null ? mssPackage.toBuilder() : null;
        }

        @Override
        public final Builder mssPackage(MssPackage mssPackage) {
            this.mssPackage = mssPackage;
            return this;
        }

        public final void setMssPackage(MssPackage.BuilderImpl mssPackage) {
            this.mssPackage = mssPackage != null ? mssPackage.build() : null;
        }

        public final Integer getStartoverWindowSeconds() {
            return startoverWindowSeconds;
        }

        @Override
        public final Builder startoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
            return this;
        }

        public final void setStartoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
        }

        public final Integer getTimeDelaySeconds() {
            return timeDelaySeconds;
        }

        @Override
        public final Builder timeDelaySeconds(Integer timeDelaySeconds) {
            this.timeDelaySeconds = timeDelaySeconds;
            return this;
        }

        public final void setTimeDelaySeconds(Integer timeDelaySeconds) {
            this.timeDelaySeconds = timeDelaySeconds;
        }

        public final Collection<String> getWhitelist() {
            return whitelist;
        }

        @Override
        public final Builder whitelist(Collection<String> whitelist) {
            this.whitelist = ___listOf__stringCopier.copy(whitelist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelist(String... whitelist) {
            whitelist(Arrays.asList(whitelist));
            return this;
        }

        public final void setWhitelist(Collection<String> whitelist) {
            this.whitelist = ___listOf__stringCopier.copy(whitelist);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOriginEndpointRequest build() {
            return new UpdateOriginEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
