/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A HTTP Live Streaming (HLS) manifest configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsManifest implements SdkPojo, Serializable, ToCopyableBuilder<HlsManifest.Builder, HlsManifest> {
    private static final SdkField<String> AD_MARKERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsManifest::adMarkersAsString)).setter(setter(Builder::adMarkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsManifest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Boolean> INCLUDE_IFRAME_ONLY_STREAM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(HlsManifest::includeIframeOnlyStream)).setter(setter(Builder::includeIframeOnlyStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeIframeOnlyStream").build())
            .build();

    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsManifest::manifestName)).setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()).build();

    private static final SdkField<String> PLAYLIST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsManifest::playlistTypeAsString)).setter(setter(Builder::playlistType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistType").build()).build();

    private static final SdkField<Integer> PLAYLIST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsManifest::playlistWindowSeconds)).setter(setter(Builder::playlistWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistWindowSeconds").build())
            .build();

    private static final SdkField<Integer> PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsManifest::programDateTimeIntervalSeconds))
            .setter(setter(Builder::programDateTimeIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimeIntervalSeconds")
                    .build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsManifest::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD, ID_FIELD,
            INCLUDE_IFRAME_ONLY_STREAM_FIELD, MANIFEST_NAME_FIELD, PLAYLIST_TYPE_FIELD, PLAYLIST_WINDOW_SECONDS_FIELD,
            PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adMarkers;

    private final String id;

    private final Boolean includeIframeOnlyStream;

    private final String manifestName;

    private final String playlistType;

    private final Integer playlistWindowSeconds;

    private final Integer programDateTimeIntervalSeconds;

    private final String url;

    private HlsManifest(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.id = builder.id;
        this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
        this.manifestName = builder.manifestName;
        this.playlistType = builder.playlistType;
        this.playlistWindowSeconds = builder.playlistWindowSeconds;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
        this.url = builder.url;
    }

    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad
     * markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments)
     * taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and
     * blackout tags based on SCTE-35 messages in the input source.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkers} will
     * return {@link AdMarkers#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkersAsString}.
     * </p>
     * 
     * @return This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
     *         SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
     *         markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
     *         generates ad markers and blackout tags based on SCTE-35 messages in the input source.
     * @see AdMarkers
     */
    public AdMarkers adMarkers() {
        return AdMarkers.fromValue(adMarkers);
    }

    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad
     * markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments)
     * taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and
     * blackout tags based on SCTE-35 messages in the input source.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adMarkers} will
     * return {@link AdMarkers#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adMarkersAsString}.
     * </p>
     * 
     * @return This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
     *         SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
     *         markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
     *         generates ad markers and blackout tags based on SCTE-35 messages in the input source.
     * @see AdMarkers
     */
    public String adMarkersAsString() {
        return adMarkers;
    }

    /**
     * The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is
     * created.
     * 
     * @return The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it
     *         is created.
     */
    public String id() {
        return id;
    }

    /**
     * When enabled, an I-Frame only stream will be included in the output.
     * 
     * @return When enabled, an I-Frame only stream will be included in the output.
     */
    public Boolean includeIframeOnlyStream() {
        return includeIframeOnlyStream;
    }

    /**
     * An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the
     * manifestName for the OriginEndpoint.
     * 
     * @return An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the
     *         manifestName for the OriginEndpoint.
     */
    public String manifestName() {
        return manifestName;
    }

    /**
     * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playlistType} will
     * return {@link PlaylistType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #playlistTypeAsString}.
     * </p>
     * 
     * @return The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     *         EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     * @see PlaylistType
     */
    public PlaylistType playlistType() {
        return PlaylistType.fromValue(playlistType);
    }

    /**
     * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playlistType} will
     * return {@link PlaylistType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #playlistTypeAsString}.
     * </p>
     * 
     * @return The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
     *         EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     * @see PlaylistType
     */
    public String playlistTypeAsString() {
        return playlistType;
    }

    /**
     * Time window (in seconds) contained in each parent manifest.
     * 
     * @return Time window (in seconds) contained in each parent manifest.
     */
    public Integer playlistWindowSeconds() {
        return playlistWindowSeconds;
    }

    /**
     * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an
     * interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the
     * content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted
     * into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if
     * any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
     *
     * @return The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally,
     *         when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the
     *         ingest time of the content. If the interval is not specified, or set to 0, then no
     *         EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be
     *         generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live
     *         Streaming (HLS) input, it will be passed through to HLS output.
     */
    public Integer programDateTimeIntervalSeconds() {
        return programDateTimeIntervalSeconds;
    }

    /**
     * The URL of the packaged OriginEndpoint for consumption.
     * 
     * @return The URL of the packaged OriginEndpoint for consumption.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(includeIframeOnlyStream());
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(playlistTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(playlistWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimeIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsManifest)) {
            return false;
        }
        HlsManifest other = (HlsManifest) obj;
        return Objects.equals(adMarkersAsString(), other.adMarkersAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(includeIframeOnlyStream(), other.includeIframeOnlyStream())
                && Objects.equals(manifestName(), other.manifestName())
                && Objects.equals(playlistTypeAsString(), other.playlistTypeAsString())
                && Objects.equals(playlistWindowSeconds(), other.playlistWindowSeconds())
                && Objects.equals(programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HlsManifest").add("AdMarkers", adMarkersAsString()).add("Id", id())
                .add("IncludeIframeOnlyStream", includeIframeOnlyStream()).add("ManifestName", manifestName())
                .add("PlaylistType", playlistTypeAsString()).add("PlaylistWindowSeconds", playlistWindowSeconds())
                .add("ProgramDateTimeIntervalSeconds", programDateTimeIntervalSeconds()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkers":
            return Optional.ofNullable(clazz.cast(adMarkersAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IncludeIframeOnlyStream":
            return Optional.ofNullable(clazz.cast(includeIframeOnlyStream()));
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "PlaylistType":
            return Optional.ofNullable(clazz.cast(playlistTypeAsString()));
        case "PlaylistWindowSeconds":
            return Optional.ofNullable(clazz.cast(playlistWindowSeconds()));
        case "ProgramDateTimeIntervalSeconds":
            return Optional.ofNullable(clazz.cast(programDateTimeIntervalSeconds()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsManifest, T> g) {
        return obj -> g.apply((HlsManifest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsManifest> {
        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         * SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
         * markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
         * generates ad markers and blackout tags based on SCTE-35 messages in the input source.
         *
         * @param adMarkers
         *        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         *        SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35
         *        ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
         *        "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input
         *        source.
         * @see AdMarkers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkers
         */
        Builder adMarkers(String adMarkers);

        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         * SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad
         * markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED"
         * generates ad markers and blackout tags based on SCTE-35 messages in the input source.
         *
         * @param adMarkers
         *        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all
         *        SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35
         *        ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest.
         *        "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input
         *        source.
         * @see AdMarkers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdMarkers
         */
        Builder adMarkers(AdMarkers adMarkers);

        /**
         * The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is
         * created.
         * 
         * @param id
         *        The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after
         *        it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * When enabled, an I-Frame only stream will be included in the output.
         * 
         * @param includeIframeOnlyStream
         *        When enabled, an I-Frame only stream will be included in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream);

        /**
         * An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the
         * manifestName for the OriginEndpoint.
         * 
         * @param manifestName
         *        An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to
         *        the manifestName for the OriginEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
         * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         *
         * @param playlistType
         *        The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a
         *        corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         * @see PlaylistType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaylistType
         */
        Builder playlistType(String playlistType);

        /**
         * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding
         * EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         *
         * @param playlistType
         *        The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a
         *        corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         * @see PlaylistType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaylistType
         */
        Builder playlistType(PlaylistType playlistType);

        /**
         * Time window (in seconds) contained in each parent manifest.
         * 
         * @param playlistWindowSeconds
         *        Time window (in seconds) contained in each parent manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playlistWindowSeconds(Integer playlistWindowSeconds);

        /**
         * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally,
         * when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest
         * time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will
         * be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of
         * this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed
         * through to HLS output.
         *
         * @param programDateTimeIntervalSeconds
         *        The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests.
         *        Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5
         *        seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no
         *        EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be
         *        generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live
         *        Streaming (HLS) input, it will be passed through to HLS output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds);

        /**
         * The URL of the packaged OriginEndpoint for consumption.
         * 
         * @param url
         *        The URL of the packaged OriginEndpoint for consumption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String adMarkers;

        private String id;

        private Boolean includeIframeOnlyStream;

        private String manifestName;

        private String playlistType;

        private Integer playlistWindowSeconds;

        private Integer programDateTimeIntervalSeconds;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsManifest model) {
            adMarkers(model.adMarkers);
            id(model.id);
            includeIframeOnlyStream(model.includeIframeOnlyStream);
            manifestName(model.manifestName);
            playlistType(model.playlistType);
            playlistWindowSeconds(model.playlistWindowSeconds);
            programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
            url(model.url);
        }

        public final String getAdMarkersAsString() {
            return adMarkers;
        }

        @Override
        public final Builder adMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
            return this;
        }

        @Override
        public final Builder adMarkers(AdMarkers adMarkers) {
            this.adMarkers(adMarkers.toString());
            return this;
        }

        public final void setAdMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIncludeIframeOnlyStream() {
            return includeIframeOnlyStream;
        }

        @Override
        public final Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
            return this;
        }

        public final void setIncludeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
        }

        public final String getManifestName() {
            return manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        public final String getPlaylistTypeAsString() {
            return playlistType;
        }

        @Override
        public final Builder playlistType(String playlistType) {
            this.playlistType = playlistType;
            return this;
        }

        @Override
        public final Builder playlistType(PlaylistType playlistType) {
            this.playlistType(playlistType.toString());
            return this;
        }

        public final void setPlaylistType(String playlistType) {
            this.playlistType = playlistType;
        }

        public final Integer getPlaylistWindowSeconds() {
            return playlistWindowSeconds;
        }

        @Override
        public final Builder playlistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
            return this;
        }

        public final void setPlaylistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return programDateTimeIntervalSeconds;
        }

        @Override
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public HlsManifest build() {
            return new HlsManifest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
