/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackage.model.StreamOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamSelection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamSelection> {
    private static final SdkField<Integer> MAX_VIDEO_BITS_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StreamSelection.getter(StreamSelection::maxVideoBitsPerSecond)).setter(StreamSelection.setter(Builder::maxVideoBitsPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxVideoBitsPerSecond").build()}).build();
    private static final SdkField<Integer> MIN_VIDEO_BITS_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StreamSelection.getter(StreamSelection::minVideoBitsPerSecond)).setter(StreamSelection.setter(Builder::minVideoBitsPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minVideoBitsPerSecond").build()}).build();
    private static final SdkField<String> STREAM_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StreamSelection.getter(StreamSelection::streamOrderAsString)).setter(StreamSelection.setter(Builder::streamOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_VIDEO_BITS_PER_SECOND_FIELD, MIN_VIDEO_BITS_PER_SECOND_FIELD, STREAM_ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxVideoBitsPerSecond;
    private final Integer minVideoBitsPerSecond;
    private final String streamOrder;

    private StreamSelection(BuilderImpl builder) {
        this.maxVideoBitsPerSecond = builder.maxVideoBitsPerSecond;
        this.minVideoBitsPerSecond = builder.minVideoBitsPerSecond;
        this.streamOrder = builder.streamOrder;
    }

    public Integer maxVideoBitsPerSecond() {
        return this.maxVideoBitsPerSecond;
    }

    public Integer minVideoBitsPerSecond() {
        return this.minVideoBitsPerSecond;
    }

    public StreamOrder streamOrder() {
        return StreamOrder.fromValue(this.streamOrder);
    }

    public String streamOrderAsString() {
        return this.streamOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxVideoBitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.minVideoBitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamOrderAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSelection)) {
            return false;
        }
        StreamSelection other = (StreamSelection)obj;
        return Objects.equals(this.maxVideoBitsPerSecond(), other.maxVideoBitsPerSecond()) && Objects.equals(this.minVideoBitsPerSecond(), other.minVideoBitsPerSecond()) && Objects.equals(this.streamOrderAsString(), other.streamOrderAsString());
    }

    public String toString() {
        return ToString.builder((String)"StreamSelection").add("MaxVideoBitsPerSecond", (Object)this.maxVideoBitsPerSecond()).add("MinVideoBitsPerSecond", (Object)this.minVideoBitsPerSecond()).add("StreamOrder", (Object)this.streamOrderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxVideoBitsPerSecond": {
                return Optional.ofNullable(clazz.cast(this.maxVideoBitsPerSecond()));
            }
            case "MinVideoBitsPerSecond": {
                return Optional.ofNullable(clazz.cast(this.minVideoBitsPerSecond()));
            }
            case "StreamOrder": {
                return Optional.ofNullable(clazz.cast(this.streamOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamSelection, T> g) {
        return obj -> g.apply((StreamSelection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxVideoBitsPerSecond;
        private Integer minVideoBitsPerSecond;
        private String streamOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSelection model) {
            this.maxVideoBitsPerSecond(model.maxVideoBitsPerSecond);
            this.minVideoBitsPerSecond(model.minVideoBitsPerSecond);
            this.streamOrder(model.streamOrder);
        }

        public final Integer getMaxVideoBitsPerSecond() {
            return this.maxVideoBitsPerSecond;
        }

        @Override
        public final Builder maxVideoBitsPerSecond(Integer maxVideoBitsPerSecond) {
            this.maxVideoBitsPerSecond = maxVideoBitsPerSecond;
            return this;
        }

        public final void setMaxVideoBitsPerSecond(Integer maxVideoBitsPerSecond) {
            this.maxVideoBitsPerSecond = maxVideoBitsPerSecond;
        }

        public final Integer getMinVideoBitsPerSecond() {
            return this.minVideoBitsPerSecond;
        }

        @Override
        public final Builder minVideoBitsPerSecond(Integer minVideoBitsPerSecond) {
            this.minVideoBitsPerSecond = minVideoBitsPerSecond;
            return this;
        }

        public final void setMinVideoBitsPerSecond(Integer minVideoBitsPerSecond) {
            this.minVideoBitsPerSecond = minVideoBitsPerSecond;
        }

        public final String getStreamOrderAsString() {
            return this.streamOrder;
        }

        @Override
        public final Builder streamOrder(String streamOrder) {
            this.streamOrder = streamOrder;
            return this;
        }

        @Override
        public final Builder streamOrder(StreamOrder streamOrder) {
            this.streamOrder(streamOrder.toString());
            return this;
        }

        public final void setStreamOrder(String streamOrder) {
            this.streamOrder = streamOrder;
        }

        public StreamSelection build() {
            return new StreamSelection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamSelection> {
        public Builder maxVideoBitsPerSecond(Integer var1);

        public Builder minVideoBitsPerSecond(Integer var1);

        public Builder streamOrder(String var1);

        public Builder streamOrder(StreamOrder var1);
    }
}

