/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A HarvestJob resource configuration
 */
@Generated("software.amazon.awssdk:codegen")
public final class HarvestJob implements SdkPojo, Serializable, ToCopyableBuilder<HarvestJob.Builder, HarvestJob> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HarvestJob::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HarvestJob::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HarvestJob::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HarvestJob::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HarvestJob::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HarvestJob::originEndpointId)).setter(setter(Builder::originEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originEndpointId").build()).build();

    private static final SdkField<S3Destination> S3_DESTINATION_FIELD = SdkField
            .<S3Destination> builder(MarshallingType.SDK_POJO).getter(getter(HarvestJob::s3Destination))
            .setter(setter(Builder::s3Destination)).constructor(S3Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HarvestJob::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HarvestJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_ID_FIELD,
            CREATED_AT_FIELD, END_TIME_FIELD, ID_FIELD, ORIGIN_ENDPOINT_ID_FIELD, S3_DESTINATION_FIELD, START_TIME_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String channelId;

    private final String createdAt;

    private final String endTime;

    private final String id;

    private final String originEndpointId;

    private final S3Destination s3Destination;

    private final String startTime;

    private final String status;

    private HarvestJob(BuilderImpl builder) {
        this.arn = builder.arn;
        this.channelId = builder.channelId;
        this.createdAt = builder.createdAt;
        this.endTime = builder.endTime;
        this.id = builder.id;
        this.originEndpointId = builder.originEndpointId;
        this.s3Destination = builder.s3Destination;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * The Amazon Resource Name (ARN) assigned to the HarvestJob.
     *
     * @return The Amazon Resource Name (ARN) assigned to the HarvestJob.
     */
    public String arn() {
        return arn;
    }

    /**
     * The ID of the Channel that the HarvestJob will harvest from.
     *
     * @return The ID of the Channel that the HarvestJob will harvest from.
     */
    public String channelId() {
        return channelId;
    }

    /**
     * The time the HarvestJob was submitted
     *
     * @return The time the HarvestJob was submitted
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * The end of the time-window which will be harvested.
     *
     * @return The end of the time-window which will be harvested.
     */
    public String endTime() {
        return endTime;
    }

    /**
     * The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the HarvestJob
     * is submitted.
     *
     * @return The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the
     *         HarvestJob is submitted.
     */
    public String id() {
        return id;
    }

    /**
     * The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the HarvestJob
     * is submitted.
     *
     * @return The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the
     *         HarvestJob is submitted.
     */
    public String originEndpointId() {
        return originEndpointId;
    }

    /**
     * Returns the value of the S3Destination property for this object.
     * 
     * @return The value of the S3Destination property for this object.
     */
    public S3Destination s3Destination() {
        return s3Destination;
    }

    /**
     * The start of the time-window which will be harvested.
     *
     * @return The start of the time-window which will be harvested.
     */
    public String startTime() {
        return startTime;
    }

    /**
     * The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for HarvestJobs as they
     * succeed or fail. In the event of failure, the CloudWatch Event will include an explanation of why the HarvestJob
     * failed.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for HarvestJobs as
     *         they succeed or fail. In the event of failure, the CloudWatch Event will include an explanation of why
     *         the HarvestJob failed.
     * @see Status
     */
    public Status status() {
        return Status.fromValue(status);
    }

    /**
     * The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for HarvestJobs as they
     * succeed or fail. In the event of failure, the CloudWatch Event will include an explanation of why the HarvestJob
     * failed.
     *
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for HarvestJobs as
     *         they succeed or fail. In the event of failure, the CloudWatch Event will include an explanation of why
     *         the HarvestJob failed.
     * @see Status
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HarvestJob)) {
            return false;
        }
        HarvestJob other = (HarvestJob) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(channelId(), other.channelId())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(id(), other.id()) && Objects.equals(originEndpointId(), other.originEndpointId())
                && Objects.equals(s3Destination(), other.s3Destination()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HarvestJob").add("Arn", arn()).add("ChannelId", channelId()).add("CreatedAt", createdAt())
                .add("EndTime", endTime()).add("Id", id()).add("OriginEndpointId", originEndpointId())
                .add("S3Destination", s3Destination()).add("StartTime", startTime()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "OriginEndpointId":
            return Optional.ofNullable(clazz.cast(originEndpointId()));
        case "S3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HarvestJob, T> g) {
        return obj -> g.apply((HarvestJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HarvestJob> {
        /**
         * The Amazon Resource Name (ARN) assigned to the HarvestJob.
         *
         * @param arn
         *        The Amazon Resource Name (ARN) assigned to the HarvestJob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The ID of the Channel that the HarvestJob will harvest from.
         *
         * @param channelId
         *        The ID of the Channel that the HarvestJob will harvest from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * The time the HarvestJob was submitted
         *
         * @param createdAt
         *        The time the HarvestJob was submitted
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * The end of the time-window which will be harvested.
         *
         * @param endTime
         *        The end of the time-window which will be harvested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the
         * HarvestJob is submitted.
         *
         * @param id
         *        The ID of the HarvestJob. The ID must be unique within the region and it cannot be changed after the
         *        HarvestJob is submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the
         * HarvestJob is submitted.
         *
         * @param originEndpointId
         *        The ID of the OriginEndpoint that the HarvestJob will harvest from. This cannot be changed after the
         *        HarvestJob is submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointId(String originEndpointId);

        /**
         * Sets the value of the S3Destination property for this object.
         *
         * @param s3Destination
         *        The new value for the S3Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(S3Destination s3Destination);

        /**
         * Sets the value of the S3Destination property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3Destination.Builder} avoiding the need to
         * create one manually via {@link S3Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Destination.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Destination(S3Destination)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link S3Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(S3Destination)
         */
        default Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return s3Destination(S3Destination.builder().applyMutation(s3Destination).build());
        }

        /**
         * The start of the time-window which will be harvested.
         *
         * @param startTime
         *        The start of the time-window which will be harvested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for HarvestJobs as
         * they succeed or fail. In the event of failure, the CloudWatch Event will include an explanation of why the
         * HarvestJob failed.
         *
         * @param status
         *        The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for HarvestJobs
         *        as they succeed or fail. In the event of failure, the CloudWatch Event will include an explanation of
         *        why the HarvestJob failed.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for HarvestJobs as
         * they succeed or fail. In the event of failure, the CloudWatch Event will include an explanation of why the
         * HarvestJob failed.
         *
         * @param status
         *        The current status of the HarvestJob. Consider setting up a CloudWatch Event to listen for HarvestJobs
         *        as they succeed or fail. In the event of failure, the CloudWatch Event will include an explanation of
         *        why the HarvestJob failed.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String channelId;

        private String createdAt;

        private String endTime;

        private String id;

        private String originEndpointId;

        private S3Destination s3Destination;

        private String startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(HarvestJob model) {
            arn(model.arn);
            channelId(model.channelId);
            createdAt(model.createdAt);
            endTime(model.endTime);
            id(model.id);
            originEndpointId(model.originEndpointId);
            s3Destination(model.s3Destination);
            startTime(model.startTime);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getChannelId() {
            return channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getOriginEndpointId() {
            return originEndpointId;
        }

        @Override
        public final Builder originEndpointId(String originEndpointId) {
            this.originEndpointId = originEndpointId;
            return this;
        }

        public final void setOriginEndpointId(String originEndpointId) {
            this.originEndpointId = originEndpointId;
        }

        public final S3Destination.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        public final String getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public HarvestJob build() {
            return new HarvestJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
