/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOriginEndpointResponse extends MediaPackageV2Response implements
        ToCopyableBuilder<CreateOriginEndpointResponse.Builder, CreateOriginEndpointResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateOriginEndpointResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(CreateOriginEndpointResponse::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(CreateOriginEndpointResponse::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginEndpointName").getter(getter(CreateOriginEndpointResponse::originEndpointName))
            .setter(setter(Builder::originEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginEndpointName").build())
            .build();

    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerType").getter(getter(CreateOriginEndpointResponse::containerTypeAsString))
            .setter(setter(Builder::containerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerType").build()).build();

    private static final SdkField<Segment> SEGMENT_FIELD = SdkField.<Segment> builder(MarshallingType.SDK_POJO)
            .memberName("Segment").getter(getter(CreateOriginEndpointResponse::segment)).setter(setter(Builder::segment))
            .constructor(Segment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segment").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(CreateOriginEndpointResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt").getter(getter(CreateOriginEndpointResponse::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateOriginEndpointResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> STARTOVER_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartoverWindowSeconds").getter(getter(CreateOriginEndpointResponse::startoverWindowSeconds))
            .setter(setter(Builder::startoverWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartoverWindowSeconds").build())
            .build();

    private static final SdkField<List<GetHlsManifestConfiguration>> HLS_MANIFESTS_FIELD = SdkField
            .<List<GetHlsManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("HlsManifests")
            .getter(getter(CreateOriginEndpointResponse::hlsManifests))
            .setter(setter(Builder::hlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetHlsManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetHlsManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GetLowLatencyHlsManifestConfiguration>> LOW_LATENCY_HLS_MANIFESTS_FIELD = SdkField
            .<List<GetLowLatencyHlsManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("LowLatencyHlsManifests")
            .getter(getter(CreateOriginEndpointResponse::lowLatencyHlsManifests))
            .setter(setter(Builder::lowLatencyHlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowLatencyHlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetLowLatencyHlsManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetLowLatencyHlsManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(CreateOriginEndpointResponse::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateOriginEndpointResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CHANNEL_GROUP_NAME_FIELD, CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, CONTAINER_TYPE_FIELD, SEGMENT_FIELD,
            CREATED_AT_FIELD, MODIFIED_AT_FIELD, DESCRIPTION_FIELD, STARTOVER_WINDOW_SECONDS_FIELD, HLS_MANIFESTS_FIELD,
            LOW_LATENCY_HLS_MANIFESTS_FIELD, E_TAG_FIELD, TAGS_FIELD));

    private final String arn;

    private final String channelGroupName;

    private final String channelName;

    private final String originEndpointName;

    private final String containerType;

    private final Segment segment;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String description;

    private final Integer startoverWindowSeconds;

    private final List<GetHlsManifestConfiguration> hlsManifests;

    private final List<GetLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests;

    private final String eTag;

    private final Map<String, String> tags;

    private CreateOriginEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.containerType = builder.containerType;
        this.segment = builder.segment;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.description = builder.description;
        this.startoverWindowSeconds = builder.startoverWindowSeconds;
        this.hlsManifests = builder.hlsManifests;
        this.lowLatencyHlsManifests = builder.lowLatencyHlsManifests;
        this.eTag = builder.eTag;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be
     * unique for your account in the AWS Region.
     * </p>
     * 
     * @return The name that describes the channel group. The name is the primary identifier for the channel group, and
     *         must be unique for your account in the AWS Region.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for
     * your account in the AWS Region and channel group.
     * </p>
     * 
     * @return The name that describes the channel. The name is the primary identifier for the channel, and must be
     *         unique for your account in the AWS Region and channel group.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and
     * must be unique for your account in the AWS Region and channel.
     * </p>
     * 
     * @return The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint,
     *         and and must be unique for your account in the AWS Region and channel.
     */
    public final String originEndpointName() {
        return originEndpointName;
    }

    /**
     * <p>
     * The type of container attached to this origin endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return The type of container attached to this origin endpoint.
     * @see ContainerType
     */
    public final ContainerType containerType() {
        return ContainerType.fromValue(containerType);
    }

    /**
     * <p>
     * The type of container attached to this origin endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return The type of container attached to this origin endpoint.
     * @see ContainerType
     */
    public final String containerTypeAsString() {
        return containerType;
    }

    /**
     * <p>
     * The segment configuration, including the segment name, duration, and other configuration values.
     * </p>
     * 
     * @return The segment configuration, including the segment name, duration, and other configuration values.
     */
    public final Segment segment() {
        return segment;
    }

    /**
     * <p>
     * The date and time the origin endpoint was created.
     * </p>
     * 
     * @return The date and time the origin endpoint was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time the origin endpoint was modified.
     * </p>
     * 
     * @return The date and time the origin endpoint was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The description for your origin endpoint.
     * </p>
     * 
     * @return The description for your origin endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing.
     * Viewers can start-over or catch-up on content that falls within the window.
     * </p>
     * 
     * @return The size of the window (in seconds) to create a window of the live stream that's available for on-demand
     *         viewing. Viewers can start-over or catch-up on content that falls within the window.
     */
    public final Integer startoverWindowSeconds() {
        return startoverWindowSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the HlsManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHlsManifests() {
        return hlsManifests != null && !(hlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An HTTP live streaming (HLS) manifest configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHlsManifests} method.
     * </p>
     * 
     * @return An HTTP live streaming (HLS) manifest configuration.
     */
    public final List<GetHlsManifestConfiguration> hlsManifests() {
        return hlsManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the LowLatencyHlsManifests property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLowLatencyHlsManifests() {
        return lowLatencyHlsManifests != null && !(lowLatencyHlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A low-latency HLS manifest configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLowLatencyHlsManifests} method.
     * </p>
     * 
     * @return A low-latency HLS manifest configuration.
     */
    public final List<GetLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests() {
        return lowLatencyHlsManifests;
    }

    /**
     * <p>
     * The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent
     * updates to the resource.
     * </p>
     * 
     * @return The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make
     *         concurrent updates to the resource.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The comma-separated list of tag key:value pairs assigned to the origin endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The comma-separated list of tag key:value pairs assigned to the origin endpoint.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segment());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(startoverWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasHlsManifests() ? hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLowLatencyHlsManifests() ? lowLatencyHlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOriginEndpointResponse)) {
            return false;
        }
        CreateOriginEndpointResponse other = (CreateOriginEndpointResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(channelGroupName(), other.channelGroupName())
                && Objects.equals(channelName(), other.channelName())
                && Objects.equals(originEndpointName(), other.originEndpointName())
                && Objects.equals(containerTypeAsString(), other.containerTypeAsString())
                && Objects.equals(segment(), other.segment()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(description(), other.description())
                && Objects.equals(startoverWindowSeconds(), other.startoverWindowSeconds())
                && hasHlsManifests() == other.hasHlsManifests() && Objects.equals(hlsManifests(), other.hlsManifests())
                && hasLowLatencyHlsManifests() == other.hasLowLatencyHlsManifests()
                && Objects.equals(lowLatencyHlsManifests(), other.lowLatencyHlsManifests())
                && Objects.equals(eTag(), other.eTag()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOriginEndpointResponse").add("Arn", arn()).add("ChannelGroupName", channelGroupName())
                .add("ChannelName", channelName()).add("OriginEndpointName", originEndpointName())
                .add("ContainerType", containerTypeAsString()).add("Segment", segment()).add("CreatedAt", createdAt())
                .add("ModifiedAt", modifiedAt()).add("Description", description())
                .add("StartoverWindowSeconds", startoverWindowSeconds())
                .add("HlsManifests", hasHlsManifests() ? hlsManifests() : null)
                .add("LowLatencyHlsManifests", hasLowLatencyHlsManifests() ? lowLatencyHlsManifests() : null).add("ETag", eTag())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "OriginEndpointName":
            return Optional.ofNullable(clazz.cast(originEndpointName()));
        case "ContainerType":
            return Optional.ofNullable(clazz.cast(containerTypeAsString()));
        case "Segment":
            return Optional.ofNullable(clazz.cast(segment()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "StartoverWindowSeconds":
            return Optional.ofNullable(clazz.cast(startoverWindowSeconds()));
        case "HlsManifests":
            return Optional.ofNullable(clazz.cast(hlsManifests()));
        case "LowLatencyHlsManifests":
            return Optional.ofNullable(clazz.cast(lowLatencyHlsManifests()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOriginEndpointResponse, T> g) {
        return obj -> g.apply((CreateOriginEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateOriginEndpointResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must
         * be unique for your account in the AWS Region.
         * </p>
         * 
         * @param channelGroupName
         *        The name that describes the channel group. The name is the primary identifier for the channel group,
         *        and must be unique for your account in the AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique
         * for your account in the AWS Region and channel group.
         * </p>
         * 
         * @param channelName
         *        The name that describes the channel. The name is the primary identifier for the channel, and must be
         *        unique for your account in the AWS Region and channel group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and
         * and must be unique for your account in the AWS Region and channel.
         * </p>
         * 
         * @param originEndpointName
         *        The name that describes the origin endpoint. The name is the primary identifier for the origin
         *        endpoint, and and must be unique for your account in the AWS Region and channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointName(String originEndpointName);

        /**
         * <p>
         * The type of container attached to this origin endpoint.
         * </p>
         * 
         * @param containerType
         *        The type of container attached to this origin endpoint.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(String containerType);

        /**
         * <p>
         * The type of container attached to this origin endpoint.
         * </p>
         * 
         * @param containerType
         *        The type of container attached to this origin endpoint.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(ContainerType containerType);

        /**
         * <p>
         * The segment configuration, including the segment name, duration, and other configuration values.
         * </p>
         * 
         * @param segment
         *        The segment configuration, including the segment name, duration, and other configuration values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segment(Segment segment);

        /**
         * <p>
         * The segment configuration, including the segment name, duration, and other configuration values.
         * </p>
         * This is a convenience method that creates an instance of the {@link Segment.Builder} avoiding the need to
         * create one manually via {@link Segment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Segment.Builder#build()} is called immediately and its result is
         * passed to {@link #segment(Segment)}.
         * 
         * @param segment
         *        a consumer that will call methods on {@link Segment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segment(Segment)
         */
        default Builder segment(Consumer<Segment.Builder> segment) {
            return segment(Segment.builder().applyMutation(segment).build());
        }

        /**
         * <p>
         * The date and time the origin endpoint was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the origin endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time the origin endpoint was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time the origin endpoint was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The description for your origin endpoint.
         * </p>
         * 
         * @param description
         *        The description for your origin endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The size of the window (in seconds) to create a window of the live stream that's available for on-demand
         * viewing. Viewers can start-over or catch-up on content that falls within the window.
         * </p>
         * 
         * @param startoverWindowSeconds
         *        The size of the window (in seconds) to create a window of the live stream that's available for
         *        on-demand viewing. Viewers can start-over or catch-up on content that falls within the window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startoverWindowSeconds(Integer startoverWindowSeconds);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * 
         * @param hlsManifests
         *        An HTTP live streaming (HLS) manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(Collection<GetHlsManifestConfiguration> hlsManifests);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * 
         * @param hlsManifests
         *        An HTTP live streaming (HLS) manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(GetHlsManifestConfiguration... hlsManifests);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.GetHlsManifestConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.GetHlsManifestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.GetHlsManifestConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #hlsManifests(List<GetHlsManifestConfiguration>)}.
         * 
         * @param hlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetHlsManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsManifests(java.util.Collection<GetHlsManifestConfiguration>)
         */
        Builder hlsManifests(Consumer<GetHlsManifestConfiguration.Builder>... hlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * 
         * @param lowLatencyHlsManifests
         *        A low-latency HLS manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowLatencyHlsManifests(Collection<GetLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * 
         * @param lowLatencyHlsManifests
         *        A low-latency HLS manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowLatencyHlsManifests(GetLowLatencyHlsManifestConfiguration... lowLatencyHlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #lowLatencyHlsManifests(List<GetLowLatencyHlsManifestConfiguration>)}.
         * 
         * @param lowLatencyHlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lowLatencyHlsManifests(java.util.Collection<GetLowLatencyHlsManifestConfiguration>)
         */
        Builder lowLatencyHlsManifests(Consumer<GetLowLatencyHlsManifestConfiguration.Builder>... lowLatencyHlsManifests);

        /**
         * <p>
         * The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make
         * concurrent updates to the resource.
         * </p>
         * 
         * @param eTag
         *        The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make
         *        concurrent updates to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The comma-separated list of tag key:value pairs assigned to the origin endpoint.
         * </p>
         * 
         * @param tags
         *        The comma-separated list of tag key:value pairs assigned to the origin endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaPackageV2Response.BuilderImpl implements Builder {
        private String arn;

        private String channelGroupName;

        private String channelName;

        private String originEndpointName;

        private String containerType;

        private Segment segment;

        private Instant createdAt;

        private Instant modifiedAt;

        private String description;

        private Integer startoverWindowSeconds;

        private List<GetHlsManifestConfiguration> hlsManifests = DefaultSdkAutoConstructList.getInstance();

        private List<GetLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests = DefaultSdkAutoConstructList.getInstance();

        private String eTag;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOriginEndpointResponse model) {
            super(model);
            arn(model.arn);
            channelGroupName(model.channelGroupName);
            channelName(model.channelName);
            originEndpointName(model.originEndpointName);
            containerType(model.containerType);
            segment(model.segment);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            description(model.description);
            startoverWindowSeconds(model.startoverWindowSeconds);
            hlsManifests(model.hlsManifests);
            lowLatencyHlsManifests(model.lowLatencyHlsManifests);
            eTag(model.eTag);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getContainerType() {
            return containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final Segment.Builder getSegment() {
            return segment != null ? segment.toBuilder() : null;
        }

        public final void setSegment(Segment.BuilderImpl segment) {
            this.segment = segment != null ? segment.build() : null;
        }

        @Override
        public final Builder segment(Segment segment) {
            this.segment = segment;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getStartoverWindowSeconds() {
            return startoverWindowSeconds;
        }

        public final void setStartoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
        }

        @Override
        public final Builder startoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
            return this;
        }

        public final List<GetHlsManifestConfiguration.Builder> getHlsManifests() {
            List<GetHlsManifestConfiguration.Builder> result = GetHlsManifestsCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHlsManifests(Collection<GetHlsManifestConfiguration.BuilderImpl> hlsManifests) {
            this.hlsManifests = GetHlsManifestsCopier.copyFromBuilder(hlsManifests);
        }

        @Override
        public final Builder hlsManifests(Collection<GetHlsManifestConfiguration> hlsManifests) {
            this.hlsManifests = GetHlsManifestsCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(GetHlsManifestConfiguration... hlsManifests) {
            hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<GetHlsManifestConfiguration.Builder>... hlsManifests) {
            hlsManifests(Stream.of(hlsManifests).map(c -> GetHlsManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GetLowLatencyHlsManifestConfiguration.Builder> getLowLatencyHlsManifests() {
            List<GetLowLatencyHlsManifestConfiguration.Builder> result = GetLowLatencyHlsManifestsCopier
                    .copyToBuilder(this.lowLatencyHlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLowLatencyHlsManifests(
                Collection<GetLowLatencyHlsManifestConfiguration.BuilderImpl> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = GetLowLatencyHlsManifestsCopier.copyFromBuilder(lowLatencyHlsManifests);
        }

        @Override
        public final Builder lowLatencyHlsManifests(Collection<GetLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = GetLowLatencyHlsManifestsCopier.copy(lowLatencyHlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(GetLowLatencyHlsManifestConfiguration... lowLatencyHlsManifests) {
            lowLatencyHlsManifests(Arrays.asList(lowLatencyHlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(
                Consumer<GetLowLatencyHlsManifestConfiguration.Builder>... lowLatencyHlsManifests) {
            lowLatencyHlsManifests(Stream.of(lowLatencyHlsManifests)
                    .map(c -> GetLowLatencyHlsManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateOriginEndpointResponse build() {
            return new CreateOriginEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
