/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChannelGroupResponse extends MediaPackageV2Response implements
        ToCopyableBuilder<GetChannelGroupResponse.Builder, GetChannelGroupResponse> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(GetChannelGroupResponse::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetChannelGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> EGRESS_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EgressDomain").getter(getter(GetChannelGroupResponse::egressDomain))
            .setter(setter(Builder::egressDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressDomain").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetChannelGroupResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt").getter(getter(GetChannelGroupResponse::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetChannelGroupResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(GetChannelGroupResponse::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetChannelGroupResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD,
            ARN_FIELD, EGRESS_DOMAIN_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, DESCRIPTION_FIELD, E_TAG_FIELD, TAGS_FIELD));

    private final String channelGroupName;

    private final String arn;

    private final String egressDomain;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String description;

    private final String eTag;

    private final Map<String, String> tags;

    private GetChannelGroupResponse(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.arn = builder.arn;
        this.egressDomain = builder.egressDomain;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.description = builder.description;
        this.eTag = builder.eTag;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be
     * unique for your account in the AWS Region.
     * </p>
     * 
     * @return The name that describes the channel group. The name is the primary identifier for the channel group, and
     *         must be unique for your account in the AWS Region.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The output domain where the source stream should be sent. Integrate the domain with a downstream CDN (such as
     * Amazon CloudFront) or playback device.
     * </p>
     * 
     * @return The output domain where the source stream should be sent. Integrate the domain with a downstream CDN
     *         (such as Amazon CloudFront) or playback device.
     */
    public final String egressDomain() {
        return egressDomain;
    }

    /**
     * <p>
     * The date and time the channel group was created.
     * </p>
     * 
     * @return The date and time the channel group was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time the channel group was modified.
     * </p>
     * 
     * @return The date and time the channel group was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The description for your channel group.
     * </p>
     * 
     * @return The description for your channel group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent
     * updates to the resource.
     * </p>
     * 
     * @return The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make
     *         concurrent updates to the resource.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The comma-separated list of tag key:value pairs assigned to the channel group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The comma-separated list of tag key:value pairs assigned to the channel group.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(egressDomain());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChannelGroupResponse)) {
            return false;
        }
        GetChannelGroupResponse other = (GetChannelGroupResponse) obj;
        return Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(arn(), other.arn())
                && Objects.equals(egressDomain(), other.egressDomain()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(description(), other.description())
                && Objects.equals(eTag(), other.eTag()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChannelGroupResponse").add("ChannelGroupName", channelGroupName()).add("Arn", arn())
                .add("EgressDomain", egressDomain()).add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("Description", description()).add("ETag", eTag()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "EgressDomain":
            return Optional.ofNullable(clazz.cast(egressDomain()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetChannelGroupResponse, T> g) {
        return obj -> g.apply((GetChannelGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetChannelGroupResponse> {
        /**
         * <p>
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must
         * be unique for your account in the AWS Region.
         * </p>
         * 
         * @param channelGroupName
         *        The name that describes the channel group. The name is the primary identifier for the channel group,
         *        and must be unique for your account in the AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The output domain where the source stream should be sent. Integrate the domain with a downstream CDN (such as
         * Amazon CloudFront) or playback device.
         * </p>
         * 
         * @param egressDomain
         *        The output domain where the source stream should be sent. Integrate the domain with a downstream CDN
         *        (such as Amazon CloudFront) or playback device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressDomain(String egressDomain);

        /**
         * <p>
         * The date and time the channel group was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the channel group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time the channel group was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time the channel group was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The description for your channel group.
         * </p>
         * 
         * @param description
         *        The description for your channel group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make
         * concurrent updates to the resource.
         * </p>
         * 
         * @param eTag
         *        The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make
         *        concurrent updates to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The comma-separated list of tag key:value pairs assigned to the channel group.
         * </p>
         * 
         * @param tags
         *        The comma-separated list of tag key:value pairs assigned to the channel group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaPackageV2Response.BuilderImpl implements Builder {
        private String channelGroupName;

        private String arn;

        private String egressDomain;

        private Instant createdAt;

        private Instant modifiedAt;

        private String description;

        private String eTag;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetChannelGroupResponse model) {
            super(model);
            channelGroupName(model.channelGroupName);
            arn(model.arn);
            egressDomain(model.egressDomain);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            description(model.description);
            eTag(model.eTag);
            tags(model.tags);
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getEgressDomain() {
            return egressDomain;
        }

        public final void setEgressDomain(String egressDomain) {
            this.egressDomain = egressDomain;
        }

        @Override
        public final Builder egressDomain(String egressDomain) {
            this.egressDomain = egressDomain;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetChannelGroupResponse build() {
            return new GetChannelGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
