/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2Client;
import software.amazon.awssdk.services.mediapackagev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediapackagev2.model.ChannelGroupListConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse;

public class ListChannelGroupsIterable
implements SdkIterable<ListChannelGroupsResponse> {
    private final MediaPackageV2Client client;
    private final ListChannelGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelGroupsIterable(MediaPackageV2Client client, ListChannelGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChannelGroupsResponseFetcher();
    }

    public Iterator<ListChannelGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChannelGroupListConfiguration> items() {
        Function<ListChannelGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListChannelGroupsResponseFetcher
    implements SyncPageFetcher<ListChannelGroupsResponse> {
        private ListChannelGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelGroupsResponse nextPage(ListChannelGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelGroupsIterable.this.client.listChannelGroups(ListChannelGroupsIterable.this.firstRequest);
            }
            return ListChannelGroupsIterable.this.client.listChannelGroups((ListChannelGroupsRequest)((Object)ListChannelGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

