/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashUtcTiming implements SdkPojo, Serializable, ToCopyableBuilder<DashUtcTiming.Builder, DashUtcTiming> {
    private static final SdkField<String> TIMING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimingMode").getter(getter(DashUtcTiming::timingModeAsString)).setter(setter(Builder::timingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimingMode").build()).build();

    private static final SdkField<String> TIMING_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimingSource").getter(getter(DashUtcTiming::timingSource)).setter(setter(Builder::timingSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimingSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMING_MODE_FIELD,
            TIMING_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timingMode;

    private final String timingSource;

    private DashUtcTiming(BuilderImpl builder) {
        this.timingMode = builder.timingMode;
        this.timingSource = builder.timingSource;
    }

    /**
     * <p>
     * The UTC timing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timingMode} will
     * return {@link DashUtcTimingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timingModeAsString}.
     * </p>
     * 
     * @return The UTC timing mode.
     * @see DashUtcTimingMode
     */
    public final DashUtcTimingMode timingMode() {
        return DashUtcTimingMode.fromValue(timingMode);
    }

    /**
     * <p>
     * The UTC timing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timingMode} will
     * return {@link DashUtcTimingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timingModeAsString}.
     * </p>
     * 
     * @return The UTC timing mode.
     * @see DashUtcTimingMode
     */
    public final String timingModeAsString() {
        return timingMode;
    }

    /**
     * <p>
     * The the method that the player uses to synchronize to coordinated universal time (UTC) wall clock time.
     * </p>
     * 
     * @return The the method that the player uses to synchronize to coordinated universal time (UTC) wall clock time.
     */
    public final String timingSource() {
        return timingSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timingSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashUtcTiming)) {
            return false;
        }
        DashUtcTiming other = (DashUtcTiming) obj;
        return Objects.equals(timingModeAsString(), other.timingModeAsString())
                && Objects.equals(timingSource(), other.timingSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashUtcTiming").add("TimingMode", timingModeAsString()).add("TimingSource", timingSource())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimingMode":
            return Optional.ofNullable(clazz.cast(timingModeAsString()));
        case "TimingSource":
            return Optional.ofNullable(clazz.cast(timingSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashUtcTiming, T> g) {
        return obj -> g.apply((DashUtcTiming) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashUtcTiming> {
        /**
         * <p>
         * The UTC timing mode.
         * </p>
         * 
         * @param timingMode
         *        The UTC timing mode.
         * @see DashUtcTimingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashUtcTimingMode
         */
        Builder timingMode(String timingMode);

        /**
         * <p>
         * The UTC timing mode.
         * </p>
         * 
         * @param timingMode
         *        The UTC timing mode.
         * @see DashUtcTimingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashUtcTimingMode
         */
        Builder timingMode(DashUtcTimingMode timingMode);

        /**
         * <p>
         * The the method that the player uses to synchronize to coordinated universal time (UTC) wall clock time.
         * </p>
         * 
         * @param timingSource
         *        The the method that the player uses to synchronize to coordinated universal time (UTC) wall clock
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timingSource(String timingSource);
    }

    static final class BuilderImpl implements Builder {
        private String timingMode;

        private String timingSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DashUtcTiming model) {
            timingMode(model.timingMode);
            timingSource(model.timingSource);
        }

        public final String getTimingMode() {
            return timingMode;
        }

        public final void setTimingMode(String timingMode) {
            this.timingMode = timingMode;
        }

        @Override
        public final Builder timingMode(String timingMode) {
            this.timingMode = timingMode;
            return this;
        }

        @Override
        public final Builder timingMode(DashUtcTimingMode timingMode) {
            this.timingMode(timingMode == null ? null : timingMode.toString());
            return this;
        }

        public final String getTimingSource() {
            return timingSource;
        }

        public final void setTimingSource(String timingSource) {
            this.timingSource = timingSource;
        }

        @Override
        public final Builder timingSource(String timingSource) {
            this.timingSource = timingSource;
            return this;
        }

        @Override
        public DashUtcTiming build() {
            return new DashUtcTiming(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
