/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOriginEndpointRequest extends MediaPackageV2Request implements
        ToCopyableBuilder<UpdateOriginEndpointRequest.Builder, UpdateOriginEndpointRequest> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(UpdateOriginEndpointRequest::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(UpdateOriginEndpointRequest::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginEndpointName").getter(getter(UpdateOriginEndpointRequest::originEndpointName))
            .setter(setter(Builder::originEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("OriginEndpointName").build()).build();

    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerType").getter(getter(UpdateOriginEndpointRequest::containerTypeAsString))
            .setter(setter(Builder::containerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerType").build()).build();

    private static final SdkField<Segment> SEGMENT_FIELD = SdkField.<Segment> builder(MarshallingType.SDK_POJO)
            .memberName("Segment").getter(getter(UpdateOriginEndpointRequest::segment)).setter(setter(Builder::segment))
            .constructor(Segment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segment").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateOriginEndpointRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> STARTOVER_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartoverWindowSeconds").getter(getter(UpdateOriginEndpointRequest::startoverWindowSeconds))
            .setter(setter(Builder::startoverWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartoverWindowSeconds").build())
            .build();

    private static final SdkField<List<CreateHlsManifestConfiguration>> HLS_MANIFESTS_FIELD = SdkField
            .<List<CreateHlsManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("HlsManifests")
            .getter(getter(UpdateOriginEndpointRequest::hlsManifests))
            .setter(setter(Builder::hlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateHlsManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateHlsManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CreateLowLatencyHlsManifestConfiguration>> LOW_LATENCY_HLS_MANIFESTS_FIELD = SdkField
            .<List<CreateLowLatencyHlsManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("LowLatencyHlsManifests")
            .getter(getter(UpdateOriginEndpointRequest::lowLatencyHlsManifests))
            .setter(setter(Builder::lowLatencyHlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowLatencyHlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateLowLatencyHlsManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateLowLatencyHlsManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CreateDashManifestConfiguration>> DASH_MANIFESTS_FIELD = SdkField
            .<List<CreateDashManifestConfiguration>> builder(MarshallingType.LIST)
            .memberName("DashManifests")
            .getter(getter(UpdateOriginEndpointRequest::dashManifests))
            .setter(setter(Builder::dashManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateDashManifestConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateDashManifestConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ForceEndpointErrorConfiguration> FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD = SdkField
            .<ForceEndpointErrorConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ForceEndpointErrorConfiguration")
            .getter(getter(UpdateOriginEndpointRequest::forceEndpointErrorConfiguration))
            .setter(setter(Builder::forceEndpointErrorConfiguration))
            .constructor(ForceEndpointErrorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceEndpointErrorConfiguration")
                    .build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(UpdateOriginEndpointRequest::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-update-if-match").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD,
            CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, CONTAINER_TYPE_FIELD, SEGMENT_FIELD, DESCRIPTION_FIELD,
            STARTOVER_WINDOW_SECONDS_FIELD, HLS_MANIFESTS_FIELD, LOW_LATENCY_HLS_MANIFESTS_FIELD, DASH_MANIFESTS_FIELD,
            FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD, E_TAG_FIELD));

    private final String channelGroupName;

    private final String channelName;

    private final String originEndpointName;

    private final String containerType;

    private final Segment segment;

    private final String description;

    private final Integer startoverWindowSeconds;

    private final List<CreateHlsManifestConfiguration> hlsManifests;

    private final List<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests;

    private final List<CreateDashManifestConfiguration> dashManifests;

    private final ForceEndpointErrorConfiguration forceEndpointErrorConfiguration;

    private final String eTag;

    private UpdateOriginEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.containerType = builder.containerType;
        this.segment = builder.segment;
        this.description = builder.description;
        this.startoverWindowSeconds = builder.startoverWindowSeconds;
        this.hlsManifests = builder.hlsManifests;
        this.lowLatencyHlsManifests = builder.lowLatencyHlsManifests;
        this.dashManifests = builder.dashManifests;
        this.forceEndpointErrorConfiguration = builder.forceEndpointErrorConfiguration;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be
     * unique for your account in the AWS Region.
     * </p>
     * 
     * @return The name that describes the channel group. The name is the primary identifier for the channel group, and
     *         must be unique for your account in the AWS Region.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for
     * your account in the AWS Region and channel group.
     * </p>
     * 
     * @return The name that describes the channel. The name is the primary identifier for the channel, and must be
     *         unique for your account in the AWS Region and channel group.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and and
     * must be unique for your account in the AWS Region and channel.
     * </p>
     * 
     * @return The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint,
     *         and and must be unique for your account in the AWS Region and channel.
     */
    public final String originEndpointName() {
        return originEndpointName;
    }

    /**
     * <p>
     * The type of container attached to this origin endpoint. A container type is a file format that encapsulates one
     * or more media streams, such as audio and video, into a single file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return The type of container attached to this origin endpoint. A container type is a file format that
     *         encapsulates one or more media streams, such as audio and video, into a single file.
     * @see ContainerType
     */
    public final ContainerType containerType() {
        return ContainerType.fromValue(containerType);
    }

    /**
     * <p>
     * The type of container attached to this origin endpoint. A container type is a file format that encapsulates one
     * or more media streams, such as audio and video, into a single file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerType}
     * will return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerTypeAsString}.
     * </p>
     * 
     * @return The type of container attached to this origin endpoint. A container type is a file format that
     *         encapsulates one or more media streams, such as audio and video, into a single file.
     * @see ContainerType
     */
    public final String containerTypeAsString() {
        return containerType;
    }

    /**
     * <p>
     * The segment configuration, including the segment name, duration, and other configuration values.
     * </p>
     * 
     * @return The segment configuration, including the segment name, duration, and other configuration values.
     */
    public final Segment segment() {
        return segment;
    }

    /**
     * <p>
     * Any descriptive information that you want to add to the origin endpoint for future identification purposes.
     * </p>
     * 
     * @return Any descriptive information that you want to add to the origin endpoint for future identification
     *         purposes.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The size of the window (in seconds) to create a window of the live stream that's available for on-demand viewing.
     * Viewers can start-over or catch-up on content that falls within the window. The maximum startover window is
     * 1,209,600 seconds (14 days).
     * </p>
     * 
     * @return The size of the window (in seconds) to create a window of the live stream that's available for on-demand
     *         viewing. Viewers can start-over or catch-up on content that falls within the window. The maximum
     *         startover window is 1,209,600 seconds (14 days).
     */
    public final Integer startoverWindowSeconds() {
        return startoverWindowSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the HlsManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHlsManifests() {
        return hlsManifests != null && !(hlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An HTTP live streaming (HLS) manifest configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHlsManifests} method.
     * </p>
     * 
     * @return An HTTP live streaming (HLS) manifest configuration.
     */
    public final List<CreateHlsManifestConfiguration> hlsManifests() {
        return hlsManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the LowLatencyHlsManifests property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLowLatencyHlsManifests() {
        return lowLatencyHlsManifests != null && !(lowLatencyHlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A low-latency HLS manifest configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLowLatencyHlsManifests} method.
     * </p>
     * 
     * @return A low-latency HLS manifest configuration.
     */
    public final List<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests() {
        return lowLatencyHlsManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the DashManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDashManifests() {
        return dashManifests != null && !(dashManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A DASH manifest configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashManifests} method.
     * </p>
     * 
     * @return A DASH manifest configuration.
     */
    public final List<CreateDashManifestConfiguration> dashManifests() {
        return dashManifests;
    }

    /**
     * <p>
     * The failover settings for the endpoint.
     * </p>
     * 
     * @return The failover settings for the endpoint.
     */
    public final ForceEndpointErrorConfiguration forceEndpointErrorConfiguration() {
        return forceEndpointErrorConfiguration;
    }

    /**
     * <p>
     * The expected current Entity Tag (ETag) for the resource. If the specified ETag does not match the resource's
     * current entity tag, the update request will be rejected.
     * </p>
     * 
     * @return The expected current Entity Tag (ETag) for the resource. If the specified ETag does not match the
     *         resource's current entity tag, the update request will be rejected.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segment());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(startoverWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasHlsManifests() ? hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLowLatencyHlsManifests() ? lowLatencyHlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDashManifests() ? dashManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(forceEndpointErrorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOriginEndpointRequest)) {
            return false;
        }
        UpdateOriginEndpointRequest other = (UpdateOriginEndpointRequest) obj;
        return Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(originEndpointName(), other.originEndpointName())
                && Objects.equals(containerTypeAsString(), other.containerTypeAsString())
                && Objects.equals(segment(), other.segment()) && Objects.equals(description(), other.description())
                && Objects.equals(startoverWindowSeconds(), other.startoverWindowSeconds())
                && hasHlsManifests() == other.hasHlsManifests() && Objects.equals(hlsManifests(), other.hlsManifests())
                && hasLowLatencyHlsManifests() == other.hasLowLatencyHlsManifests()
                && Objects.equals(lowLatencyHlsManifests(), other.lowLatencyHlsManifests())
                && hasDashManifests() == other.hasDashManifests() && Objects.equals(dashManifests(), other.dashManifests())
                && Objects.equals(forceEndpointErrorConfiguration(), other.forceEndpointErrorConfiguration())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOriginEndpointRequest").add("ChannelGroupName", channelGroupName())
                .add("ChannelName", channelName()).add("OriginEndpointName", originEndpointName())
                .add("ContainerType", containerTypeAsString()).add("Segment", segment()).add("Description", description())
                .add("StartoverWindowSeconds", startoverWindowSeconds())
                .add("HlsManifests", hasHlsManifests() ? hlsManifests() : null)
                .add("LowLatencyHlsManifests", hasLowLatencyHlsManifests() ? lowLatencyHlsManifests() : null)
                .add("DashManifests", hasDashManifests() ? dashManifests() : null)
                .add("ForceEndpointErrorConfiguration", forceEndpointErrorConfiguration()).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "OriginEndpointName":
            return Optional.ofNullable(clazz.cast(originEndpointName()));
        case "ContainerType":
            return Optional.ofNullable(clazz.cast(containerTypeAsString()));
        case "Segment":
            return Optional.ofNullable(clazz.cast(segment()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "StartoverWindowSeconds":
            return Optional.ofNullable(clazz.cast(startoverWindowSeconds()));
        case "HlsManifests":
            return Optional.ofNullable(clazz.cast(hlsManifests()));
        case "LowLatencyHlsManifests":
            return Optional.ofNullable(clazz.cast(lowLatencyHlsManifests()));
        case "DashManifests":
            return Optional.ofNullable(clazz.cast(dashManifests()));
        case "ForceEndpointErrorConfiguration":
            return Optional.ofNullable(clazz.cast(forceEndpointErrorConfiguration()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOriginEndpointRequest, T> g) {
        return obj -> g.apply((UpdateOriginEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateOriginEndpointRequest> {
        /**
         * <p>
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must
         * be unique for your account in the AWS Region.
         * </p>
         * 
         * @param channelGroupName
         *        The name that describes the channel group. The name is the primary identifier for the channel group,
         *        and must be unique for your account in the AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique
         * for your account in the AWS Region and channel group.
         * </p>
         * 
         * @param channelName
         *        The name that describes the channel. The name is the primary identifier for the channel, and must be
         *        unique for your account in the AWS Region and channel group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name that describes the origin endpoint. The name is the primary identifier for the origin endpoint, and
         * and must be unique for your account in the AWS Region and channel.
         * </p>
         * 
         * @param originEndpointName
         *        The name that describes the origin endpoint. The name is the primary identifier for the origin
         *        endpoint, and and must be unique for your account in the AWS Region and channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointName(String originEndpointName);

        /**
         * <p>
         * The type of container attached to this origin endpoint. A container type is a file format that encapsulates
         * one or more media streams, such as audio and video, into a single file.
         * </p>
         * 
         * @param containerType
         *        The type of container attached to this origin endpoint. A container type is a file format that
         *        encapsulates one or more media streams, such as audio and video, into a single file.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(String containerType);

        /**
         * <p>
         * The type of container attached to this origin endpoint. A container type is a file format that encapsulates
         * one or more media streams, such as audio and video, into a single file.
         * </p>
         * 
         * @param containerType
         *        The type of container attached to this origin endpoint. A container type is a file format that
         *        encapsulates one or more media streams, such as audio and video, into a single file.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder containerType(ContainerType containerType);

        /**
         * <p>
         * The segment configuration, including the segment name, duration, and other configuration values.
         * </p>
         * 
         * @param segment
         *        The segment configuration, including the segment name, duration, and other configuration values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segment(Segment segment);

        /**
         * <p>
         * The segment configuration, including the segment name, duration, and other configuration values.
         * </p>
         * This is a convenience method that creates an instance of the {@link Segment.Builder} avoiding the need to
         * create one manually via {@link Segment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Segment.Builder#build()} is called immediately and its result is
         * passed to {@link #segment(Segment)}.
         * 
         * @param segment
         *        a consumer that will call methods on {@link Segment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segment(Segment)
         */
        default Builder segment(Consumer<Segment.Builder> segment) {
            return segment(Segment.builder().applyMutation(segment).build());
        }

        /**
         * <p>
         * Any descriptive information that you want to add to the origin endpoint for future identification purposes.
         * </p>
         * 
         * @param description
         *        Any descriptive information that you want to add to the origin endpoint for future identification
         *        purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The size of the window (in seconds) to create a window of the live stream that's available for on-demand
         * viewing. Viewers can start-over or catch-up on content that falls within the window. The maximum startover
         * window is 1,209,600 seconds (14 days).
         * </p>
         * 
         * @param startoverWindowSeconds
         *        The size of the window (in seconds) to create a window of the live stream that's available for
         *        on-demand viewing. Viewers can start-over or catch-up on content that falls within the window. The
         *        maximum startover window is 1,209,600 seconds (14 days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startoverWindowSeconds(Integer startoverWindowSeconds);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * 
         * @param hlsManifests
         *        An HTTP live streaming (HLS) manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(Collection<CreateHlsManifestConfiguration> hlsManifests);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * 
         * @param hlsManifests
         *        An HTTP live streaming (HLS) manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(CreateHlsManifestConfiguration... hlsManifests);

        /**
         * <p>
         * An HTTP live streaming (HLS) manifest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateHlsManifestConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateHlsManifestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateHlsManifestConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link #hlsManifests(List<CreateHlsManifestConfiguration>)}.
         * 
         * @param hlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateHlsManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsManifests(java.util.Collection<CreateHlsManifestConfiguration>)
         */
        Builder hlsManifests(Consumer<CreateHlsManifestConfiguration.Builder>... hlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * 
         * @param lowLatencyHlsManifests
         *        A low-latency HLS manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowLatencyHlsManifests(Collection<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * 
         * @param lowLatencyHlsManifests
         *        A low-latency HLS manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowLatencyHlsManifests(CreateLowLatencyHlsManifestConfiguration... lowLatencyHlsManifests);

        /**
         * <p>
         * A low-latency HLS manifest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #lowLatencyHlsManifests(List<CreateLowLatencyHlsManifestConfiguration>)}.
         * 
         * @param lowLatencyHlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lowLatencyHlsManifests(java.util.Collection<CreateLowLatencyHlsManifestConfiguration>)
         */
        Builder lowLatencyHlsManifests(Consumer<CreateLowLatencyHlsManifestConfiguration.Builder>... lowLatencyHlsManifests);

        /**
         * <p>
         * A DASH manifest configuration.
         * </p>
         * 
         * @param dashManifests
         *        A DASH manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashManifests(Collection<CreateDashManifestConfiguration> dashManifests);

        /**
         * <p>
         * A DASH manifest configuration.
         * </p>
         * 
         * @param dashManifests
         *        A DASH manifest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashManifests(CreateDashManifestConfiguration... dashManifests);

        /**
         * <p>
         * A DASH manifest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateDashManifestConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateDashManifestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.CreateDashManifestConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dashManifests(List<CreateDashManifestConfiguration>)}.
         * 
         * @param dashManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.CreateDashManifestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashManifests(java.util.Collection<CreateDashManifestConfiguration>)
         */
        Builder dashManifests(Consumer<CreateDashManifestConfiguration.Builder>... dashManifests);

        /**
         * <p>
         * The failover settings for the endpoint.
         * </p>
         * 
         * @param forceEndpointErrorConfiguration
         *        The failover settings for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration forceEndpointErrorConfiguration);

        /**
         * <p>
         * The failover settings for the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ForceEndpointErrorConfiguration.Builder}
         * avoiding the need to create one manually via {@link ForceEndpointErrorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ForceEndpointErrorConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration)}.
         * 
         * @param forceEndpointErrorConfiguration
         *        a consumer that will call methods on {@link ForceEndpointErrorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration)
         */
        default Builder forceEndpointErrorConfiguration(
                Consumer<ForceEndpointErrorConfiguration.Builder> forceEndpointErrorConfiguration) {
            return forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration.builder()
                    .applyMutation(forceEndpointErrorConfiguration).build());
        }

        /**
         * <p>
         * The expected current Entity Tag (ETag) for the resource. If the specified ETag does not match the resource's
         * current entity tag, the update request will be rejected.
         * </p>
         * 
         * @param eTag
         *        The expected current Entity Tag (ETag) for the resource. If the specified ETag does not match the
         *        resource's current entity tag, the update request will be rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageV2Request.BuilderImpl implements Builder {
        private String channelGroupName;

        private String channelName;

        private String originEndpointName;

        private String containerType;

        private Segment segment;

        private String description;

        private Integer startoverWindowSeconds;

        private List<CreateHlsManifestConfiguration> hlsManifests = DefaultSdkAutoConstructList.getInstance();

        private List<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests = DefaultSdkAutoConstructList.getInstance();

        private List<CreateDashManifestConfiguration> dashManifests = DefaultSdkAutoConstructList.getInstance();

        private ForceEndpointErrorConfiguration forceEndpointErrorConfiguration;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOriginEndpointRequest model) {
            super(model);
            channelGroupName(model.channelGroupName);
            channelName(model.channelName);
            originEndpointName(model.originEndpointName);
            containerType(model.containerType);
            segment(model.segment);
            description(model.description);
            startoverWindowSeconds(model.startoverWindowSeconds);
            hlsManifests(model.hlsManifests);
            lowLatencyHlsManifests(model.lowLatencyHlsManifests);
            dashManifests(model.dashManifests);
            forceEndpointErrorConfiguration(model.forceEndpointErrorConfiguration);
            eTag(model.eTag);
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getContainerType() {
            return containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final Segment.Builder getSegment() {
            return segment != null ? segment.toBuilder() : null;
        }

        public final void setSegment(Segment.BuilderImpl segment) {
            this.segment = segment != null ? segment.build() : null;
        }

        @Override
        public final Builder segment(Segment segment) {
            this.segment = segment;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getStartoverWindowSeconds() {
            return startoverWindowSeconds;
        }

        public final void setStartoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
        }

        @Override
        public final Builder startoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
            return this;
        }

        public final List<CreateHlsManifestConfiguration.Builder> getHlsManifests() {
            List<CreateHlsManifestConfiguration.Builder> result = CreateHlsManifestsCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHlsManifests(Collection<CreateHlsManifestConfiguration.BuilderImpl> hlsManifests) {
            this.hlsManifests = CreateHlsManifestsCopier.copyFromBuilder(hlsManifests);
        }

        @Override
        public final Builder hlsManifests(Collection<CreateHlsManifestConfiguration> hlsManifests) {
            this.hlsManifests = CreateHlsManifestsCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(CreateHlsManifestConfiguration... hlsManifests) {
            hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<CreateHlsManifestConfiguration.Builder>... hlsManifests) {
            hlsManifests(Stream.of(hlsManifests).map(c -> CreateHlsManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CreateLowLatencyHlsManifestConfiguration.Builder> getLowLatencyHlsManifests() {
            List<CreateLowLatencyHlsManifestConfiguration.Builder> result = CreateLowLatencyHlsManifestsCopier
                    .copyToBuilder(this.lowLatencyHlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLowLatencyHlsManifests(
                Collection<CreateLowLatencyHlsManifestConfiguration.BuilderImpl> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = CreateLowLatencyHlsManifestsCopier.copyFromBuilder(lowLatencyHlsManifests);
        }

        @Override
        public final Builder lowLatencyHlsManifests(Collection<CreateLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = CreateLowLatencyHlsManifestsCopier.copy(lowLatencyHlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(CreateLowLatencyHlsManifestConfiguration... lowLatencyHlsManifests) {
            lowLatencyHlsManifests(Arrays.asList(lowLatencyHlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(
                Consumer<CreateLowLatencyHlsManifestConfiguration.Builder>... lowLatencyHlsManifests) {
            lowLatencyHlsManifests(Stream.of(lowLatencyHlsManifests)
                    .map(c -> CreateLowLatencyHlsManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CreateDashManifestConfiguration.Builder> getDashManifests() {
            List<CreateDashManifestConfiguration.Builder> result = CreateDashManifestsCopier.copyToBuilder(this.dashManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashManifests(Collection<CreateDashManifestConfiguration.BuilderImpl> dashManifests) {
            this.dashManifests = CreateDashManifestsCopier.copyFromBuilder(dashManifests);
        }

        @Override
        public final Builder dashManifests(Collection<CreateDashManifestConfiguration> dashManifests) {
            this.dashManifests = CreateDashManifestsCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(CreateDashManifestConfiguration... dashManifests) {
            dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<CreateDashManifestConfiguration.Builder>... dashManifests) {
            dashManifests(Stream.of(dashManifests).map(c -> CreateDashManifestConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ForceEndpointErrorConfiguration.Builder getForceEndpointErrorConfiguration() {
            return forceEndpointErrorConfiguration != null ? forceEndpointErrorConfiguration.toBuilder() : null;
        }

        public final void setForceEndpointErrorConfiguration(
                ForceEndpointErrorConfiguration.BuilderImpl forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration != null ? forceEndpointErrorConfiguration
                    .build() : null;
        }

        @Override
        public final Builder forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOriginEndpointRequest build() {
            return new UpdateOriginEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
