/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChannelResponse extends MediaPackageV2Response implements
        ToCopyableBuilder<GetChannelResponse.Builder, GetChannelResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetChannelResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(GetChannelResponse::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(GetChannelResponse::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetChannelResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt").getter(getter(GetChannelResponse::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetChannelResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<IngestEndpoint>> INGEST_ENDPOINTS_FIELD = SdkField
            .<List<IngestEndpoint>> builder(MarshallingType.LIST)
            .memberName("IngestEndpoints")
            .getter(getter(GetChannelResponse::ingestEndpoints))
            .setter(setter(Builder::ingestEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IngestEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(IngestEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputType").getter(getter(GetChannelResponse::inputTypeAsString)).setter(setter(Builder::inputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputType").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(GetChannelResponse::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetChannelResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_NAME_FIELD,
            CHANNEL_GROUP_NAME_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, DESCRIPTION_FIELD, INGEST_ENDPOINTS_FIELD,
            INPUT_TYPE_FIELD, E_TAG_FIELD, TAGS_FIELD));

    private final String arn;

    private final String channelName;

    private final String channelGroupName;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String description;

    private final List<IngestEndpoint> ingestEndpoints;

    private final String inputType;

    private final String eTag;

    private final Map<String, String> tags;

    private GetChannelResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.channelGroupName = builder.channelGroupName;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.description = builder.description;
        this.ingestEndpoints = builder.ingestEndpoints;
        this.inputType = builder.inputType;
        this.eTag = builder.eTag;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for
     * your account in the AWS Region and channel group.
     * </p>
     * 
     * @return The name that describes the channel. The name is the primary identifier for the channel, and must be
     *         unique for your account in the AWS Region and channel group.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be
     * unique for your account in the AWS Region.
     * </p>
     * 
     * @return The name that describes the channel group. The name is the primary identifier for the channel group, and
     *         must be unique for your account in the AWS Region.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The date and time the channel was created.
     * </p>
     * 
     * @return The date and time the channel was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time the channel was modified.
     * </p>
     * 
     * @return The date and time the channel was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The description for your channel.
     * </p>
     * 
     * @return The description for your channel.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the IngestEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIngestEndpoints() {
        return ingestEndpoints != null && !(ingestEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the IngestEndpoints property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIngestEndpoints} method.
     * </p>
     * 
     * @return The value of the IngestEndpoints property for this object.
     */
    public final List<IngestEndpoint> ingestEndpoints() {
        return ingestEndpoints;
    }

    /**
     * <p>
     * The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest
     * or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
     * </p>
     * <p>
     * The allowed values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     * manifests).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link InputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return The input type will be an immutable field which will be used to define whether the channel will allow
     *         CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
     *         <p>
     *         The allowed values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     *         manifests).
     *         </p>
     *         </li>
     * @see InputType
     */
    public final InputType inputType() {
        return InputType.fromValue(inputType);
    }

    /**
     * <p>
     * The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest
     * or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
     * </p>
     * <p>
     * The allowed values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     * manifests).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link InputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return The input type will be an immutable field which will be used to define whether the channel will allow
     *         CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
     *         <p>
     *         The allowed values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     *         manifests).
     *         </p>
     *         </li>
     * @see InputType
     */
    public final String inputTypeAsString() {
        return inputType;
    }

    /**
     * <p>
     * The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make concurrent
     * updates to the resource.
     * </p>
     * 
     * @return The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make
     *         concurrent updates to the resource.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The comma-separated list of tag key:value pairs assigned to the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The comma-separated list of tag key:value pairs assigned to the channel.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasIngestEndpoints() ? ingestEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChannelResponse)) {
            return false;
        }
        GetChannelResponse other = (GetChannelResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(description(), other.description())
                && hasIngestEndpoints() == other.hasIngestEndpoints()
                && Objects.equals(ingestEndpoints(), other.ingestEndpoints())
                && Objects.equals(inputTypeAsString(), other.inputTypeAsString()) && Objects.equals(eTag(), other.eTag())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChannelResponse").add("Arn", arn()).add("ChannelName", channelName())
                .add("ChannelGroupName", channelGroupName()).add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("Description", description()).add("IngestEndpoints", hasIngestEndpoints() ? ingestEndpoints() : null)
                .add("InputType", inputTypeAsString()).add("ETag", eTag()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IngestEndpoints":
            return Optional.ofNullable(clazz.cast(ingestEndpoints()));
        case "InputType":
            return Optional.ofNullable(clazz.cast(inputTypeAsString()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetChannelResponse, T> g) {
        return obj -> g.apply((GetChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetChannelResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique
         * for your account in the AWS Region and channel group.
         * </p>
         * 
         * @param channelName
         *        The name that describes the channel. The name is the primary identifier for the channel, and must be
         *        unique for your account in the AWS Region and channel group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must
         * be unique for your account in the AWS Region.
         * </p>
         * 
         * @param channelGroupName
         *        The name that describes the channel group. The name is the primary identifier for the channel group,
         *        and must be unique for your account in the AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The date and time the channel was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time the channel was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time the channel was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The description for your channel.
         * </p>
         * 
         * @param description
         *        The description for your channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the IngestEndpoints property for this object.
         *
         * @param ingestEndpoints
         *        The new value for the IngestEndpoints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestEndpoints(Collection<IngestEndpoint> ingestEndpoints);

        /**
         * Sets the value of the IngestEndpoints property for this object.
         *
         * @param ingestEndpoints
         *        The new value for the IngestEndpoints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestEndpoints(IngestEndpoint... ingestEndpoints);

        /**
         * Sets the value of the IngestEndpoints property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.IngestEndpoint.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mediapackagev2.model.IngestEndpoint#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.IngestEndpoint.Builder#build()} is called
         * immediately and its result is passed to {@link #ingestEndpoints(List<IngestEndpoint>)}.
         * 
         * @param ingestEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.IngestEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestEndpoints(java.util.Collection<IngestEndpoint>)
         */
        Builder ingestEndpoints(Consumer<IngestEndpoint.Builder>... ingestEndpoints);

        /**
         * <p>
         * The input type will be an immutable field which will be used to define whether the channel will allow CMAF
         * ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
         * </p>
         * <p>
         * The allowed values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
         * manifests).
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputType
         *        The input type will be an immutable field which will be used to define whether the channel will allow
         *        CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
         *        <p>
         *        The allowed values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional
         *        DASH manifests).
         *        </p>
         *        </li>
         * @see InputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputType
         */
        Builder inputType(String inputType);

        /**
         * <p>
         * The input type will be an immutable field which will be used to define whether the channel will allow CMAF
         * ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
         * </p>
         * <p>
         * The allowed values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
         * manifests).
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputType
         *        The input type will be an immutable field which will be used to define whether the channel will allow
         *        CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
         *        <p>
         *        The allowed values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional
         *        DASH manifests).
         *        </p>
         *        </li>
         * @see InputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputType
         */
        Builder inputType(InputType inputType);

        /**
         * <p>
         * The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make
         * concurrent updates to the resource.
         * </p>
         * 
         * @param eTag
         *        The current Entity Tag (ETag) associated with this resource. The entity tag can be used to safely make
         *        concurrent updates to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The comma-separated list of tag key:value pairs assigned to the channel.
         * </p>
         * 
         * @param tags
         *        The comma-separated list of tag key:value pairs assigned to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaPackageV2Response.BuilderImpl implements Builder {
        private String arn;

        private String channelName;

        private String channelGroupName;

        private Instant createdAt;

        private Instant modifiedAt;

        private String description;

        private List<IngestEndpoint> ingestEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String inputType;

        private String eTag;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetChannelResponse model) {
            super(model);
            arn(model.arn);
            channelName(model.channelName);
            channelGroupName(model.channelGroupName);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            description(model.description);
            ingestEndpoints(model.ingestEndpoints);
            inputType(model.inputType);
            eTag(model.eTag);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<IngestEndpoint.Builder> getIngestEndpoints() {
            List<IngestEndpoint.Builder> result = IngestEndpointListCopier.copyToBuilder(this.ingestEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngestEndpoints(Collection<IngestEndpoint.BuilderImpl> ingestEndpoints) {
            this.ingestEndpoints = IngestEndpointListCopier.copyFromBuilder(ingestEndpoints);
        }

        @Override
        public final Builder ingestEndpoints(Collection<IngestEndpoint> ingestEndpoints) {
            this.ingestEndpoints = IngestEndpointListCopier.copy(ingestEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpoints(IngestEndpoint... ingestEndpoints) {
            ingestEndpoints(Arrays.asList(ingestEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpoints(Consumer<IngestEndpoint.Builder>... ingestEndpoints) {
            ingestEndpoints(Stream.of(ingestEndpoints).map(c -> IngestEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInputType() {
            return inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(InputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetChannelResponse build() {
            return new GetChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
