/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract
 * defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption
 * contract, specify which audio and video encryption presets to use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionContractConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionContractConfiguration.Builder, EncryptionContractConfiguration> {
    private static final SdkField<String> PRESET_SPEKE20_AUDIO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PresetSpeke20Audio").getter(getter(EncryptionContractConfiguration::presetSpeke20AudioAsString))
            .setter(setter(Builder::presetSpeke20Audio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetSpeke20Audio").build())
            .build();

    private static final SdkField<String> PRESET_SPEKE20_VIDEO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PresetSpeke20Video").getter(getter(EncryptionContractConfiguration::presetSpeke20VideoAsString))
            .setter(setter(Builder::presetSpeke20Video))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetSpeke20Video").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRESET_SPEKE20_AUDIO_FIELD,
            PRESET_SPEKE20_VIDEO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String presetSpeke20Audio;

    private final String presetSpeke20Video;

    private EncryptionContractConfiguration(BuilderImpl builder) {
        this.presetSpeke20Audio = builder.presetSpeke20Audio;
        this.presetSpeke20Video = builder.presetSpeke20Video;
    }

    /**
     * <p>
     * A collection of audio encryption presets.
     * </p>
     * <p>
     * Value description:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt all
     * of the multichannel audio tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt all of
     * the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the multichannel audio
     * tracks with more than 6 channels.
     * </p>
     * </li>
     * <li>
     * <p>
     * SHARED - Use the same content key for all of the audio and video tracks in your stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #presetSpeke20Audio} will return {@link PresetSpeke20Audio#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #presetSpeke20AudioAsString}.
     * </p>
     * 
     * @return A collection of audio encryption presets.</p>
     *         <p>
     *         Value description:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to
     *         encrypt all of the multichannel audio tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to
     *         encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of
     *         the multichannel audio tracks with more than 6 channels.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SHARED - Use the same content key for all of the audio and video tracks in your stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
     *         </p>
     *         </li>
     * @see PresetSpeke20Audio
     */
    public final PresetSpeke20Audio presetSpeke20Audio() {
        return PresetSpeke20Audio.fromValue(presetSpeke20Audio);
    }

    /**
     * <p>
     * A collection of audio encryption presets.
     * </p>
     * <p>
     * Value description:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt all
     * of the multichannel audio tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt all of
     * the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the multichannel audio
     * tracks with more than 6 channels.
     * </p>
     * </li>
     * <li>
     * <p>
     * SHARED - Use the same content key for all of the audio and video tracks in your stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #presetSpeke20Audio} will return {@link PresetSpeke20Audio#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #presetSpeke20AudioAsString}.
     * </p>
     * 
     * @return A collection of audio encryption presets.</p>
     *         <p>
     *         Value description:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to
     *         encrypt all of the multichannel audio tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to
     *         encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of
     *         the multichannel audio tracks with more than 6 channels.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SHARED - Use the same content key for all of the audio and video tracks in your stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
     *         </p>
     *         </li>
     * @see PresetSpeke20Audio
     */
    public final String presetSpeke20AudioAsString() {
        return presetSpeke20Audio;
    }

    /**
     * <p>
     * A collection of video encryption presets.
     * </p>
     * <p>
     * Value description:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all HD and
     * higher resolutions video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks
     * and one content key for all UHD video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks,
     * one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks,
     * one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2
     * video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks,
     * one content key for HD2 video tracks and one content key for all UHD video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video
     * tracks and one content key for all UHD video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video
     * tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * SHARED - Use the same content key for all of the video and audio tracks in your stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #presetSpeke20Video} will return {@link PresetSpeke20Video#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #presetSpeke20VideoAsString}.
     * </p>
     * 
     * @return A collection of video encryption presets.</p>
     *         <p>
     *         Value description:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all HD
     *         and higher resolutions video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD video
     *         tracks and one content key for all UHD video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD video
     *         tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video
     *         tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content
     *         key for all UHD2 video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video
     *         tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2
     *         video tracks and one content key for all UHD video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2
     *         video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SHARED - Use the same content key for all of the video and audio tracks in your stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
     *         </p>
     *         </li>
     * @see PresetSpeke20Video
     */
    public final PresetSpeke20Video presetSpeke20Video() {
        return PresetSpeke20Video.fromValue(presetSpeke20Video);
    }

    /**
     * <p>
     * A collection of video encryption presets.
     * </p>
     * <p>
     * Value description:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all HD and
     * higher resolutions video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks
     * and one content key for all UHD video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks,
     * one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks,
     * one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2
     * video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks,
     * one content key for HD2 video tracks and one content key for all UHD video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video
     * tracks and one content key for all UHD video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video
     * tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     * </p>
     * </li>
     * <li>
     * <p>
     * SHARED - Use the same content key for all of the video and audio tracks in your stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #presetSpeke20Video} will return {@link PresetSpeke20Video#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #presetSpeke20VideoAsString}.
     * </p>
     * 
     * @return A collection of video encryption presets.</p>
     *         <p>
     *         Value description:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all HD
     *         and higher resolutions video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD video
     *         tracks and one content key for all UHD video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD video
     *         tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video
     *         tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content
     *         key for all UHD2 video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video
     *         tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2
     *         video tracks and one content key for all UHD video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2
     *         video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SHARED - Use the same content key for all of the video and audio tracks in your stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
     *         </p>
     *         </li>
     * @see PresetSpeke20Video
     */
    public final String presetSpeke20VideoAsString() {
        return presetSpeke20Video;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(presetSpeke20AudioAsString());
        hashCode = 31 * hashCode + Objects.hashCode(presetSpeke20VideoAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionContractConfiguration)) {
            return false;
        }
        EncryptionContractConfiguration other = (EncryptionContractConfiguration) obj;
        return Objects.equals(presetSpeke20AudioAsString(), other.presetSpeke20AudioAsString())
                && Objects.equals(presetSpeke20VideoAsString(), other.presetSpeke20VideoAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionContractConfiguration").add("PresetSpeke20Audio", presetSpeke20AudioAsString())
                .add("PresetSpeke20Video", presetSpeke20VideoAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PresetSpeke20Audio":
            return Optional.ofNullable(clazz.cast(presetSpeke20AudioAsString()));
        case "PresetSpeke20Video":
            return Optional.ofNullable(clazz.cast(presetSpeke20VideoAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionContractConfiguration, T> g) {
        return obj -> g.apply((EncryptionContractConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionContractConfiguration> {
        /**
         * <p>
         * A collection of audio encryption presets.
         * </p>
         * <p>
         * Value description:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt
         * all of the multichannel audio tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt
         * all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the
         * multichannel audio tracks with more than 6 channels.
         * </p>
         * </li>
         * <li>
         * <p>
         * SHARED - Use the same content key for all of the audio and video tracks in your stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
         * </p>
         * </li>
         * </ul>
         * 
         * @param presetSpeke20Audio
         *        A collection of audio encryption presets.</p>
         *        <p>
         *        Value description:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to
         *        encrypt all of the multichannel audio tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to
         *        encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all
         *        of the multichannel audio tracks with more than 6 channels.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SHARED - Use the same content key for all of the audio and video tracks in your stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
         *        </p>
         *        </li>
         * @see PresetSpeke20Audio
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PresetSpeke20Audio
         */
        Builder presetSpeke20Audio(String presetSpeke20Audio);

        /**
         * <p>
         * A collection of audio encryption presets.
         * </p>
         * <p>
         * Value description:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt
         * all of the multichannel audio tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt
         * all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the
         * multichannel audio tracks with more than 6 channels.
         * </p>
         * </li>
         * <li>
         * <p>
         * SHARED - Use the same content key for all of the audio and video tracks in your stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
         * </p>
         * </li>
         * </ul>
         * 
         * @param presetSpeke20Audio
         *        A collection of audio encryption presets.</p>
         *        <p>
         *        Value description:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to
         *        encrypt all of the multichannel audio tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to
         *        encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all
         *        of the multichannel audio tracks with more than 6 channels.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SHARED - Use the same content key for all of the audio and video tracks in your stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
         *        </p>
         *        </li>
         * @see PresetSpeke20Audio
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PresetSpeke20Audio
         */
        Builder presetSpeke20Audio(PresetSpeke20Audio presetSpeke20Audio);

        /**
         * <p>
         * A collection of video encryption presets.
         * </p>
         * <p>
         * Value description:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all HD and
         * higher resolutions video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD video
         * tracks and one content key for all UHD video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD video
         * tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video
         * tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key
         * for all UHD2 video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video
         * tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video
         * tracks and one content key for all UHD video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video
         * tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * SHARED - Use the same content key for all of the video and audio tracks in your stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
         * </p>
         * </li>
         * </ul>
         * 
         * @param presetSpeke20Video
         *        A collection of video encryption presets.</p>
         *        <p>
         *        Value description:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all
         *        HD and higher resolutions video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD
         *        video tracks and one content key for all UHD video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD
         *        video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1
         *        video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one
         *        content key for all UHD2 video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1
         *        video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for
         *        HD2 video tracks and one content key for all UHD video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for
         *        HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video
         *        tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SHARED - Use the same content key for all of the video and audio tracks in your stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
         *        </p>
         *        </li>
         * @see PresetSpeke20Video
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PresetSpeke20Video
         */
        Builder presetSpeke20Video(String presetSpeke20Video);

        /**
         * <p>
         * A collection of video encryption presets.
         * </p>
         * <p>
         * Value description:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all HD and
         * higher resolutions video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD video
         * tracks and one content key for all UHD video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD video
         * tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video
         * tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key
         * for all UHD2 video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video
         * tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video
         * tracks and one content key for all UHD video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video
         * tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
         * </p>
         * </li>
         * <li>
         * <p>
         * SHARED - Use the same content key for all of the video and audio tracks in your stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
         * </p>
         * </li>
         * </ul>
         * 
         * @param presetSpeke20Video
         *        A collection of video encryption presets.</p>
         *        <p>
         *        Value description:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all
         *        HD and higher resolutions video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD
         *        video tracks and one content key for all UHD video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD
         *        video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1
         *        video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one
         *        content key for all UHD2 video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1
         *        video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for
         *        HD2 video tracks and one content key for all UHD video tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for
         *        HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video
         *        tracks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SHARED - Use the same content key for all of the video and audio tracks in your stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
         *        </p>
         *        </li>
         * @see PresetSpeke20Video
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PresetSpeke20Video
         */
        Builder presetSpeke20Video(PresetSpeke20Video presetSpeke20Video);
    }

    static final class BuilderImpl implements Builder {
        private String presetSpeke20Audio;

        private String presetSpeke20Video;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionContractConfiguration model) {
            presetSpeke20Audio(model.presetSpeke20Audio);
            presetSpeke20Video(model.presetSpeke20Video);
        }

        public final String getPresetSpeke20Audio() {
            return presetSpeke20Audio;
        }

        public final void setPresetSpeke20Audio(String presetSpeke20Audio) {
            this.presetSpeke20Audio = presetSpeke20Audio;
        }

        @Override
        public final Builder presetSpeke20Audio(String presetSpeke20Audio) {
            this.presetSpeke20Audio = presetSpeke20Audio;
            return this;
        }

        @Override
        public final Builder presetSpeke20Audio(PresetSpeke20Audio presetSpeke20Audio) {
            this.presetSpeke20Audio(presetSpeke20Audio == null ? null : presetSpeke20Audio.toString());
            return this;
        }

        public final String getPresetSpeke20Video() {
            return presetSpeke20Video;
        }

        public final void setPresetSpeke20Video(String presetSpeke20Video) {
            this.presetSpeke20Video = presetSpeke20Video;
        }

        @Override
        public final Builder presetSpeke20Video(String presetSpeke20Video) {
            this.presetSpeke20Video = presetSpeke20Video;
            return this;
        }

        @Override
        public final Builder presetSpeke20Video(PresetSpeke20Video presetSpeke20Video) {
            this.presetSpeke20Video(presetSpeke20Video == null ? null : presetSpeke20Video.toString());
            return this;
        }

        @Override
        public EncryptionContractConfiguration build() {
            return new EncryptionContractConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
