/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelListConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelListConfiguration.Builder, ChannelListConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ChannelListConfiguration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(ChannelListConfiguration::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(ChannelListConfiguration::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ChannelListConfiguration::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt").getter(getter(ChannelListConfiguration::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ChannelListConfiguration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputType").getter(getter(ChannelListConfiguration::inputTypeAsString))
            .setter(setter(Builder::inputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_NAME_FIELD,
            CHANNEL_GROUP_NAME_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, DESCRIPTION_FIELD, INPUT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String channelName;

    private final String channelGroupName;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String description;

    private final String inputType;

    private ChannelListConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.channelGroupName = builder.channelGroupName;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.description = builder.description;
        this.inputType = builder.inputType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name that describes the channel. The name is the primary identifier for the channel, and must be unique for
     * your account in the AWS Region and channel group.
     * </p>
     * 
     * @return The name that describes the channel. The name is the primary identifier for the channel, and must be
     *         unique for your account in the AWS Region and channel group.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name that describes the channel group. The name is the primary identifier for the channel group, and must be
     * unique for your account in the AWS Region.
     * </p>
     * 
     * @return The name that describes the channel group. The name is the primary identifier for the channel group, and
     *         must be unique for your account in the AWS Region.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The date and time the channel was created.
     * </p>
     * 
     * @return The date and time the channel was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time the channel was modified.
     * </p>
     * 
     * @return The date and time the channel was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * Any descriptive information that you want to add to the channel for future identification purposes.
     * </p>
     * 
     * @return Any descriptive information that you want to add to the channel for future identification purposes.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest
     * or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
     * </p>
     * <p>
     * The allowed values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     * manifests).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link InputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return The input type will be an immutable field which will be used to define whether the channel will allow
     *         CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
     *         <p>
     *         The allowed values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     *         manifests).
     *         </p>
     *         </li>
     * @see InputType
     */
    public final InputType inputType() {
        return InputType.fromValue(inputType);
    }

    /**
     * <p>
     * The input type will be an immutable field which will be used to define whether the channel will allow CMAF ingest
     * or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
     * </p>
     * <p>
     * The allowed values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     * manifests).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link InputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return The input type will be an immutable field which will be used to define whether the channel will allow
     *         CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
     *         <p>
     *         The allowed values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
     *         manifests).
     *         </p>
     *         </li>
     * @see InputType
     */
    public final String inputTypeAsString() {
        return inputType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(inputTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelListConfiguration)) {
            return false;
        }
        ChannelListConfiguration other = (ChannelListConfiguration) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(description(), other.description())
                && Objects.equals(inputTypeAsString(), other.inputTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelListConfiguration").add("Arn", arn()).add("ChannelName", channelName())
                .add("ChannelGroupName", channelGroupName()).add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("Description", description()).add("InputType", inputTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "InputType":
            return Optional.ofNullable(clazz.cast(inputTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("InputType", INPUT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelListConfiguration, T> g) {
        return obj -> g.apply((ChannelListConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelListConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name that describes the channel. The name is the primary identifier for the channel, and must be unique
         * for your account in the AWS Region and channel group.
         * </p>
         * 
         * @param channelName
         *        The name that describes the channel. The name is the primary identifier for the channel, and must be
         *        unique for your account in the AWS Region and channel group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name that describes the channel group. The name is the primary identifier for the channel group, and must
         * be unique for your account in the AWS Region.
         * </p>
         * 
         * @param channelGroupName
         *        The name that describes the channel group. The name is the primary identifier for the channel group,
         *        and must be unique for your account in the AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The date and time the channel was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time the channel was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time the channel was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * Any descriptive information that you want to add to the channel for future identification purposes.
         * </p>
         * 
         * @param description
         *        Any descriptive information that you want to add to the channel for future identification purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The input type will be an immutable field which will be used to define whether the channel will allow CMAF
         * ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
         * </p>
         * <p>
         * The allowed values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
         * manifests).
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputType
         *        The input type will be an immutable field which will be used to define whether the channel will allow
         *        CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
         *        <p>
         *        The allowed values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional
         *        DASH manifests).
         *        </p>
         *        </li>
         * @see InputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputType
         */
        Builder inputType(String inputType);

        /**
         * <p>
         * The input type will be an immutable field which will be used to define whether the channel will allow CMAF
         * ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.
         * </p>
         * <p>
         * The allowed values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional DASH
         * manifests).
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputType
         *        The input type will be an immutable field which will be used to define whether the channel will allow
         *        CMAF ingest or HLS ingest. If unprovided, it will default to HLS to preserve current behavior.</p>
         *        <p>
         *        The allowed values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HLS</code> - The HLS streaming specification (which defines M3U8 manifests and TS segments).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CMAF</code> - The DASH-IF CMAF Ingest specification (which defines CMAF segments with optional
         *        DASH manifests).
         *        </p>
         *        </li>
         * @see InputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputType
         */
        Builder inputType(InputType inputType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String channelName;

        private String channelGroupName;

        private Instant createdAt;

        private Instant modifiedAt;

        private String description;

        private String inputType;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelListConfiguration model) {
            arn(model.arn);
            channelName(model.channelName);
            channelGroupName(model.channelGroupName);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            description(model.description);
            inputType(model.inputType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInputType() {
            return inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(InputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        @Override
        public ChannelListConfiguration build() {
            return new ChannelListConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
