/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of harvested manifests of different types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HarvestedManifests implements SdkPojo, Serializable,
        ToCopyableBuilder<HarvestedManifests.Builder, HarvestedManifests> {
    private static final SdkField<List<HarvestedHlsManifest>> HLS_MANIFESTS_FIELD = SdkField
            .<List<HarvestedHlsManifest>> builder(MarshallingType.LIST)
            .memberName("HlsManifests")
            .getter(getter(HarvestedManifests::hlsManifests))
            .setter(setter(Builder::hlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HarvestedHlsManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(HarvestedHlsManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HarvestedDashManifest>> DASH_MANIFESTS_FIELD = SdkField
            .<List<HarvestedDashManifest>> builder(MarshallingType.LIST)
            .memberName("DashManifests")
            .getter(getter(HarvestedManifests::dashManifests))
            .setter(setter(Builder::dashManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HarvestedDashManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(HarvestedDashManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HarvestedLowLatencyHlsManifest>> LOW_LATENCY_HLS_MANIFESTS_FIELD = SdkField
            .<List<HarvestedLowLatencyHlsManifest>> builder(MarshallingType.LIST)
            .memberName("LowLatencyHlsManifests")
            .getter(getter(HarvestedManifests::lowLatencyHlsManifests))
            .setter(setter(Builder::lowLatencyHlsManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowLatencyHlsManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HarvestedLowLatencyHlsManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(HarvestedLowLatencyHlsManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_MANIFESTS_FIELD,
            DASH_MANIFESTS_FIELD, LOW_LATENCY_HLS_MANIFESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<HarvestedHlsManifest> hlsManifests;

    private final List<HarvestedDashManifest> dashManifests;

    private final List<HarvestedLowLatencyHlsManifest> lowLatencyHlsManifests;

    private HarvestedManifests(BuilderImpl builder) {
        this.hlsManifests = builder.hlsManifests;
        this.dashManifests = builder.dashManifests;
        this.lowLatencyHlsManifests = builder.lowLatencyHlsManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the HlsManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHlsManifests() {
        return hlsManifests != null && !(hlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of harvested HLS manifests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHlsManifests} method.
     * </p>
     * 
     * @return A list of harvested HLS manifests.
     */
    public final List<HarvestedHlsManifest> hlsManifests() {
        return hlsManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the DashManifests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDashManifests() {
        return dashManifests != null && !(dashManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of harvested DASH manifests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashManifests} method.
     * </p>
     * 
     * @return A list of harvested DASH manifests.
     */
    public final List<HarvestedDashManifest> dashManifests() {
        return dashManifests;
    }

    /**
     * For responses, this returns true if the service returned a value for the LowLatencyHlsManifests property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLowLatencyHlsManifests() {
        return lowLatencyHlsManifests != null && !(lowLatencyHlsManifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of harvested Low-Latency HLS manifests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLowLatencyHlsManifests} method.
     * </p>
     * 
     * @return A list of harvested Low-Latency HLS manifests.
     */
    public final List<HarvestedLowLatencyHlsManifest> lowLatencyHlsManifests() {
        return lowLatencyHlsManifests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHlsManifests() ? hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDashManifests() ? dashManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLowLatencyHlsManifests() ? lowLatencyHlsManifests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HarvestedManifests)) {
            return false;
        }
        HarvestedManifests other = (HarvestedManifests) obj;
        return hasHlsManifests() == other.hasHlsManifests() && Objects.equals(hlsManifests(), other.hlsManifests())
                && hasDashManifests() == other.hasDashManifests() && Objects.equals(dashManifests(), other.dashManifests())
                && hasLowLatencyHlsManifests() == other.hasLowLatencyHlsManifests()
                && Objects.equals(lowLatencyHlsManifests(), other.lowLatencyHlsManifests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HarvestedManifests").add("HlsManifests", hasHlsManifests() ? hlsManifests() : null)
                .add("DashManifests", hasDashManifests() ? dashManifests() : null)
                .add("LowLatencyHlsManifests", hasLowLatencyHlsManifests() ? lowLatencyHlsManifests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HlsManifests":
            return Optional.ofNullable(clazz.cast(hlsManifests()));
        case "DashManifests":
            return Optional.ofNullable(clazz.cast(dashManifests()));
        case "LowLatencyHlsManifests":
            return Optional.ofNullable(clazz.cast(lowLatencyHlsManifests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HlsManifests", HLS_MANIFESTS_FIELD);
        map.put("DashManifests", DASH_MANIFESTS_FIELD);
        map.put("LowLatencyHlsManifests", LOW_LATENCY_HLS_MANIFESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HarvestedManifests, T> g) {
        return obj -> g.apply((HarvestedManifests) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HarvestedManifests> {
        /**
         * <p>
         * A list of harvested HLS manifests.
         * </p>
         * 
         * @param hlsManifests
         *        A list of harvested HLS manifests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(Collection<HarvestedHlsManifest> hlsManifests);

        /**
         * <p>
         * A list of harvested HLS manifests.
         * </p>
         * 
         * @param hlsManifests
         *        A list of harvested HLS manifests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsManifests(HarvestedHlsManifest... hlsManifests);

        /**
         * <p>
         * A list of harvested HLS manifests.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedHlsManifest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedHlsManifest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedHlsManifest.Builder#build()} is called
         * immediately and its result is passed to {@link #hlsManifests(List<HarvestedHlsManifest>)}.
         * 
         * @param hlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedHlsManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsManifests(java.util.Collection<HarvestedHlsManifest>)
         */
        Builder hlsManifests(Consumer<HarvestedHlsManifest.Builder>... hlsManifests);

        /**
         * <p>
         * A list of harvested DASH manifests.
         * </p>
         * 
         * @param dashManifests
         *        A list of harvested DASH manifests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashManifests(Collection<HarvestedDashManifest> dashManifests);

        /**
         * <p>
         * A list of harvested DASH manifests.
         * </p>
         * 
         * @param dashManifests
         *        A list of harvested DASH manifests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashManifests(HarvestedDashManifest... dashManifests);

        /**
         * <p>
         * A list of harvested DASH manifests.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedDashManifest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedDashManifest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedDashManifest.Builder#build()} is called
         * immediately and its result is passed to {@link #dashManifests(List<HarvestedDashManifest>)}.
         * 
         * @param dashManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedDashManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashManifests(java.util.Collection<HarvestedDashManifest>)
         */
        Builder dashManifests(Consumer<HarvestedDashManifest.Builder>... dashManifests);

        /**
         * <p>
         * A list of harvested Low-Latency HLS manifests.
         * </p>
         * 
         * @param lowLatencyHlsManifests
         *        A list of harvested Low-Latency HLS manifests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowLatencyHlsManifests(Collection<HarvestedLowLatencyHlsManifest> lowLatencyHlsManifests);

        /**
         * <p>
         * A list of harvested Low-Latency HLS manifests.
         * </p>
         * 
         * @param lowLatencyHlsManifests
         *        A list of harvested Low-Latency HLS manifests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowLatencyHlsManifests(HarvestedLowLatencyHlsManifest... lowLatencyHlsManifests);

        /**
         * <p>
         * A list of harvested Low-Latency HLS manifests.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedLowLatencyHlsManifest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedLowLatencyHlsManifest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedLowLatencyHlsManifest.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #lowLatencyHlsManifests(List<HarvestedLowLatencyHlsManifest>)}.
         * 
         * @param lowLatencyHlsManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediapackagev2.model.HarvestedLowLatencyHlsManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lowLatencyHlsManifests(java.util.Collection<HarvestedLowLatencyHlsManifest>)
         */
        Builder lowLatencyHlsManifests(Consumer<HarvestedLowLatencyHlsManifest.Builder>... lowLatencyHlsManifests);
    }

    static final class BuilderImpl implements Builder {
        private List<HarvestedHlsManifest> hlsManifests = DefaultSdkAutoConstructList.getInstance();

        private List<HarvestedDashManifest> dashManifests = DefaultSdkAutoConstructList.getInstance();

        private List<HarvestedLowLatencyHlsManifest> lowLatencyHlsManifests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HarvestedManifests model) {
            hlsManifests(model.hlsManifests);
            dashManifests(model.dashManifests);
            lowLatencyHlsManifests(model.lowLatencyHlsManifests);
        }

        public final List<HarvestedHlsManifest.Builder> getHlsManifests() {
            List<HarvestedHlsManifest.Builder> result = HarvestedHlsManifestsListCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHlsManifests(Collection<HarvestedHlsManifest.BuilderImpl> hlsManifests) {
            this.hlsManifests = HarvestedHlsManifestsListCopier.copyFromBuilder(hlsManifests);
        }

        @Override
        public final Builder hlsManifests(Collection<HarvestedHlsManifest> hlsManifests) {
            this.hlsManifests = HarvestedHlsManifestsListCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(HarvestedHlsManifest... hlsManifests) {
            hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<HarvestedHlsManifest.Builder>... hlsManifests) {
            hlsManifests(Stream.of(hlsManifests).map(c -> HarvestedHlsManifest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<HarvestedDashManifest.Builder> getDashManifests() {
            List<HarvestedDashManifest.Builder> result = HarvestedDashManifestsListCopier.copyToBuilder(this.dashManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashManifests(Collection<HarvestedDashManifest.BuilderImpl> dashManifests) {
            this.dashManifests = HarvestedDashManifestsListCopier.copyFromBuilder(dashManifests);
        }

        @Override
        public final Builder dashManifests(Collection<HarvestedDashManifest> dashManifests) {
            this.dashManifests = HarvestedDashManifestsListCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(HarvestedDashManifest... dashManifests) {
            dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<HarvestedDashManifest.Builder>... dashManifests) {
            dashManifests(Stream.of(dashManifests).map(c -> HarvestedDashManifest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<HarvestedLowLatencyHlsManifest.Builder> getLowLatencyHlsManifests() {
            List<HarvestedLowLatencyHlsManifest.Builder> result = HarvestedLowLatencyHlsManifestsListCopier
                    .copyToBuilder(this.lowLatencyHlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLowLatencyHlsManifests(Collection<HarvestedLowLatencyHlsManifest.BuilderImpl> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = HarvestedLowLatencyHlsManifestsListCopier.copyFromBuilder(lowLatencyHlsManifests);
        }

        @Override
        public final Builder lowLatencyHlsManifests(Collection<HarvestedLowLatencyHlsManifest> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = HarvestedLowLatencyHlsManifestsListCopier.copy(lowLatencyHlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(HarvestedLowLatencyHlsManifest... lowLatencyHlsManifests) {
            lowLatencyHlsManifests(Arrays.asList(lowLatencyHlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(Consumer<HarvestedLowLatencyHlsManifest.Builder>... lowLatencyHlsManifests) {
            lowLatencyHlsManifests(Stream.of(lowLatencyHlsManifests)
                    .map(c -> HarvestedLowLatencyHlsManifest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public HarvestedManifests build() {
            return new HarvestedManifests(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
